/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.potion_effects.all.TeleportProtection;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class PlayerUtils {
    public static BlockPos getBedLocation(PlayerEntity player) {
        Optional opt;
        BlockPos pos = null;
        if (pos == null && (opt = player.func_213374_dv()).isPresent()) {
            pos = (BlockPos)opt.get();
        }
        if (pos == null) {
            pos = player.getBedLocation(player.field_70170_p.func_201675_m().func_186058_p());
        }
        if (pos == null) {
            pos = player.func_180470_cg();
        }
        return pos;
    }

    public static void sendPlayersMSGofStructureSpawnTEST(BlockPos pos, String name) {
        if (MMORPG.RUN_DEV_TOOLS) {
            for (ServerPlayerEntity player : MapManager.getServer().func_184103_al().func_181057_v()) {
                player.func_145747_a((ITextComponent)new StringTextComponent(name + " Structure spawned at : " + pos.toString()));
            }
        }
    }

    public static Entity changeDimension(ServerPlayerEntity player, DimensionType destination, BlockPos pos) {
        if (!ForgeHooks.onTravelToDimension((Entity)player, (DimensionType)destination)) {
            return null;
        }
        player.field_184851_cj = true;
        DimensionType dimensiontype = player.field_71093_bK;
        if (dimensiontype == DimensionType.field_223229_c_ && destination == DimensionType.field_223227_a_) {
            player.func_213319_R();
            player.func_71121_q().func_217434_e(player);
            if (!player.field_71136_j) {
                player.field_71136_j = true;
            }
            return player;
        }
        ServerWorld serverworld = player.field_71133_b.func_71218_a(dimensiontype);
        player.field_71093_bK = destination;
        ServerWorld serverworld1 = player.field_71133_b.func_71218_a(destination);
        WorldInfo worldinfo = player.field_70170_p.func_72912_H();
        player.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(destination, worldinfo.func_76067_t(), player.field_71134_c.func_73081_b()));
        player.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        PlayerList playerlist = player.field_71133_b.func_184103_al();
        playerlist.func_187243_f(player);
        serverworld.removeEntity((Entity)player, true);
        player.revive();
        float f1 = player.field_70177_z;
        serverworld.func_217381_Z().func_76320_a("moving");
        player.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), f1, 0.0f);
        player.func_195064_c(new EffectInstance((Effect)TeleportProtection.INSTANCE, 200));
        serverworld.func_217381_Z().func_76319_b();
        player.func_70029_a((World)serverworld1);
        serverworld1.func_217447_b(player);
        player.func_213846_b(serverworld);
        player.field_71135_a.func_147364_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), f1, 0.0f);
        player.field_71134_c.func_73080_a(serverworld1);
        player.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        playerlist.func_72354_b(player, serverworld1);
        playerlist.func_72385_f(player);
        for (EffectInstance effectinstance : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), effectinstance));
        }
        player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)player, (DimensionType)dimensiontype, (DimensionType)destination);
        return player;
    }

    public static PlayerEntity nearestPlayer(ServerWorld world, LivingEntity entity) {
        Optional<ServerPlayerEntity> player = world.func_217369_A().stream().min(Comparator.comparingDouble(arg_0 -> ((LivingEntity)entity).func_70068_e(arg_0)));
        if (player.isPresent()) {
            return (PlayerEntity)player.get();
        }
        return null;
    }

    public static CompoundNBT getPersistentNBT(PlayerEntity player) {
        CompoundNBT nbt = null;
        try {
            CompoundNBT basenbt = player.getPersistentData();
            if (basenbt != null) {
                nbt = basenbt;
            }
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
        }
        catch (Exception e) {
            nbt = new CompoundNBT();
            e.printStackTrace();
        }
        return nbt;
    }

    public static void setPestistentNBT(PlayerEntity player, CompoundNBT nbt) {
        player.getPersistentData().func_218657_a("PlayerPersisted", (INBT)nbt);
    }
}

