/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.item_classes.IInstability;
import com.robertx22.mine_and_slash.uncommon.capability.EntityCap;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RepairUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class TooltipUtils {
    public static String CHECKMARK = TextFormatting.GREEN + "\u2714";
    public static String X = TextFormatting.RED + "\u2716";

    public static List<String> compsToStrings(List<ITextComponent> list) {
        return list.stream().map(ITextComponent::func_150254_d).collect(Collectors.toList());
    }

    public static ITextComponent instability(IInstability insta) {
        ITextComponent comp = Styles.REDCOMP().func_150257_a(Words.Instability.locName().func_150258_a(": " + insta.getInstability() + "/" + insta.getMaxInstability()));
        if (insta.usesBreakChance()) {
            comp.func_150258_a(" ").func_150257_a(Styles.REDCOMP().func_150257_a(Words.BreakChance.locName().func_150258_a(": " + insta.getBreakChance() + "%")));
        }
        return comp;
    }

    public static ITextComponent level(int lvl) {
        return new StringTextComponent(TextFormatting.YELLOW + "").func_150257_a(Words.Level.locName()).func_150258_a(": " + lvl);
    }

    public static List<String> cutIfTooLong(String str) {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int i = 0;
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        for (int j = 0; j < n; ++j) {
            Character c = Character.valueOf(cArray[j]);
            if (i == str.length() - 1) {
                list.add(str.substring(start));
            } else if (i - start > 25 && c.charValue() == ' ') {
                String cut = str.substring(start, i);
                if (start > 0) {
                    cut = cut.substring(1);
                }
                list.add(cut);
                start = i;
            }
            ++i;
        }
        return list;
    }

    public static ITextComponent itemBrokenText(ItemStack stack, ICommonDataItem data) {
        if (data != null && RepairUtils.isItemBroken(stack)) {
            ITextComponent comp = new StringTextComponent(X + " ").func_150257_a(Words.Broken.locName());
            return comp;
        }
        return null;
    }

    public static ITextComponent requirement(ITextComponent text, int stat, int req) {
        StringTextComponent comp = stat >= req ? new StringTextComponent(CHECKMARK) : new StringTextComponent(X);
        return comp.func_150257_a(new StringTextComponent(TextFormatting.GRAY + " ").func_150257_a(text).func_150258_a(": " + req));
    }

    public static ITextComponent lvlReq(int lvl, EntityCap.UnitData player) {
        return TooltipUtils.requirement((ITextComponent)new StringTextComponent("Lvl Req"), player.getLevel(), lvl);
    }

    public static List<ITextComponent> removeDoubleBlankLines(List<ITextComponent> list, int minLinesCutAllBlanks) {
        ArrayList<ITextComponent> newt = new ArrayList<ITextComponent>();
        boolean lastIsEmpty = false;
        boolean alwaysRemoveEmpty = list.size() > minLinesCutAllBlanks;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).func_150254_d().length() > 2) {
                lastIsEmpty = false;
                newt.add(list.get(i));
                continue;
            }
            if (!lastIsEmpty && !alwaysRemoveEmpty) {
                newt.add(list.get(i));
            }
            lastIsEmpty = true;
        }
        return newt;
    }

    public static ITextComponent rarity(Rarity rarity) {
        return new StringTextComponent(rarity.textFormatColor() + "").func_150257_a(Words.Rarity.locName().func_150258_a(": ").func_150257_a(rarity.locName()));
    }

    public static ITextComponent tier(int tier) {
        return Styles.YELLOWCOMP().func_150257_a(Words.Tier.locName()).func_150258_a(": " + tier);
    }
}

