/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.world_gen.processors;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.robertx22.mine_and_slash.database.world_providers.BirchForestIWP;
import com.robertx22.mine_and_slash.database.world_providers.IWP;
import com.robertx22.mine_and_slash.db_lists.initializers.WorldProviders;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class BiomeProcessor
extends StructureProcessor {
    IWP iwp;

    public BiomeProcessor(IWP iwp) {
        this.iwp = iwp;
    }

    public BiomeProcessor(Biome biome) {
        this.iwp = WorldProviders.byBiome(biome);
    }

    public BiomeProcessor(Dynamic<?> dynamic) {
        this.iwp = SlashRegistry.WorldProviders().get(dynamic.get("iwp").asString(new BirchForestIWP(null, null).GUID()));
    }

    @Nullable
    public Template.BlockInfo func_215194_a(IWorldReader iWorldReader, BlockPos blockPos, Template.BlockInfo blockInfo, Template.BlockInfo blockInfo1, PlacementSettings placementSettings) {
        Block block = blockInfo1.field_186243_b.func_177230_c();
        if (this.iwp.biomeTheme().blocksReplaceMap.containsKey(block)) {
            BlockState newstate = this.iwp.biomeTheme().blocksReplaceMap.get(block).getBlockToReplaceWith(block).func_176223_P();
            for (IProperty prop : blockInfo1.field_186243_b.func_206869_a()) {
                if (!newstate.func_196959_b(prop)) continue;
                newstate = (BlockState)newstate.func_206870_a(prop, blockInfo.field_186243_b.func_177229_b(prop));
            }
            return new Template.BlockInfo(blockInfo1.field_186242_a, newstate, blockInfo1.field_186244_c);
        }
        return blockInfo1;
    }

    protected IStructureProcessorType func_215192_a() {
        return IStructureProcessorType.field_214924_f;
    }

    protected <T> Dynamic<T> func_215193_a(DynamicOps<T> dynamicOps) {
        return new Dynamic(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("iwp"), (Object)dynamicOps.createString(this.iwp.GUID()))));
    }
}

