/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.world_gen.structures.bases;

import com.robertx22.mine_and_slash.database.world_providers.IWP;
import com.robertx22.mine_and_slash.db_lists.initializers.WorldProviders;
import com.robertx22.mine_and_slash.db_lists.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import com.robertx22.mine_and_slash.world_gen.structures.bases.StructurePieceData;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public abstract class TemplatePiece
extends TemplateStructurePiece {
    public ResourceLocation resourceLocation;
    public Rotation field_186169_c;
    public int height = 0;
    public IWP iwp;
    public String guid = "";
    public boolean canBeInWater = true;
    public int surfaceHeight = 0;
    int lowerIntoGroundBy = 0;

    public abstract List<StructureProcessor> processors();

    public TemplatePiece(IStructurePieceType type, TemplateManager templateManager, CompoundNBT nbt) {
        super(type, nbt);
        this.loadFromNBT(nbt);
        this.setupTemplateManager(templateManager);
    }

    public void loadFromNBT(CompoundNBT nbt) {
        this.resourceLocation = new ResourceLocation(nbt.func_74779_i("Template"));
        this.field_186169_c = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
        this.height = nbt.func_74762_e("num");
        this.iwp = SlashRegistry.WorldProviders().get(nbt.func_74779_i("iwp"));
        this.surfaceHeight = nbt.func_74762_e("surfaceHeight");
        this.lowerIntoGroundBy = nbt.func_74762_e("lowerby");
        this.guid = nbt.func_74779_i("guid");
        this.canBeInWater = nbt.func_74767_n("canInWater");
    }

    public TemplatePiece(StructurePieceData data) {
        super(data.type, 0);
        this.resourceLocation = data.resourceLocation;
        this.height = data.height;
        this.field_186178_c = data.blockPos.func_177982_a(0, data.height, 0);
        this.field_186169_c = data.rotation;
        this.iwp = WorldProviders.byBiome(data.biome);
        this.guid = data.guid;
        this.lowerIntoGroundBy = data.lowerIntoGroundBy;
        this.setupTemplateManager(data.templateManager);
    }

    public PlacementSettings setupPlacementSettings() {
        PlacementSettings placementSettings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_207665_a(new BlockPos(0, this.height, 0)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        for (StructureProcessor proc : this.processors()) {
            placementSettings.func_215222_a(proc);
        }
        return placementSettings;
    }

    public void setupTemplateManager(TemplateManager templateManager) {
        Template template = templateManager.func_200220_a(this.resourceLocation);
        PlacementSettings placementSettings = this.setupPlacementSettings();
        this.func_186173_a(template, this.field_186178_c, placementSettings);
    }

    protected void func_143011_b(CompoundNBT nbt) {
        super.func_143011_b(nbt);
        nbt.func_74778_a("Template", this.resourceLocation.toString());
        nbt.func_74778_a("Rot", this.field_186169_c.name());
        nbt.func_74768_a("num", this.height);
        nbt.func_74768_a("surfaceHeight", this.surfaceHeight);
        nbt.func_74778_a("iwp", this.iwp.GUID());
        nbt.func_74768_a("lowerby", this.lowerIntoGroundBy);
        nbt.func_74778_a("guid", this.guid);
        nbt.func_74757_a("canInWater", this.canBeInWater);
    }

    public boolean func_74875_a(IWorld iworld, Random ran, MutableBoundingBox boundingbox, ChunkPos chunkPos) {
        IWP iwp = WorldUtils.getIWP(iworld);
        if (iwp != null) {
            PlacementSettings placeSettings = this.setupPlacementSettings();
            BlockPos pos = this.field_186178_c.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)placeSettings, (BlockPos)new BlockPos(0, 0, 0)));
            if (!this.canBeInWater && WorldUtils.surfaceIsWater(iworld, pos)) {
                return false;
            }
            if (this.surfaceHeight == 0) {
                this.surfaceHeight = TemplatePiece.getAverageSurfaceHeight(iworld, this.field_186176_a, this.field_186178_c);
            }
            BlockPos templatePosition = this.field_186178_c;
            this.field_186178_c = this.field_186178_c.func_177982_a(0, this.surfaceHeight - 90 - this.lowerIntoGroundBy, 0);
            boolean addedParts = super.func_74875_a(iworld, ran, boundingbox, chunkPos);
            this.field_186178_c = templatePosition;
            return addedParts;
        }
        return false;
    }

    public static int getAverageSurfaceHeight(IWorld world, Template template, BlockPos templatePosition) {
        float height = 0.0f;
        BlockPos structureSize = templatePosition.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, template.func_186259_a().func_177952_p() - 1);
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)templatePosition, (BlockPos)structureSize)) {
            int k = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177958_n(), pos.func_177952_p());
            height += (float)k;
        }
        height = height / (float)(template.func_186259_a().func_177958_n() * template.func_186259_a().func_177952_p()) - 1.0f;
        return (int)height;
    }

    protected void func_186175_a(String s, BlockPos blockPos, IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox) {
    }
}

