/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.util;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.fabricmc.loader.util.version.VersionParsingException;
import org.apache.commons.lang3.RandomStringUtils;

public class TestModContainer
implements ModContainer {
    public static final Random RAND = new Random();
    private static Collection<ModContainer> testModContainers;
    private final ModMetadata metadata = new TestModMetadata();
    private final Path rootPath = ((ModContainer)FabricLoader.getInstance().getModContainer("fabricloader").orElseThrow(IllegalStateException::new)).getRootPath();

    public static Collection<ModContainer> getTestModContainers() {
        if (testModContainers == null) {
            testModContainers = new ArrayList<ModContainer>();
            for (int i = 0; i < 1000; ++i) {
                testModContainers.add(new TestModContainer());
            }
        }
        return testModContainers;
    }

    public ModMetadata getMetadata() {
        return this.metadata;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public static class TestModMetadata
    implements ModMetadata {
        private final String id = RandomStringUtils.randomAlphabetic((int)10, (int)50).toLowerCase(Locale.ROOT);
        private final String description = RandomStringUtils.randomAlphabetic((int)500);
        private final Version version;

        public TestModMetadata() {
            try {
                this.version = SemanticVersion.parse((String)String.format("%d.%d.%d+%s", RAND.nextInt(10), RAND.nextInt(50), RAND.nextInt(200), RandomStringUtils.randomAlphanumeric((int)2, (int)10)));
            }
            catch (VersionParsingException e) {
                throw new AssertionError("Generated version is not semantic", e);
            }
        }

        public String getType() {
            return "test";
        }

        public String getId() {
            return this.id;
        }

        public Version getVersion() {
            return this.version;
        }

        public Collection<ModDependency> getDepends() {
            return Collections.emptyList();
        }

        public Collection<ModDependency> getRecommends() {
            return Collections.emptyList();
        }

        public Collection<ModDependency> getSuggests() {
            return Collections.emptyList();
        }

        public Collection<ModDependency> getConflicts() {
            return Collections.emptyList();
        }

        public Collection<ModDependency> getBreaks() {
            return Collections.emptyList();
        }

        public String getName() {
            return this.getId();
        }

        public String getDescription() {
            return this.description;
        }

        public Collection<Person> getAuthors() {
            return Collections.emptyList();
        }

        public Collection<Person> getContributors() {
            return Collections.emptyList();
        }

        public ContactInformation getContact() {
            return ContactInformation.EMPTY;
        }

        public Collection<String> getLicense() {
            return Collections.emptyList();
        }

        public Optional<String> getIconPath(int size) {
            return Optional.empty();
        }

        public boolean containsCustomElement(String key) {
            return false;
        }

        public JsonElement getCustomElement(String key) {
            return null;
        }

        public boolean containsCustomValue(String key) {
            return false;
        }

        public CustomValue getCustomValue(String key) {
            return null;
        }
    }
}

