/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block.tile;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.BlockCamo;
import me.desht.modularrouters.block.BlockItemRouter;
import me.desht.modularrouters.block.tile.ICamouflageable;
import me.desht.modularrouters.client.render.item_beam.ItemBeam;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.container.ContainerItemRouter;
import me.desht.modularrouters.container.handler.BufferHandler;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModTileEntities;
import me.desht.modularrouters.event.TickEventHandler;
import me.desht.modularrouters.item.module.DetectorModule;
import me.desht.modularrouters.item.module.FluidModule1;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.upgrade.ItemUpgrade;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.network.RouterUpgradesSyncMessage;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityItemRouter
extends TileEntity
implements ITickableTileEntity,
ICamouflageable,
INamedContainerProvider {
    private static final int N_MODULE_SLOTS = 9;
    private static final int N_UPGRADE_SLOTS = 5;
    private static final int N_BUFFER_SLOTS = 1;
    public static final int COMPILE_MODULES = 1;
    public static final int COMPILE_UPGRADES = 2;
    private static final String NBT_ACTIVE = "Active";
    private static final String NBT_ACTIVE_TIMER = "ActiveTimer";
    private static final String NBT_ECO_MODE = "EcoMode";
    private static final String NBT_BUFFER = "Buffer";
    public static final String NBT_MODULES = "Modules";
    public static final String NBT_UPGRADES = "Upgrades";
    private static final String NBT_EXTRA = "Extra";
    public static final String NBT_REDSTONE_MODE = "Redstone";
    private int counter = 0;
    private int pulseCounter = 0;
    private RouterRedstoneBehaviour redstoneBehaviour = RouterRedstoneBehaviour.ALWAYS;
    private final BufferHandler bufferHandler = new BufferHandler(this);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.bufferHandler);
    private final ItemStackHandler modulesHandler = new ModuleHandler();
    private final ItemStackHandler upgradesHandler = new UpgradeHandler();
    private final List<CompiledModule> compiledModules = new ArrayList<CompiledModule>();
    private byte recompileNeeded = (byte)3;
    private int tickRate = MRConfig.Common.Router.baseTickRate;
    private int itemsPerTick = 1;
    private final Map<ResourceLocation, Integer> upgradeCount = new HashMap<ResourceLocation, Integer>();
    private int fluidTransferRate;
    private int fluidTransferRemainingIn = 0;
    private int fluidTransferRemainingOut = 0;
    private final int SIDES = Direction.values().length;
    private final int[] redstoneLevels = new int[this.SIDES];
    private final int[] newRedstoneLevels = new int[this.SIDES];
    private final DetectorModule.SignalType[] signalType = new DetectorModule.SignalType[this.SIDES];
    private final DetectorModule.SignalType[] newSignalType = new DetectorModule.SignalType[this.SIDES];
    private boolean canEmit;
    private boolean prevCanEmit;
    private int redstonePower = -1;
    private int lastPower;
    private boolean active;
    private int activeTimer = 0;
    private final Set<UUID> permitted = Sets.newHashSet();
    private byte sidesOpen;
    private boolean ecoMode = false;
    private int ecoCounter = MRConfig.Common.Router.ecoTimeout;
    private boolean hasPulsedModules = false;
    private CompoundNBT extData;
    private BlockState camouflage = null;
    private int tunedSyncValue = -1;
    private boolean executing;
    public final List<ItemBeam> beams = new ArrayList<ItemBeam>();
    private AxisAlignedBB cachedRenderAABB;

    public TileEntityItemRouter() {
        super((TileEntityType)ModTileEntities.ITEM_ROUTER.get());
    }

    public IItemHandler getBuffer() {
        return this.bufferHandler;
    }

    public IItemHandler getModules() {
        return this.modulesHandler;
    }

    public IItemHandler getUpgrades() {
        return this.upgradesHandler;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("x", this.field_174879_c.func_177958_n());
        compound.func_74768_a("y", this.field_174879_c.func_177956_o());
        compound.func_74768_a("z", this.field_174879_c.func_177952_p());
        if (this.camouflage != null) {
            compound.func_218657_a("BlockStateName", (INBT)NBTUtil.func_190009_a((BlockState)this.camouflage));
        }
        return compound;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.processClientSync(tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.processClientSync(pkt.func_148857_g());
    }

    private void processClientSync(CompoundNBT compound) {
        if (compound.func_74764_b("BlockStateName")) {
            this.setCamouflage(NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("BlockStateName")));
        } else {
            this.setCamouflage(null);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.inventoryCap);
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, this.bufferHandler.getFluidCapability());
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, this.bufferHandler.getFluidItemCapability());
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, this.bufferHandler.getEnergyCapability());
        }
        return super.getCapability(cap, side);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.bufferHandler.deserializeNBT(nbt.func_74775_l(NBT_BUFFER));
        this.modulesHandler.deserializeNBT(nbt.func_74775_l(NBT_MODULES));
        this.upgradesHandler.deserializeNBT(nbt.func_74775_l(NBT_UPGRADES));
        try {
            this.redstoneBehaviour = RouterRedstoneBehaviour.valueOf(nbt.func_74779_i(NBT_REDSTONE_MODE));
        }
        catch (IllegalArgumentException e) {
            this.redstoneBehaviour = RouterRedstoneBehaviour.ALWAYS;
        }
        this.active = nbt.func_74767_n(NBT_ACTIVE);
        this.activeTimer = nbt.func_74762_e(NBT_ACTIVE_TIMER);
        this.ecoMode = nbt.func_74767_n(NBT_ECO_MODE);
        CompoundNBT ext = nbt.func_74775_l(NBT_EXTRA);
        CompoundNBT ext1 = this.getExtData();
        for (String key : ext.func_150296_c()) {
            ext1.func_218657_a(key, ext.func_74781_a(key));
        }
        this.counter = -1;
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_218657_a(NBT_BUFFER, (INBT)this.bufferHandler.serializeNBT());
        if (this.hasItems((IItemHandler)this.modulesHandler)) {
            nbt.func_218657_a(NBT_MODULES, (INBT)this.modulesHandler.serializeNBT());
        }
        if (this.hasItems((IItemHandler)this.upgradesHandler)) {
            nbt.func_218657_a(NBT_UPGRADES, (INBT)this.upgradesHandler.serializeNBT());
        }
        if (this.redstoneBehaviour != RouterRedstoneBehaviour.ALWAYS) {
            nbt.func_74778_a(NBT_REDSTONE_MODE, this.redstoneBehaviour.name());
        }
        nbt.func_74757_a(NBT_ACTIVE, this.active);
        nbt.func_74768_a(NBT_ACTIVE_TIMER, this.activeTimer);
        nbt.func_74757_a(NBT_ECO_MODE, this.ecoMode);
        CompoundNBT ext = new CompoundNBT();
        CompoundNBT ext1 = this.getExtData();
        for (String key : ext1.func_150296_c()) {
            ext.func_218657_a(key, ext1.func_74781_a(key));
        }
        nbt.func_218657_a(NBT_EXTRA, (INBT)ext);
        return nbt;
    }

    private boolean hasItems(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            Iterator<ItemBeam> iterator = this.beams.iterator();
            while (iterator.hasNext()) {
                ItemBeam beam = iterator.next();
                beam.tick();
                if (!beam.isExpired()) continue;
                iterator.remove();
                this.cachedRenderAABB = null;
            }
        } else {
            if (this.recompileNeeded != 0) {
                this.compile();
            }
            ++this.counter;
            ++this.pulseCounter;
            if (this.getRedstoneBehaviour() == RouterRedstoneBehaviour.PULSE) {
                if (this.activeTimer > 0 && --this.activeTimer == 0) {
                    this.setActive(false);
                }
            } else if (this.counter >= this.getTickRate()) {
                this.allocateFluidTransfer(this.counter);
                this.executeModules(false);
                this.counter = 0;
            }
            if (this.ecoMode) {
                if (this.active) {
                    this.ecoCounter = MRConfig.Common.Router.ecoTimeout;
                } else if (this.ecoCounter > 0) {
                    --this.ecoCounter;
                }
            }
        }
    }

    private void executeModules(boolean pulsed) {
        boolean powered;
        this.executing = true;
        boolean newActive = false;
        boolean bl = powered = pulsed || this.getRedstonePower() > 0;
        if (this.redstoneBehaviour.shouldRun(powered, pulsed)) {
            if (this.prevCanEmit || this.canEmit) {
                Arrays.fill(this.newRedstoneLevels, 0);
                Arrays.fill((Object[])this.newSignalType, (Object)DetectorModule.SignalType.NONE);
            }
            for (CompiledModule cm : this.compiledModules) {
                if (cm == null || !cm.hasTarget() || !cm.shouldRun(powered, pulsed) || !cm.execute(this)) continue;
                newActive = true;
                if (!cm.termination()) continue;
                break;
            }
            if (this.prevCanEmit || this.canEmit) {
                this.handleRedstoneEmission();
            }
        }
        this.setActive(newActive);
        this.prevCanEmit = this.canEmit;
        this.executing = false;
    }

    public int getTickRate() {
        return this.ecoMode && this.ecoCounter == 0 ? MRConfig.Common.Router.lowPowerTickRate : this.tickRate;
    }

    public RouterRedstoneBehaviour getRedstoneBehaviour() {
        return this.redstoneBehaviour;
    }

    public void setRedstoneBehaviour(RouterRedstoneBehaviour redstoneBehaviour) {
        this.redstoneBehaviour = redstoneBehaviour;
        if (redstoneBehaviour == RouterRedstoneBehaviour.PULSE) {
            this.lastPower = this.getRedstonePower();
        }
        this.handleSync(false);
    }

    private void setActive(boolean newActive) {
        if (this.active != newActive) {
            this.active = newActive;
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockItemRouter.ACTIVE, (Comparable)Boolean.valueOf(newActive && this.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) < 3)), 2);
        }
    }

    private void setSidesOpen(byte sidesOpen) {
        if (this.sidesOpen != sidesOpen) {
            this.sidesOpen = sidesOpen;
            this.handleSync(true);
        }
    }

    public void setEcoMode(boolean newEco) {
        if (newEco != this.ecoMode) {
            this.ecoMode = newEco;
            this.ecoCounter = MRConfig.Common.Router.ecoTimeout;
        }
    }

    @Override
    public BlockState getCamouflage() {
        return this.camouflage;
    }

    @Override
    public void setCamouflage(BlockState newCamouflage) {
        if (newCamouflage != this.camouflage) {
            this.camouflage = newCamouflage;
            this.handleSync(true);
        }
    }

    private void handleSync(boolean renderUpdate) {
        if (!this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        } else if (this.func_145831_w().field_72995_K && renderUpdate) {
            this.requestModelDataUpdate();
            this.func_145831_w().func_225319_b(this.field_174879_c, Blocks.field_150350_a.func_176223_P(), this.func_195044_w());
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(BlockCamo.CAMOUFLAGE_STATE, (Object)this.camouflage).build();
    }

    private void compile() {
        this.compileUpgrades();
        this.compileModules();
        if (this.tunedSyncValue >= 0) {
            this.counter = this.calculateSyncCounter();
        } else if (this.counter < 0) {
            this.counter = new Random().nextInt(this.tickRate);
        }
        BlockState state = this.func_195044_w();
        this.func_145831_w().func_195593_d(this.field_174879_c, state.func_177230_c());
        this.func_70296_d();
        this.recompileNeeded = 0;
    }

    private void compileModules() {
        if ((this.recompileNeeded & 1) != 0) {
            this.setHasPulsedModules(false);
            byte newSidesOpen = 0;
            for (CompiledModule cm : this.compiledModules) {
                cm.cleanup(this);
            }
            this.compiledModules.clear();
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.modulesHandler.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof ItemModule)) continue;
                CompiledModule cms = ((ItemModule)stack.func_77973_b()).compile(this, stack);
                this.compiledModules.add(cms);
                cms.onCompiled(this);
                newSidesOpen = (byte)(newSidesOpen | cms.getDirection().getMask());
            }
            this.setSidesOpen(newSidesOpen);
        }
    }

    private void compileUpgrades() {
        if (this.field_145850_b.field_72995_K || (this.recompileNeeded & 2) != 0) {
            int prevMufflers = this.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get());
            this.upgradeCount.clear();
            this.permitted.clear();
            this.setCamouflage(null);
            this.tunedSyncValue = -1;
            for (int i = 0; i < 5; ++i) {
                ItemStack stack = this.upgradesHandler.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof ItemUpgrade)) continue;
                this.upgradeCount.put(stack.func_77973_b().getRegistryName(), this.getUpgradeCount(stack.func_77973_b()) + stack.func_190916_E());
                ((ItemUpgrade)stack.func_77973_b()).onCompiled(stack, this);
            }
            this.itemsPerTick = 1 << Math.min(6, this.getUpgradeCount((Item)ModItems.STACK_UPGRADE.get()));
            this.tickRate = Math.max(MRConfig.Common.Router.hardMinTickRate, MRConfig.Common.Router.baseTickRate - MRConfig.Common.Router.ticksPerUpgrade * this.getUpgradeCount((Item)ModItems.SPEED_UPGRADE.get()));
            this.fluidTransferRate = Math.min(MRConfig.Common.Router.fluidMaxTransferRate, MRConfig.Common.Router.fluidBaseTransferRate + this.getUpgradeCount((Item)ModItems.FLUID_UPGRADE.get()) * MRConfig.Common.Router.mBperFluidUpgade);
            if (!this.field_145850_b.field_72995_K) {
                int mufflers = this.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get());
                if (prevMufflers != mufflers) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockItemRouter.ACTIVE, (Comparable)Boolean.valueOf(this.active && mufflers < 3)), 2);
                }
                this.notifyWatchingPlayers();
            }
        }
    }

    private void notifyWatchingPlayers() {
        for (PlayerEntity player : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.func_174877_v()).func_186662_g(5.0))) {
            if (!(player.field_71070_bA instanceof ContainerItemRouter) || ((ContainerItemRouter)player.field_71070_bA).getRouter() != this) continue;
            PacketHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new RouterUpgradesSyncMessage(this));
        }
    }

    public void setTunedSyncValue(int newValue) {
        this.tunedSyncValue = newValue;
    }

    private int calculateSyncCounter() {
        int tuning = this.tunedSyncValue % this.tickRate;
        int compileTime = (int)TickEventHandler.TickCounter % this.tickRate;
        int delta = tuning - compileTime;
        if (delta <= 0) {
            delta += this.tickRate;
        }
        return this.tickRate - delta;
    }

    public void setAllowRedstoneEmission(boolean allow) {
        this.canEmit = allow;
        this.func_145831_w().func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockItemRouter.CAN_EMIT, (Comparable)Boolean.valueOf(this.canEmit)));
    }

    public int getUpgradeCount(Item type) {
        return this.upgradeCount.getOrDefault(type.getRegistryName(), 0);
    }

    public void recompileNeeded(int what) {
        this.recompileNeeded = (byte)(this.recompileNeeded | what);
    }

    public int getItemsPerTick() {
        return this.itemsPerTick;
    }

    private void allocateFluidTransfer(int ticks) {
        int maxTransfer = MRConfig.Common.Router.baseTickRate * this.fluidTransferRate;
        this.fluidTransferRemainingIn = Math.min(this.fluidTransferRemainingIn + ticks * this.fluidTransferRate, maxTransfer);
        this.fluidTransferRemainingOut = Math.min(this.fluidTransferRemainingOut + ticks * this.fluidTransferRate, maxTransfer);
    }

    public int getFluidTransferRate() {
        return this.fluidTransferRate;
    }

    public int getCurrentFluidTransferAllowance(FluidModule1.FluidDirection dir) {
        return dir == FluidModule1.FluidDirection.IN ? this.fluidTransferRemainingIn : this.fluidTransferRemainingOut;
    }

    public void transferredFluid(int amount, FluidModule1.FluidDirection dir) {
        switch (dir) {
            case IN: {
                if (this.fluidTransferRemainingIn < amount) {
                    ModularRouters.LOGGER.warn("fluid transfer: " + this.fluidTransferRemainingIn + " < " + amount);
                }
                this.fluidTransferRemainingIn = Math.max(0, this.fluidTransferRemainingIn - amount);
                break;
            }
            case OUT: {
                if (this.fluidTransferRemainingOut < amount) {
                    ModularRouters.LOGGER.warn("fluid transfer: " + this.fluidTransferRemainingOut + " < " + amount);
                }
                this.fluidTransferRemainingOut = Math.max(0, this.fluidTransferRemainingOut - amount);
                break;
            }
        }
    }

    public Direction getAbsoluteFacing(ItemModule.RelativeDirection direction) {
        return direction.toAbsolute((Direction)this.func_195044_w().func_177229_b((Property)BlockItemRouter.FACING));
    }

    public ItemStack getBufferItemStack() {
        return this.bufferHandler.getStackInSlot(0);
    }

    public void checkForRedstonePulse() {
        this.redstonePower = this.calculateIncomingRedstonePower(this.field_174879_c);
        if (this.executing) {
            return;
        }
        if (this.redstoneBehaviour == RouterRedstoneBehaviour.PULSE || this.hasPulsedModules && this.redstoneBehaviour == RouterRedstoneBehaviour.ALWAYS) {
            if (this.redstonePower > this.lastPower && this.pulseCounter >= this.tickRate) {
                this.allocateFluidTransfer(Math.min(this.pulseCounter, MRConfig.Common.Router.baseTickRate));
                this.executeModules(true);
                this.pulseCounter = 0;
                if (this.active) {
                    this.activeTimer = this.tickRate;
                }
            }
            this.lastPower = this.redstonePower;
        }
    }

    public void emitRedstone(ItemModule.RelativeDirection direction, int power, DetectorModule.SignalType signalType) {
        if (direction == ItemModule.RelativeDirection.NONE) {
            Arrays.fill(this.newRedstoneLevels, power);
            Arrays.fill((Object[])this.newSignalType, (Object)signalType);
        } else {
            Direction facing = this.getAbsoluteFacing(direction).func_176734_d();
            this.newRedstoneLevels[facing.ordinal()] = power;
            this.newSignalType[facing.ordinal()] = signalType;
        }
    }

    public int getRedstoneLevel(Direction facing, boolean strong) {
        if (!this.canEmit) {
            return -1;
        }
        int i = facing.ordinal();
        if (strong) {
            return this.signalType[i] == DetectorModule.SignalType.STRONG ? this.redstoneLevels[i] : 0;
        }
        return this.signalType[i] != DetectorModule.SignalType.NONE ? this.redstoneLevels[i] : 0;
    }

    private void handleRedstoneEmission() {
        boolean notifyOwnNeighbours = false;
        EnumSet<Direction> toNotify = EnumSet.noneOf(Direction.class);
        if (!this.canEmit) {
            notifyOwnNeighbours = true;
            for (Direction f : Direction.values()) {
                if (this.signalType[f.ordinal()] != DetectorModule.SignalType.STRONG) continue;
                toNotify.add(f.func_176734_d());
            }
            Arrays.fill(this.redstoneLevels, 0);
            Arrays.fill((Object[])this.signalType, (Object)DetectorModule.SignalType.NONE);
        } else {
            for (Direction facing : Direction.values()) {
                int i = facing.ordinal();
                if (this.newSignalType[i] != this.signalType[i]) {
                    toNotify.add(facing.func_176734_d());
                    this.signalType[i] = this.newSignalType[i];
                }
                if (this.newRedstoneLevels[i] == this.redstoneLevels[i]) continue;
                notifyOwnNeighbours = true;
                if (this.newSignalType[i] == DetectorModule.SignalType.STRONG) {
                    toNotify.add(facing.func_176734_d());
                }
                this.redstoneLevels[i] = this.newRedstoneLevels[i];
            }
        }
        for (Direction f : toNotify) {
            BlockPos pos2 = this.field_174879_c.func_177972_a(f);
            this.func_145831_w().func_195593_d(pos2, this.func_145831_w().func_180495_p(pos2).func_177230_c());
        }
        if (notifyOwnNeighbours) {
            this.func_145831_w().func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    public void addPermittedIds(Set<UUID> permittedIds) {
        this.permitted.addAll(permittedIds);
    }

    public boolean isPermitted(PlayerEntity player) {
        if (this.permitted.isEmpty() || this.permitted.contains(player.func_110124_au())) {
            return true;
        }
        for (Hand hand : Hand.values()) {
            if (player.func_184586_b(hand).func_77973_b() != ModItems.OVERRIDE_CARD.get()) continue;
            return true;
        }
        return false;
    }

    public boolean isBufferFull() {
        ItemStack stack = this.bufferHandler.getStackInSlot(0);
        return !stack.func_190926_b() && stack.func_190916_E() >= stack.func_77976_d();
    }

    public boolean isBufferEmpty() {
        return this.bufferHandler.getStackInSlot(0).func_190926_b();
    }

    public ItemStack peekBuffer(int amount) {
        return this.bufferHandler.extractItem(0, amount, true);
    }

    public ItemStack extractBuffer(int amount) {
        return this.bufferHandler.extractItem(0, amount, false);
    }

    public ItemStack insertBuffer(ItemStack stack) {
        return this.bufferHandler.insertItem(0, stack, false);
    }

    public void setBufferItemStack(ItemStack stack) {
        this.bufferHandler.setStackInSlot(0, stack);
    }

    public boolean getEcoMode() {
        return this.ecoMode;
    }

    public void setHasPulsedModules(boolean hasPulsedModules) {
        this.hasPulsedModules = hasPulsedModules;
    }

    public int getRedstonePower() {
        if (this.redstonePower < 0) {
            this.redstonePower = this.calculateIncomingRedstonePower(this.field_174879_c);
        }
        return this.redstonePower;
    }

    private int calculateIncomingRedstonePower(BlockPos pos) {
        int power = 0;
        for (Direction facing : Direction.values()) {
            if (this.getExtData().func_74762_e("ExtruderDist" + facing) > 0) continue;
            int p = this.func_145831_w().func_175651_c(pos.func_177972_a(facing), facing);
            if (p >= 15) {
                return p;
            }
            if (p <= power) continue;
            power = p;
        }
        return power;
    }

    public CompoundNBT getExtData() {
        if (this.extData == null) {
            this.extData = new CompoundNBT();
        }
        return this.extData;
    }

    public static Optional<TileEntityItemRouter> getRouterAt(IBlockReader world, BlockPos routerPos) {
        TileEntity te = world.func_175625_s(routerPos);
        return te instanceof TileEntityItemRouter ? Optional.of((TileEntityItemRouter)te) : Optional.empty();
    }

    public void playSound(PlayerEntity player, BlockPos pos, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        if (this.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) == 0) {
            this.func_145831_w().func_184133_a(player, pos, sound, category, volume, pitch);
        }
    }

    public void notifyModules() {
        for (CompiledModule cm : this.compiledModules) {
            cm.onNeighbourChange(this);
        }
    }

    public int getModuleSlotCount() {
        return 9;
    }

    public int getUpgradeSlotCount() {
        return 5;
    }

    public int getBufferSlotCount() {
        return 1;
    }

    public int getModuleCount() {
        return this.compiledModules.size();
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.modularrouters.item_router");
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerItemRouter(windowId, playerInventory, this.func_174877_v());
    }

    public GlobalPos getGlobalPos() {
        return MiscUtil.makeGlobalPos(this.field_145850_b, this.field_174879_c);
    }

    public void setUpgradesFrom(IItemHandler handler) {
        if (handler.getSlots() == this.upgradesHandler.getSlots()) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                this.upgradesHandler.setStackInSlot(i, handler.getStackInSlot(i));
            }
        }
        this.compileUpgrades();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.cachedRenderAABB == null) {
            this.cachedRenderAABB = super.getRenderBoundingBox();
            this.beams.forEach(beam -> {
                this.cachedRenderAABB = this.cachedRenderAABB.func_111270_a(beam.getAABB());
            });
        }
        return this.cachedRenderAABB;
    }

    public void addItemBeam(ItemBeam itemBeam) {
        this.beams.add(itemBeam);
        this.cachedRenderAABB = null;
    }

    class UpgradeHandler
    extends RouterItemHandler {
        UpgradeHandler() {
            super(2, TileEntityItemRouter.this.getUpgradeSlotCount(), s -> s.func_77973_b() instanceof ItemUpgrade);
        }

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            for (int i = 0; i < this.getSlots(); ++i) {
                if (slot == i || stack.func_77973_b() != this.getStackInSlot(i).func_77973_b()) continue;
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            if (!(stack.func_77973_b() instanceof ItemUpgrade)) {
                return 0;
            }
            return ((ItemUpgrade)stack.func_77973_b()).getStackLimit(slot);
        }
    }

    class ModuleHandler
    extends RouterItemHandler {
        ModuleHandler() {
            super(1, TileEntityItemRouter.this.getModuleSlotCount(), s -> s.func_77973_b() instanceof ItemModule);
        }
    }

    abstract class RouterItemHandler
    extends ItemStackHandler {
        private final Predicate<ItemStack> validator;
        private final int flag;

        private RouterItemHandler(int flag, int size, Predicate<ItemStack> validator) {
            super(size);
            this.validator = validator;
            this.flag = flag;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return super.isItemValid(slot, stack) && this.validator.test(stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityItemRouter.this.recompileNeeded(this.flag);
        }
    }
}

