/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client;

import me.desht.modularrouters.client.gui.GuiItemRouter;
import me.desht.modularrouters.client.gui.MouseOverHelp;
import me.desht.modularrouters.client.gui.filter.FilterGuiFactory;
import me.desht.modularrouters.client.gui.filter.GuiBulkItemFilter;
import me.desht.modularrouters.client.gui.filter.GuiInspectionFilter;
import me.desht.modularrouters.client.gui.filter.GuiModFilter;
import me.desht.modularrouters.client.gui.filter.GuiRegexFilter;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.module.GuiModuleActivator;
import me.desht.modularrouters.client.gui.module.GuiModuleDetector;
import me.desht.modularrouters.client.gui.module.GuiModuleDistributor;
import me.desht.modularrouters.client.gui.module.GuiModuleExtruder2;
import me.desht.modularrouters.client.gui.module.GuiModuleFlinger;
import me.desht.modularrouters.client.gui.module.GuiModuleFluid;
import me.desht.modularrouters.client.gui.module.GuiModulePlayer;
import me.desht.modularrouters.client.gui.module.GuiModuleVacuum;
import me.desht.modularrouters.client.model.ModelBakeEventHandler;
import me.desht.modularrouters.client.render.area.ModuleTargetRenderer;
import me.desht.modularrouters.client.render.item_beam.ItemBeamTileRenderer;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModContainerTypes;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModTileEntities;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="modularrouters", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    public static KeyBinding keybindConfigure;
    public static KeyBinding keybindModuleInfo;

    public static void initEarly() {
        FMLJavaModLoadingContext.get().getModEventBus().register(ModelBakeEventHandler.class);
        MinecraftForge.EVENT_BUS.register(ModuleTargetRenderer.class);
        MinecraftForge.EVENT_BUS.register(MouseOverHelp.class);
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            ClientSetup.setupRenderLayers();
            ClientSetup.registerScreenFactories();
            ClientSetup.registerKeyBindings();
            ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.ITEM_ROUTER.get()), ItemBeamTileRenderer::new);
        });
        FilterGuiFactory.registerGuiHandler((Item)ModItems.INSPECTION_FILTER.get(), GuiInspectionFilter::new);
        FilterGuiFactory.registerGuiHandler((Item)ModItems.REGEX_FILTER.get(), GuiRegexFilter::new);
    }

    private static void registerKeyBindings() {
        keybindConfigure = new KeyBinding("key.modularrouters.configure", (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.func_197954_a((int)67, (int)-1), "key.modularrouters.category");
        keybindModuleInfo = new KeyBinding("key.modularrouters.moduleInfo", (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.func_197954_a((int)73, (int)-1), "key.modularrouters.category");
        ClientRegistry.registerKeyBinding((KeyBinding)keybindConfigure);
        ClientRegistry.registerKeyBinding((KeyBinding)keybindModuleInfo);
    }

    private static void setupRenderLayers() {
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.ITEM_ROUTER.get()), renderType -> true);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.TEMPLATE_FRAME.get()), renderType -> true);
    }

    private static void registerScreenFactories() {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CONTAINER_ITEM_ROUTER.get()), GuiItemRouter::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CONTAINER_MODULE_BASIC.get()), GuiModule::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CONTAINER_MODULE_ACTIVATOR.get()), GuiModuleActivator::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CONTAINER_MODULE_DETECTOR.get()), GuiModuleDetector::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CONTAINER_MODULE_DISTRIBUTOR.get()), GuiModuleDistributor::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CONTAINER_MODULE_EXTRUDER2.get()), GuiModuleExtruder2::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CONTAINER_MODULE_FLINGER.get()), GuiModuleFlinger::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CONTAINER_MODULE_FLUID.get()), GuiModuleFluid::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CONTAINER_MODULE_PLAYER.get()), GuiModulePlayer::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CONTAINER_MODULE_VACUUM.get()), GuiModuleVacuum::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CONTAINER_BULK_ITEM_FILTER.get()), GuiBulkItemFilter::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CONTAINER_MOD_FILTER.get()), GuiModFilter::new);
    }
}

