/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import me.desht.modularrouters.client.gui.IMouseOverHelpProvider;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MouseOverHelp {
    private static final int TEXT_MARGIN = 8;
    private final List<HelpRegion> helpRegions = new ArrayList<HelpRegion>();
    private final ContainerScreen<?> screen;
    private boolean active = false;

    public MouseOverHelp(ContainerScreen<?> screen) {
        this.screen = screen;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void addHelpRegion(int x1, int y1, int x2, int y2, String key) {
        this.addHelpRegion(x1, y1, x2, y2, key, HelpRegion.YES);
    }

    public void addHelpRegion(int x1, int y1, int x2, int y2, String key, Predicate<ContainerScreen<?>> showPredicate) {
        this.helpRegions.add(new HelpRegion(x1, y1, x2, y2, MiscUtil.wrapString(I18n.func_135052_a((String)key, (Object[])new Object[0]), 35), showPredicate));
    }

    private void onMouseOver(MatrixStack matrixStack, int mouseX, int mouseY) {
        HelpRegion region;
        if (this.active && (region = this.getRegionAt(mouseX, mouseY)) != null) {
            MouseOverHelp.showPopupBox(matrixStack, this.screen, Minecraft.func_71410_x().field_71466_p, region.extent, -1073741824, 1614872575, 0, null);
            MouseOverHelp.showPopupBox(matrixStack, this.screen, Minecraft.func_71410_x().field_71466_p, region.extent, -1073741824, -534765536, -2039584, region.text);
        }
    }

    private HelpRegion getRegionAt(int mouseX, int mouseY) {
        for (HelpRegion region : this.helpRegions) {
            if (!region.extent.func_199315_b(mouseX, mouseY) || !region.showPredicate.test(this.screen)) continue;
            return region;
        }
        return null;
    }

    private static Rectangle2d calcBounds(ContainerScreen<?> screen, FontRenderer fontRenderer, Rectangle2d rect, List<String> helpText) {
        if (helpText != null && !helpText.isEmpty()) {
            int boxWidth = 0;
            int n = helpText.size();
            fontRenderer.getClass();
            int boxHeight = n * 9;
            for (String s : helpText) {
                boxWidth = Math.max(boxWidth, fontRenderer.func_78256_a(s));
            }
            int xOff = rect.func_199318_a() - screen.getGuiLeft() < screen.getXSize() / 2 ? rect.func_199316_c() + 10 : -(boxWidth + 8 + 10);
            int yOff = (rect.func_199317_d() - boxHeight - 8) / 2;
            return new Rectangle2d(rect.func_199318_a() + xOff, rect.func_199319_b() + yOff, boxWidth + 8, boxHeight + 8);
        }
        return rect;
    }

    private static void showPopupBox(MatrixStack matrixStack, ContainerScreen<?> screen, FontRenderer fontRenderer, Rectangle2d rect, int borderColor, int bgColor, int textColor, List<String> helpText) {
        Rectangle2d actualRect = MouseOverHelp.calcBounds(screen, fontRenderer, rect, helpText);
        int x1 = actualRect.func_199318_a() - screen.getGuiLeft();
        int y1 = actualRect.func_199319_b() - screen.getGuiTop();
        int x2 = x1 + actualRect.func_199316_c();
        int y2 = y1 + actualRect.func_199317_d();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 300.0);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)y1, (int)x2, (int)y2, (int)bgColor);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)borderColor);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)y2, (int)x2, (int)(y2 + 1), (int)borderColor);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)borderColor);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x2, (int)y1, (int)(x2 + 1), (int)(y2 + 1), (int)borderColor);
        if (helpText != null) {
            for (String s : helpText) {
                fontRenderer.func_238421_b_(matrixStack, s, (float)x1 + 4.0f, (float)y1 + 4.0f, textColor);
                fontRenderer.getClass();
                y1 += 9;
            }
        }
        matrixStack.func_227865_b_();
    }

    @SubscribeEvent
    public static void drawMouseOver(GuiContainerEvent.DrawForeground event) {
        if (event.getGuiContainer() instanceof IMouseOverHelpProvider) {
            ((IMouseOverHelpProvider)event.getGuiContainer()).getMouseOverHelp().onMouseOver(event.getMatrixStack(), event.getMouseX(), event.getMouseY());
        }
    }

    public static class Button
    extends TexturedToggleButton {
        public Button(int x, int y) {
            super(x, y, 16, 16, false, null);
            this.tooltip1.addAll(MiscUtil.wrapStringAsTextComponent(I18n.func_135052_a((String)"guiText.tooltip.mouseOverHelp.false", (Object[])new Object[0])));
            this.tooltip2.addAll(MiscUtil.wrapStringAsTextComponent(I18n.func_135052_a((String)"guiText.tooltip.mouseOverHelp.true", (Object[])new Object[0])));
        }

        public void func_230982_a_(double mouseX, double mouseY) {
            this.toggle();
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        @Override
        public boolean sendToServer() {
            return false;
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 208 : 192;
        }

        @Override
        protected int getTextureY() {
            return 0;
        }
    }

    public static class HelpRegion {
        final Rectangle2d extent;
        final List<String> text;
        final Predicate<ContainerScreen<?>> showPredicate;
        static final Predicate<ContainerScreen<?>> YES = guiContainer -> true;

        HelpRegion(int x1, int y1, int x2, int y2, List<String> text) {
            this(x1, y1, x2, y2, text, YES);
        }

        HelpRegion(int x1, int y1, int x2, int y2, List<String> text, Predicate<ContainerScreen<?>> showPredicate) {
            this.extent = new Rectangle2d(x1, y1, x2 - x1, y2 - y1);
            this.text = text;
            this.showPredicate = showPredicate;
        }
    }
}

