/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.filter.GuiFilterContainer;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.container.ContainerSmartFilter;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class GuiBulkItemFilter
extends GuiFilterContainer {
    private static final ResourceLocation textureLocation = new ResourceLocation("modularrouters", "textures/gui/bulkitemfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 233;
    private ModuleTarget target;

    public GuiBulkItemFilter(ContainerSmartFilter container, PlayerInventory inventory, ITextComponent displayName) {
        super(container, inventory, displayName);
        this.field_146999_f = 176;
        this.field_147000_g = 233;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new ClearButton(this.field_147003_i + 8, this.field_147009_r + 130, p -> PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.CLEAR_ALL, ((ContainerSmartFilter)this.field_147002_h).getLocator(), null))));
        MFLocator locator = ((ContainerSmartFilter)this.field_147002_h).getLocator();
        if (locator.filterSlot >= 0) {
            this.func_230480_a_((Widget)new BackButton(this.field_147003_i + 2, this.field_147009_r + 2, p -> this.closeGUI()));
        }
        if (locator.routerSlot >= 0 && locator.routerPos != null) {
            ItemStack moduleStack = locator.getModuleStack((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
            TileEntityItemRouter router = ((ContainerSmartFilter)this.field_147002_h).getRouter();
            CompiledModule cm = ((ItemModule)moduleStack.func_77973_b()).compile(router, moduleStack);
            this.target = cm.getEffectiveTarget(router);
            if (this.target.getItemHandler((World)this.field_230706_i_.field_71441_e).isPresent()) {
                this.func_230480_a_((Widget)new MergeButton(this.field_147003_i + 28, this.field_147009_r + 130, this.target.toString(), I18n.func_135052_a((String)this.target.blockTranslationKey, (Object[])new Object[0]), p -> {
                    if (this.target != null) {
                        PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.MERGE, ((ContainerSmartFilter)this.field_147002_h).getLocator(), this.target.toNBT()));
                    }
                }));
                this.func_230480_a_((Widget)new LoadButton(this.field_147003_i + 48, this.field_147009_r + 130, this.target.toString(), I18n.func_135052_a((String)this.target.blockTranslationKey, (Object[])new Object[0]), p -> {
                    if (this.target != null) {
                        PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.LOAD, ((ContainerSmartFilter)this.field_147002_h).getLocator(), this.target.toNBT()));
                    }
                }));
            }
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_230704_d_, (float)this.field_146999_f / 2.0f - (float)this.field_230712_o_.func_78256_a(this.field_230704_d_) / 2.0f, 8.0f, 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(textureLocation);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, 176, 233);
    }

    public boolean func_231177_au__() {
        return false;
    }

    static class LoadButton
    extends TexturedButton {
        LoadButton(int x, int y, String locStr, String name, Button.IPressable pressable) {
            super(x, y, 16, 16, pressable);
            MiscUtil.appendMultilineText(this.tooltip1, TextFormatting.WHITE, "guiText.tooltip.loadFilter", name, locStr);
        }

        @Override
        protected int getTextureX() {
            return 144;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }
    }

    static class MergeButton
    extends Buttons.AddButton {
        MergeButton(int x, int y, String locStr, String name, Button.IPressable pressable) {
            super(x, y, pressable);
            MiscUtil.appendMultilineText(this.tooltip1, TextFormatting.WHITE, "guiText.tooltip.mergeFilter", name, locStr);
        }
    }

    static class ClearButton
    extends Buttons.DeleteButton {
        ClearButton(int x, int y, Button.IPressable pressable) {
            super(x, y, 0, pressable);
            this.tooltip1.add(ClientUtil.xlate("guiText.tooltip.clearFilter", new Object[0]));
        }
    }
}

