/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.filter.GuiFilterContainer;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.container.ContainerSmartFilter;
import me.desht.modularrouters.item.smartfilter.ModFilter;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiModFilter
extends GuiFilterContainer {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("modularrouters", "textures/gui/modfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 252;
    private final List<String> mods = Lists.newArrayList();
    private final List<Buttons.DeleteButton> deleteButtons = Lists.newArrayList();
    private ItemStack prevInSlot = ItemStack.field_190927_a;
    private String modId = "";
    private String modName = "";

    public GuiModFilter(ContainerSmartFilter container, PlayerInventory inv, ITextComponent displayName) {
        super(container, inv, displayName);
        this.field_146999_f = 176;
        this.field_147000_g = 252;
        this.mods.addAll(ModFilter.getModList(this.filterStack));
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        if (((ContainerSmartFilter)this.field_147002_h).getLocator().filterSlot >= 0) {
            this.func_230480_a_((Widget)new BackButton(this.field_147003_i - 12, this.field_147009_r, p -> this.closeGUI()));
        }
        this.func_230480_a_((Widget)new Buttons.AddButton(this.field_147003_i + 154, this.field_147009_r + 19, p -> {
            if (!this.modId.isEmpty()) {
                CompoundNBT ext = new CompoundNBT();
                ext.func_74778_a("ModId", this.modId);
                PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.ADD_STRING, ((ContainerSmartFilter)this.field_147002_h).getLocator(), ext));
                ((Slot)((ContainerSmartFilter)this.func_212873_a_()).field_75151_b.get(0)).func_75215_d(ItemStack.field_190927_a);
            }
        }));
        for (int i = 0; i < 6; ++i) {
            Buttons.DeleteButton b = new Buttons.DeleteButton(this.field_147003_i + 8, this.field_147009_r + 44 + i * 19, i, button -> {
                CompoundNBT ext = new CompoundNBT();
                ext.func_74768_a("Pos", ((Buttons.DeleteButton)button).getId());
                PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.REMOVE_AT, ((ContainerSmartFilter)this.field_147002_h).getLocator(), ext));
            });
            this.func_230480_a_((Widget)b);
            this.deleteButtons.add(b);
        }
        this.updateDeleteButtonVisibility();
    }

    private void updateDeleteButtonVisibility() {
        for (int i = 0; i < this.deleteButtons.size(); ++i) {
            this.deleteButtons.get((int)i).field_230694_p_ = i < this.mods.size();
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        String title = this.filterStack.func_200301_q().getString() + (((ContainerSmartFilter)this.field_147002_h).getRouter() != null ? I18n.func_135052_a((String)"guiText.label.installed", (Object[])new Object[0]) : "");
        this.field_230712_o_.func_238421_b_(matrixStack, title, (float)this.field_146999_f / 2.0f - (float)this.field_230712_o_.func_78256_a(title) / 2.0f, 8.0f, 0x404040);
        if (!this.modName.isEmpty()) {
            this.field_230712_o_.func_238421_b_(matrixStack, this.modName, 29.0f, 23.0f, 0x404040);
        }
        for (int i = 0; i < this.mods.size(); ++i) {
            String mod = ModNameCache.getModName(this.mods.get(i));
            this.field_230712_o_.func_238421_b_(matrixStack, mod, 28.0f, (float)(47 + i * 19), 0x404080);
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        ItemStack inSlot = (ItemStack)((ContainerSmartFilter)this.func_212873_a_()).func_75138_a().get(0);
        if (inSlot.func_190926_b() && !this.prevInSlot.func_190926_b()) {
            this.modName = "";
            this.modId = "";
        } else if (!(inSlot.func_190926_b() || !this.prevInSlot.func_190926_b() && inSlot.func_185136_b(this.prevInSlot))) {
            this.modId = inSlot.func_77973_b().getRegistryName().func_110624_b();
            this.modName = ModNameCache.getModName(this.modId);
        }
        this.prevInSlot = inSlot;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE_LOCATION);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void resync(ItemStack filterStack) {
        this.mods.clear();
        this.mods.addAll(ModFilter.getModList(filterStack));
        this.updateDeleteButtonVisibility();
    }
}

