/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.filter.GuiFilterScreen;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidgetMR;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.smartfilter.RegexFilter;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class GuiRegexFilter
extends GuiFilterScreen {
    private static final ResourceLocation textureLocation = new ResourceLocation("modularrouters", "textures/gui/regexfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 186;
    private int xPos;
    private int yPos;
    private RegexTextField regexTextField;
    private String errorMsg = "";
    private int errorTimer = 60;
    private final List<String> regexList = Lists.newArrayList();
    private final List<Buttons.DeleteButton> deleteButtons = Lists.newArrayList();

    public GuiRegexFilter(ItemStack filterStack, MFLocator locator) {
        super(filterStack, locator);
        this.regexList.addAll(RegexFilter.getRegexList(filterStack));
    }

    public void func_231160_c_() {
        this.xPos = (this.field_230708_k_ - 176) / 2;
        this.yPos = (this.field_230709_l_ - 186) / 2;
        TextFieldManager manager = this.getTextFieldManager().clear();
        this.regexTextField = new RegexTextField(this, 1, this.field_230712_o_, this.xPos + 10, this.yPos + 27, 144, 18);
        this.regexTextField.useGuiTextBackground();
        manager.focus(0);
        if (this.locator.filterSlot >= 0) {
            this.func_230480_a_((Widget)new BackButton(this.xPos - 12, this.yPos, p -> this.closeGUI()));
        }
        this.func_230480_a_((Widget)new Buttons.AddButton(this.xPos + 155, this.yPos + 23, button -> {
            if (!this.regexTextField.func_146179_b().isEmpty()) {
                this.addRegex();
            }
        }));
        for (int i = 0; i < 6; ++i) {
            Buttons.DeleteButton b = new Buttons.DeleteButton(this.xPos + 8, this.yPos + 52 + i * 19, i, button -> this.sendRemovePosMessage(((Buttons.DeleteButton)button).getId()));
            this.func_230480_a_((Widget)b);
            this.deleteButtons.add(b);
        }
        this.updateDeleteButtonVisibility();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(textureLocation);
        this.func_238474_b_(matrixStack, this.xPos, this.yPos, 0, 0, 176, 186);
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_230704_d_, (float)this.xPos + 88.0f - (float)this.field_230712_o_.func_78256_a(this.field_230704_d_) / 2.0f, (float)(this.yPos + 6), 0x404040);
        for (int i = 0; i < this.regexList.size(); ++i) {
            String regex = this.regexList.get(i);
            this.field_230712_o_.func_238421_b_(matrixStack, "/" + regex + "/", (float)(this.xPos + 28), (float)(this.yPos + 55 + i * 19), 0x404080);
        }
        if (!this.errorMsg.isEmpty()) {
            this.field_230712_o_.func_238421_b_(matrixStack, this.errorMsg, (float)(this.xPos + 8), (float)(this.yPos + 170), 0x804040);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_231023_e_() {
        if (this.errorTimer > 0 && --this.errorTimer == 0) {
            this.errorMsg = "";
        }
        super.func_231023_e_();
    }

    private void addRegex() {
        try {
            String regex = this.regexTextField.func_146179_b();
            Pattern.compile(regex);
            this.sendAddStringMessage("String", regex);
            this.regexTextField.func_146180_a("");
            this.getTextFieldManager().focus(0);
            this.errorMsg = "";
        }
        catch (PatternSyntaxException e) {
            this.field_230706_i_.field_71439_g.func_184185_a((SoundEvent)ModSounds.ERROR.get(), 1.0f, 1.0f);
            this.errorMsg = I18n.func_135052_a((String)"guiText.label.regexError", (Object[])new Object[0]);
            this.errorTimer = 60;
        }
    }

    @Override
    public void resync(ItemStack stack) {
        this.regexList.clear();
        this.regexList.addAll(RegexFilter.getRegexList(stack));
        this.updateDeleteButtonVisibility();
    }

    private void updateDeleteButtonVisibility() {
        for (int i = 0; i < this.deleteButtons.size(); ++i) {
            this.deleteButtons.get((int)i).field_230694_p_ = i < this.regexList.size();
        }
    }

    private static class RegexTextField
    extends TextFieldWidgetMR {
        private final GuiRegexFilter parent;

        RegexTextField(GuiRegexFilter parent, int componentId, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height) {
            super(parent.getTextFieldManager(), fontrendererObj, x, y, par5Width, par6Height);
            this.parent = parent;
            this.func_146203_f(40);
        }

        public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 257) {
                this.parent.addRegex();
                return true;
            }
            return super.func_231046_a_(keyCode, scanCode, modifiers);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
            if (mouseX >= (double)this.field_230690_l_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY >= (double)this.field_230691_m_ && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_) && mouseButton == 1) {
                this.func_146180_a("");
            }
            return super.func_231044_a_(mouseX, mouseY, mouseButton);
        }
    }
}

