/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets.textfield;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidgetMR;
import net.minecraft.client.gui.screen.Screen;

public class TextFieldManager {
    private final List<TextFieldWidgetMR> textFields = Lists.newArrayList();
    private int focusedField = -1;
    private final Screen parent;

    public TextFieldManager(Screen parent) {
        this.parent = parent;
    }

    public void drawTextFields(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_227722_g_();
        GlStateManager.func_227737_l_();
        this.textFields.forEach(tf -> tf.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks));
    }

    public void tick() {
        if (this.focusedField >= 0) {
            this.textFields.get(this.focusedField).func_146178_a();
        }
    }

    public boolean mouseClicked(double x, double y, int btn) {
        for (int i = 0; i < this.textFields.size(); ++i) {
            if (!this.textFields.get(i).func_231044_a_(x, y, btn)) continue;
            this.focus(i);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double wheel) {
        if (wheel == 0.0) {
            return false;
        }
        if (this.isFocused() && this.textFields.get(this.focusedField).func_146176_q()) {
            this.textFields.get(this.focusedField).onMouseWheel(wheel < 0.0 ? -1 : 1);
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258) {
            this.cycleFocus(Screen.func_231173_s_() ? -1 : 1);
        } else if (this.isFocused() && this.textFields.get(this.focusedField).func_146176_q()) {
            return this.textFields.get(this.focusedField).func_231046_a_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean charTyped(char c, int modifiers) {
        return this.isFocused() && this.textFields.get(this.focusedField).func_146176_q() && this.textFields.get(this.focusedField).func_231042_a_(c, modifiers);
    }

    int addTextField(TextFieldWidgetMR textField) {
        this.textFields.add(textField);
        return this.textFields.size() - 1;
    }

    public void focus(int field) {
        if (field != this.focusedField) {
            if (this.focusedField != -1) {
                this.textFields.get(this.focusedField).func_230996_d_(false);
            }
            this.focusedField = field;
            if (this.focusedField != -1) {
                this.textFields.get(this.focusedField).func_230996_d_(true);
            }
        }
    }

    private void cycleFocus(int dir) {
        int f;
        int oldF = f = this.focusedField;
        do {
            if ((f += dir) < 0) {
                f = this.textFields.size() - 1;
                continue;
            }
            if (f < this.textFields.size()) continue;
            f = 0;
        } while (!this.textFields.get(f).func_146176_q() && f != this.focusedField);
        if (f != oldF) {
            this.focus(f);
            this.textFields.get(f).func_146202_e();
            this.textFields.get(f).func_146199_i(0);
            if (oldF >= 0 && oldF < this.textFields.size()) {
                this.textFields.get(oldF).func_146199_i(this.textFields.get(oldF).func_146198_h());
            }
        }
    }

    public boolean isFocused() {
        return this.focusedField >= 0;
    }

    void onTextFieldFocusChange(int ordinal, boolean newFocus) {
        TextFieldWidgetMR tf = this.textFields.get(ordinal);
        if (newFocus) {
            this.focus(ordinal);
            tf.func_146202_e();
            tf.func_146199_i(0);
        } else {
            tf.func_146199_i(tf.func_146198_h());
        }
    }

    public TextFieldManager clear() {
        this.textFields.clear();
        this.focusedField = -1;
        return this;
    }
}

