/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.render.item_beam;

import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;

public class ItemBeam {
    final Vector3f startPos;
    final Vector3f endPos;
    final boolean reversed;
    final ItemStack renderItem;
    final int[] colors;
    final int lifeTime;
    final boolean itemFade;
    int ticksLived = 0;

    public ItemBeam(BlockPos pos1, BlockPos pos2, boolean reversed, ItemStack renderItem, int color, int lifeTime, boolean itemFade) {
        this.startPos = new Vector3f((float)pos1.func_177958_n() + 0.5f, (float)pos1.func_177956_o() + 0.5f, (float)pos1.func_177952_p() + 0.5f);
        this.endPos = new Vector3f((float)pos2.func_177958_n() + 0.5f, (float)pos2.func_177956_o() + 0.5f, (float)pos2.func_177952_p() + 0.5f);
        this.reversed = reversed;
        this.renderItem = renderItem;
        this.colors = this.decompose(color);
        this.lifeTime = lifeTime;
        this.itemFade = itemFade;
    }

    private int[] decompose(int color) {
        int[] res = new int[]{color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return res;
    }

    public AxisAlignedBB getAABB() {
        return new AxisAlignedBB((double)this.startPos.func_195899_a(), (double)this.startPos.func_195900_b(), (double)this.startPos.func_195902_c(), (double)this.endPos.func_195899_a(), (double)this.endPos.func_195900_b(), (double)this.endPos.func_195902_c());
    }

    public void tick() {
        ++this.ticksLived;
    }

    public boolean isExpired() {
        return this.ticksLived >= this.lifeTime;
    }
}

