/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.render.item_beam;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.render.ModRenderTypes;
import me.desht.modularrouters.client.render.item_beam.ItemBeam;
import me.desht.modularrouters.config.MRConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;

public class ItemBeamTileRenderer
extends TileEntityRenderer<TileEntityItemRouter> {
    private static final Vector3f ROTATION = new Vector3f(0.15f, 1.0f, 0.0f);

    public ItemBeamTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityItemRouter te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        for (ItemBeam beam : te.beams) {
            matrixStack.func_227860_a_();
            if (beam.reversed) {
                matrixStack.func_227861_a_((double)(-beam.endPos.func_195899_a()), (double)(-beam.endPos.func_195900_b()), (double)(-beam.endPos.func_195902_c()));
            } else {
                matrixStack.func_227861_a_((double)(-beam.startPos.func_195899_a()), (double)(-beam.startPos.func_195900_b()), (double)(-beam.startPos.func_195902_c()));
            }
            float progress = ((float)beam.ticksLived + partialTicks) / (float)beam.lifeTime;
            if (MRConfig.Client.Misc.renderFlyingItems) {
                this.renderFlyingItem(beam, matrixStack, buffer, progress);
            }
            this.renderBeamLine(beam, matrixStack, buffer, progress);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    private void renderFlyingItem(ItemBeam beam, MatrixStack matrixStack, IRenderTypeBuffer buffer, float progress) {
        float iz;
        float iy;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        float ix = MathHelper.func_219799_g((float)progress, (float)beam.startPos.func_195899_a(), (float)beam.endPos.func_195899_a());
        BlockPos pos = new BlockPos((double)ix, (double)(iy = MathHelper.func_219799_g((float)progress, (float)beam.startPos.func_195900_b(), (float)beam.endPos.func_195900_b())), (double)(iz = MathHelper.func_219799_g((float)progress, (float)beam.startPos.func_195902_c(), (float)beam.endPos.func_195902_c())));
        VoxelShape shape = world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos);
        if (shape.func_197766_b() || !shape.func_197752_a().func_186670_a(pos).func_197744_e((double)ix, (double)iy, (double)iz)) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)ix, (double)iy - 0.15, (double)iz);
            matrixStack.func_227863_a_(ROTATION.func_229187_a_(progress * 360.0f));
            if (beam.itemFade) {
                matrixStack.func_227862_a_(1.25f - progress, 1.25f - progress, 1.25f - progress);
                if ((double)progress > 0.9) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)beam.endPos.func_195899_a(), (double)beam.endPos.func_195900_b(), (double)beam.endPos.func_195902_c(), 0.5 - world.field_73012_v.nextDouble(), -0.5, 0.5 - world.field_73012_v.nextDouble());
                }
            }
            int light = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)pos);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(beam.renderItem, ItemCameraTransforms.TransformType.GROUND, light, OverlayTexture.field_229196_a_, matrixStack, buffer);
            matrixStack.func_227865_b_();
        }
    }

    private void renderBeamLine(ItemBeam beam, MatrixStack matrixStack, IRenderTypeBuffer buffer, float progress) {
        int alpha = (int)((1.0 - Math.abs((double)progress - 0.5)) * 32.0 + 16.0);
        Matrix4f positionMatrix = matrixStack.func_227866_c_().func_227870_a_();
        IVertexBuilder builder = buffer.getBuffer(ModRenderTypes.BEAM_LINE_THICK);
        builder.func_227888_a_(positionMatrix, beam.startPos.func_195899_a(), beam.startPos.func_195900_b(), beam.startPos.func_195902_c()).func_225586_a_(beam.colors[0], beam.colors[1], beam.colors[2], alpha).func_181675_d();
        builder.func_227888_a_(positionMatrix, beam.endPos.func_195899_a(), beam.endPos.func_195900_b(), beam.endPos.func_195902_c()).func_225586_a_(beam.colors[0], beam.colors[1], beam.colors[2], alpha).func_181675_d();
        IVertexBuilder builder2 = buffer.getBuffer(ModRenderTypes.BEAM_LINE_THIN);
        builder2.func_227888_a_(positionMatrix, beam.startPos.func_195899_a(), beam.startPos.func_195900_b(), beam.startPos.func_195902_c()).func_225586_a_(beam.colors[0], beam.colors[1], beam.colors[2], alpha * 2).func_181675_d();
        builder2.func_227888_a_(positionMatrix, beam.endPos.func_195899_a(), beam.endPos.func_195900_b(), beam.endPos.func_195902_c()).func_225586_a_(beam.colors[0], beam.colors[1], beam.colors[2], alpha * 2).func_181675_d();
    }
}

