/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import java.util.List;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.ModContainerTypes;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.logic.compiled.CompiledFluidModule1;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.logic.filter.matchers.FluidMatcher;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidModule1
extends ItemModule {
    public FluidModule1() {
        super(ModItems.defaultProps());
    }

    @Override
    public ContainerType<? extends ContainerModule> getContainerType() {
        return (ContainerType)ModContainerTypes.CONTAINER_MODULE_FLUID.get();
    }

    @Override
    public CompiledModule compile(TileEntityItemRouter router, ItemStack stack) {
        return new CompiledFluidModule1(router, stack);
    }

    @Override
    protected ITextComponent getFilterItemDisplayName(ItemStack stack) {
        return (ITextComponent)FluidUtil.getFluidContained((ItemStack)stack).map(FluidStack::getDisplayName).orElse((Object)stack.func_200301_q());
    }

    @Override
    protected void addExtraInformation(ItemStack stack, List<ITextComponent> list) {
        super.addExtraInformation(stack, list);
        FluidModule1.addFluidModuleInformation(stack, list);
    }

    @Override
    public boolean isItemValidForFilter(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() instanceof ItemSmartFilter) {
            return true;
        }
        if (stack.func_190916_E() > 1) {
            return false;
        }
        return (Boolean)FluidUtil.getFluidContained((ItemStack)stack).map(fluidStack -> !fluidStack.isEmpty()).orElse((Object)false);
    }

    @Override
    public IItemMatcher getFilterItemMatcher(ItemStack stack) {
        return new FluidMatcher(stack);
    }

    @Override
    public boolean isFluidModule() {
        return true;
    }

    @Override
    public TintColor getItemTint() {
        return new TintColor(79, 191, 255);
    }

    static void addFluidModuleInformation(ItemStack stack, List<ITextComponent> list) {
        CompiledFluidModule1 cfm = new CompiledFluidModule1(null, stack);
        String dir = I18n.func_135052_a((String)("itemText.fluid.direction." + (Object)((Object)cfm.getFluidDirection())), (Object[])new Object[0]);
        list.add((ITextComponent)ClientUtil.xlate("itemText.fluid.direction", dir));
        list.add((ITextComponent)ClientUtil.xlate("itemText.fluid.maxTransfer", cfm.getMaxTransfer()));
    }

    public static enum FluidDirection {
        IN,
        OUT;


        public String getTranslationKey() {
            return "itemText.fluid.direction." + this.toString();
        }
    }
}

