/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.client.gui.GuiItemRouter;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.container.ContainerItemRouter;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModContainerTypes;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.ItemBase;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.item.module.IPickaxeUser;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.SimpleItemMatcher;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class ItemModule
extends ItemBase
implements ModItems.ITintable {
    public ItemModule(Item.Properties props) {
        super(props);
    }

    public abstract CompiledModule compile(TileEntityItemRouter var1, ItemStack var2);

    @Override
    public abstract TintColor getItemTint();

    public boolean isDirectional() {
        return true;
    }

    public boolean isOmniDirectional() {
        return false;
    }

    public boolean isFluidModule() {
        return false;
    }

    ContainerModule createContainer(int windowId, PlayerInventory invPlayer, MFLocator loc) {
        return new ContainerModule(this.getContainerType(), windowId, invPlayer, loc);
    }

    public ContainerType<? extends ContainerModule> getContainerType() {
        return (ContainerType)ModContainerTypes.CONTAINER_MODULE_BASIC.get();
    }

    public boolean isItemValidForFilter(ItemStack stack) {
        return true;
    }

    public IItemMatcher getFilterItemMatcher(ItemStack stack) {
        return new SimpleItemMatcher(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        Slot slot;
        super.func_77624_a(stack, world, list, flag);
        TileEntityItemRouter router = ClientUtil.getOpenItemRouter();
        if (router != null && (slot = ((GuiItemRouter)Minecraft.func_71410_x().field_71462_r).getSlotUnderMouse()) instanceof ContainerItemRouter.InstalledModuleSlot) {
            String s = ClientSetup.keybindConfigure.getKey().func_197935_d();
            list.add((ITextComponent)ClientUtil.xlate("itemText.misc.configureHint", Character.valueOf(s.charAt(s.length() - 1))));
        }
    }

    @Override
    protected void addExtraInformation(ItemStack stack, List<ITextComponent> list) {
        this.addSettingsInformation(stack, list);
        this.addAugmentInformation(stack, list);
    }

    protected void addSettingsInformation(ItemStack itemstack, List<ITextComponent> list) {
        if (this.isDirectional()) {
            RelativeDirection dir = ModuleHelper.getDirectionFromNBT(itemstack);
            IFormattableTextComponent itc = ClientUtil.xlate(this.isOmniDirectional() && dir == RelativeDirection.NONE ? "guiText.tooltip.allDirections" : "guiText.tooltip." + dir.toString(), new Object[0]);
            list.add((ITextComponent)ClientUtil.xlate("guiText.label.direction", new Object[0]).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)itc.func_240699_a_(TextFormatting.AQUA)));
        }
        this.addFilterInformation(itemstack, list);
        list.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"itemText.misc.flags", (Object[])new Object[0]) + ": " + String.join((CharSequence)" | ", this.formatFlag("IGNORE_DAMAGE", ModuleHelper.ignoreDamage(itemstack)), this.formatFlag("IGNORE_NBT", ModuleHelper.ignoreNBT(itemstack)), this.formatFlag("IGNORE_TAGS", ModuleHelper.ignoreTags(itemstack)), this.formatFlag("TERMINATE", !ModuleHelper.terminates(itemstack)))));
        boolean matchAll = ModuleHelper.isMatchAll(itemstack);
        list.add((ITextComponent)ClientUtil.xlate("itemText.misc.match", new Object[0]).func_240702_b_(": ").func_230529_a_((ITextComponent)ClientUtil.xlate("itemText.misc." + (matchAll ? "matchAll" : "matchAny"), new Object[0]).func_240699_a_(TextFormatting.AQUA)));
        if (this instanceof IRangedModule) {
            IRangedModule rm = (IRangedModule)((Object)this);
            int curRange = rm.getCurrentRange(itemstack);
            String col = curRange > rm.getBaseRange() ? TextFormatting.GREEN.toString() : (curRange < rm.getBaseRange() ? TextFormatting.RED.toString() : TextFormatting.AQUA.toString());
            list.add((ITextComponent)ClientUtil.xlate("itemText.misc.rangeInfo", col, rm.getCurrentRange(itemstack), rm.getBaseRange(), rm.getHardMaxRange()));
        }
        if (this instanceof IPickaxeUser) {
            ItemStack pick = ((IPickaxeUser)((Object)this)).getPickaxe(itemstack);
            list.add((ITextComponent)ClientUtil.xlate("itemText.misc.breakerPick", new Object[0]).func_230529_a_((ITextComponent)pick.func_200301_q().func_230531_f_().func_240699_a_(TextFormatting.AQUA)));
            EnchantmentHelper.func_82781_a((ItemStack)pick).forEach((ench, level) -> list.add((ITextComponent)new StringTextComponent("\u25b6 ").func_230529_a_((ITextComponent)ench.func_200305_d(level.intValue()).func_230531_f_().func_240699_a_(TextFormatting.AQUA)).func_240699_a_(TextFormatting.YELLOW)));
        }
    }

    private void addAugmentInformation(ItemStack stack, List<ITextComponent> list) {
        ItemAugment.AugmentCounter c = new ItemAugment.AugmentCounter(stack);
        ArrayList toAdd = Lists.newArrayList();
        for (ItemAugment augment : c.getAugments()) {
            int n = c.getAugmentCount(augment);
            if (n <= 0) continue;
            ItemStack augmentStack = new ItemStack((IItemProvider)augment);
            String s = augmentStack.func_200301_q().getString();
            if (n > 1) {
                s = n + " x " + s;
            }
            s = s + TextFormatting.AQUA + augment.getExtraInfo(n, stack);
            toAdd.add(new StringTextComponent(" \u2022 " + TextFormatting.DARK_GREEN + s));
        }
        if (!toAdd.isEmpty()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN.toString()).func_230529_a_((ITextComponent)ClientUtil.xlate("itemText.augments", new Object[0])));
            list.addAll(toAdd);
        }
    }

    public String getDirectionString(RelativeDirection dir) {
        return this.isOmniDirectional() && dir == RelativeDirection.NONE ? I18n.func_135052_a((String)"guiText.tooltip.allDirections", (Object[])new Object[0]) : I18n.func_135052_a((String)("guiText.tooltip." + dir.toString()), (Object[])new Object[0]);
    }

    private String formatFlag(String key, boolean flag) {
        String text = I18n.func_135052_a((String)("itemText.misc." + key), (Object[])new Object[0]);
        return (flag ? TextFormatting.DARK_GRAY : TextFormatting.AQUA) + text + TextFormatting.RESET;
    }

    protected ITextComponent getFilterItemDisplayName(ItemStack stack) {
        return stack.func_200301_q();
    }

    private void addFilterInformation(ItemStack itemstack, List<ITextComponent> list) {
        ArrayList<IFormattableTextComponent> l2 = new ArrayList<IFormattableTextComponent>();
        BaseModuleHandler.ModuleFilterHandler filterHandler = new BaseModuleHandler.ModuleFilterHandler(itemstack, null);
        for (int i = 0; i < filterHandler.getSlots(); ++i) {
            ItemStack s = filterHandler.getStackInSlot(i);
            if (s.func_77973_b() instanceof ItemSmartFilter) {
                int size = ((ItemSmartFilter)s.func_77973_b()).getSize(s);
                String suffix = size > 0 ? " [" + size + "]" : "";
                l2.add(new StringTextComponent(" \u2022 ").func_230529_a_((ITextComponent)s.func_200301_q().func_230531_f_().func_240702_b_(suffix)).func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.ITALIC}));
                continue;
            }
            if (s.func_190926_b()) continue;
            l2.add(new StringTextComponent(" \u2022 ").func_230529_a_((ITextComponent)this.getFilterItemDisplayName(s).func_230531_f_().func_240699_a_(TextFormatting.AQUA)));
        }
        String key = "itemText.misc." + (ModuleHelper.isBlacklist(itemstack) ? "blacklist" : "whitelist");
        if (l2.isEmpty()) {
            list.add((ITextComponent)ClientUtil.xlate(key, new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW}).func_240702_b_(": ").func_230529_a_((ITextComponent)ClientUtil.xlate("itemText.misc.noItems", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.ITALIC})));
        } else {
            list.add((ITextComponent)ClientUtil.xlate(key, new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW}).func_240702_b_(": "));
            list.addAll(l2);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ModuleHelper.validateNBT(stack);
        if (!player.func_226271_bk_()) {
            if (!world.field_72995_K) {
                MFLocator locator = MFLocator.heldModule(hand);
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProvider(player, locator), locator::writeBuf);
            }
        } else {
            return this.onSneakRightClick(stack, world, player, hand);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        if (stack.func_77973_b() instanceof IPickaxeUser) {
            ItemStack pick = ((IPickaxeUser)stack.func_77973_b()).getPickaxe(stack);
            return !pick.func_190926_b() && !EnchantmentHelper.func_82781_a((ItemStack)pick).isEmpty();
        }
        return false;
    }

    public ActionResult<ItemStack> onSneakRightClick(ItemStack stack, World world, PlayerEntity player, Hand hand) {
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    public static class ContainerProvider
    implements INamedContainerProvider {
        private final MFLocator loc;
        private final ItemStack moduleStack;

        public ContainerProvider(PlayerEntity player, MFLocator loc) {
            this.loc = loc;
            this.moduleStack = loc.getModuleStack(player);
        }

        public ITextComponent func_145748_c_() {
            return this.moduleStack.func_200301_q();
        }

        @Nullable
        public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            return ((ItemModule)this.moduleStack.func_77973_b()).createContainer(windowId, playerInventory, this.loc);
        }
    }

    public static enum RelativeDirection {
        NONE(0),
        DOWN(1),
        UP(2),
        LEFT(4),
        RIGHT(8),
        FRONT(16),
        BACK(32);

        private final int mask;

        private RelativeDirection(int mask) {
            this.mask = mask;
        }

        public Direction toAbsolute(Direction current) {
            switch (this) {
                case UP: {
                    return Direction.UP;
                }
                case DOWN: {
                    return Direction.DOWN;
                }
                case FRONT: {
                    return current;
                }
                case LEFT: {
                    return current.func_176746_e();
                }
                case BACK: {
                    return current.func_176734_d();
                }
                case RIGHT: {
                    return current.func_176735_f();
                }
            }
            return current;
        }

        public int getMask() {
            return this.mask;
        }
    }

    public static enum ModuleFlags {
        BLACKLIST(true, 1),
        IGNORE_DAMAGE(false, 2),
        IGNORE_NBT(true, 4),
        IGNORE_TAGS(true, 8),
        TERMINATE(false, 128);

        private final boolean defaultValue;
        private byte mask;

        private ModuleFlags(boolean defaultValue, int mask) {
            this.defaultValue = defaultValue;
            this.mask = (byte)mask;
        }

        public boolean getDefaultValue() {
            return this.defaultValue;
        }

        public byte getMask() {
            return this.mask;
        }
    }
}

