/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.FakePlayerManager;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class CompiledActivatorModule
extends CompiledModule {
    public static final String NBT_ACTION_TYPE = "ActionType";
    public static final String NBT_LOOK_DIRECTION = "LookDirection";
    public static final String NBT_SNEAKING = "Sneaking";
    public static final String NBT_ENTITY_MODE = "EntityMode";
    private final ActionType actionType;
    private final LookDirection lookDirection;
    private final EntityMode entityMode;
    private final boolean sneaking;
    private int entityIdx;

    public CompiledActivatorModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        CompoundNBT compound = stack.func_179543_a("modularrouters");
        if (compound != null) {
            this.actionType = ActionType.values()[compound.func_74762_e(NBT_ACTION_TYPE)];
            this.lookDirection = LookDirection.values()[compound.func_74762_e(NBT_LOOK_DIRECTION)];
            this.entityMode = EntityMode.values()[compound.func_74762_e(NBT_ENTITY_MODE)];
            this.sneaking = compound.func_74767_n(NBT_SNEAKING);
        } else {
            this.actionType = ActionType.ACTIVATE_BLOCK;
            this.lookDirection = LookDirection.LEVEL;
            this.entityMode = EntityMode.NEAREST;
            this.sneaking = false;
        }
    }

    @Override
    public boolean execute(@Nonnull TileEntityItemRouter router) {
        BlockPos pos;
        ItemStack stack = router.getBufferItemStack();
        if (!this.getFilter().test(stack)) {
            return false;
        }
        World world = router.func_145831_w();
        FakePlayerManager.RouterFakePlayer fakePlayer = FakePlayerManager.getFakePlayer((ServerWorld)world, pos = router.func_174877_v());
        if (fakePlayer == null) {
            return false;
        }
        fakePlayer.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5 - (double)fakePlayer.func_70047_e(), (double)pos.func_177952_p() + 0.5);
        fakePlayer.field_70125_A = this.getFacing().func_96559_d() * -90;
        fakePlayer.field_70177_z = MiscUtil.getYawFromFacing(this.getFacing());
        fakePlayer.func_226284_e_(this.sneaking);
        fakePlayer.func_184611_a(Hand.MAIN_HAND, stack);
        float hitX = (float)(fakePlayer.func_226277_ct_() - (double)pos.func_177958_n());
        float hitY = (float)(fakePlayer.func_226278_cu_() - (double)pos.func_177956_o());
        float hitZ = (float)(fakePlayer.func_226281_cx_() - (double)pos.func_177952_p());
        switch (this.actionType) {
            case ACTIVATE_BLOCK: {
                return this.doActivateBlock(router, world, (PlayerEntity)fakePlayer, hitX, hitY, hitZ);
            }
            case USE_ITEM: {
                return this.doUseItem(router, world, pos, (PlayerEntity)fakePlayer, hitX, hitY, hitZ);
            }
            case USE_ITEM_ON_ENTITY: {
                return this.doUseItemOnEntity(router, fakePlayer);
            }
        }
        return false;
    }

    private boolean doUseItemOnEntity(TileEntityItemRouter router, FakePlayer fakePlayer) {
        Entity entity = this.findEntity(router);
        if (entity == null) {
            return false;
        }
        ActionResultType result = fakePlayer.func_190775_a(entity, Hand.MAIN_HAND);
        if (result == ActionResultType.SUCCESS) {
            router.setBufferItemStack(fakePlayer.func_184614_ca());
            return true;
        }
        return false;
    }

    private Entity findEntity(TileEntityItemRouter router) {
        Direction face = this.getFacing();
        BlockPos pos = router.func_174877_v();
        AxisAlignedBB box = new AxisAlignedBB(pos.func_177972_a(face)).func_72321_a((double)(face.func_82601_c() * 3), (double)(face.func_96559_d() * 3), (double)(face.func_82599_e() * 3));
        List l = router.func_145831_w().func_217357_a(Entity.class, box);
        if (l.isEmpty()) {
            return null;
        }
        switch (this.entityMode) {
            case RANDOM: {
                return (Entity)l.get(router.func_145831_w().field_73012_v.nextInt(l.size()));
            }
            case NEAREST: {
                l.sort(Comparator.comparingDouble(o -> o.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())));
                return (Entity)l.get(0);
            }
            case ROUND_ROBIN: {
                l.sort(Comparator.comparingDouble(o -> o.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())));
                this.entityIdx = (this.entityIdx + 1) % l.size();
                return (Entity)l.get(this.entityIdx);
            }
        }
        return null;
    }

    private boolean doUseItem(TileEntityItemRouter router, World world, BlockPos pos, PlayerEntity fakePlayer, float hitX, float hitY, float hitZ) {
        Block block;
        BlockPos targetPos = pos.func_177972_a(this.getFacing());
        Direction hitFace = this.getHitFace();
        switch (this.lookDirection) {
            case LEVEL: {
                for (int i = 0; i < 4 && world.func_175623_d(targetPos); ++i) {
                    targetPos = targetPos.func_177972_a(this.getFacing());
                }
                break;
            }
            case ABOVE: {
                targetPos = targetPos.func_177984_a();
                break;
            }
            case BELOW: {
                targetPos = targetPos.func_177977_b();
            }
        }
        ItemStack stack = fakePlayer.func_184614_ca();
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)fakePlayer, (Hand)Hand.MAIN_HAND, (BlockPos)targetPos, (Direction)hitFace);
        if (event.isCanceled() || event.getUseItem() == Event.Result.DENY) {
            return false;
        }
        BlockRayTraceResult brtr = new BlockRayTraceResult(new Vector3d((double)hitX, (double)hitY, (double)hitZ), hitFace, targetPos, false);
        ActionResultType ret = stack.onItemUseFirst(new ItemUseContext(fakePlayer, Hand.MAIN_HAND, brtr));
        if (ret != ActionResultType.PASS) {
            return false;
        }
        if (stack.func_190926_b() || fakePlayer.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return false;
        }
        if (stack.func_77973_b() instanceof BlockItem && !fakePlayer.func_195070_dx() && ((block = ((BlockItem)stack.func_77973_b()).func_179223_d()) instanceof CommandBlockBlock || block instanceof StructureBlock)) {
            return false;
        }
        if (event.getUseItem() != Event.Result.DENY) {
            ItemStack copyBeforeUse = stack.func_77946_l();
            ActionResultType result = stack.func_196084_a(new ItemUseContext(fakePlayer, Hand.MAIN_HAND, brtr));
            if (result == ActionResultType.PASS) {
                ActionResult rightClickResult = stack.func_77973_b().func_77659_a(world, fakePlayer, Hand.MAIN_HAND);
                fakePlayer.func_184611_a(Hand.MAIN_HAND, (ItemStack)rightClickResult.func_188398_b());
            }
            if (fakePlayer.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)fakePlayer, (ItemStack)copyBeforeUse, (Hand)Hand.MAIN_HAND);
            }
            router.setBufferItemStack(fakePlayer.func_184614_ca());
            return true;
        }
        return false;
    }

    private boolean doActivateBlock(TileEntityItemRouter router, World world, PlayerEntity fakePlayer, float hitX, float hitY, float hitZ) {
        BlockRayTraceResult r;
        BlockState iblockstate;
        BlockPos targetPos = this.findBlockToActivate(router);
        if (targetPos == null) {
            return false;
        }
        Direction hitFace = this.getHitFace();
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)fakePlayer, (Hand)Hand.MAIN_HAND, (BlockPos)targetPos, (Direction)hitFace);
        if (event.isCanceled() || event.getUseItem() == Event.Result.DENY) {
            return false;
        }
        if (event.getUseBlock() != Event.Result.DENY && (iblockstate = world.func_180495_p(targetPos)).func_227031_a_(world, fakePlayer, Hand.MAIN_HAND, r = new BlockRayTraceResult(new Vector3d((double)hitX, (double)hitY, (double)hitZ), hitFace, targetPos, false)) == ActionResultType.SUCCESS) {
            router.setBufferItemStack(fakePlayer.func_184614_ca());
            return true;
        }
        return false;
    }

    private BlockPos findBlockToActivate(TileEntityItemRouter router) {
        switch (this.lookDirection) {
            case LEVEL: {
                for (int i = 1; i < 5; ++i) {
                    BlockPos pos = router.func_174877_v().func_177967_a(this.getFacing(), i);
                    if (router.func_145831_w().func_175623_d(pos)) continue;
                    return pos;
                }
                break;
            }
            case ABOVE: {
                return router.func_174877_v().func_177972_a(this.getFacing()).func_177984_a();
            }
            case BELOW: {
                return router.func_174877_v().func_177972_a(this.getFacing()).func_177977_b();
            }
        }
        return null;
    }

    private Direction getHitFace() {
        switch (this.lookDirection) {
            case ABOVE: {
                return Direction.DOWN;
            }
            case BELOW: {
                return Direction.UP;
            }
        }
        return this.getFacing().func_176734_d();
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public LookDirection getLookDirection() {
        return this.lookDirection;
    }

    public EntityMode getEntityMode() {
        return this.entityMode;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public static enum EntityMode {
        NEAREST,
        RANDOM,
        ROUND_ROBIN;


        public String getTranslationKey() {
            return "itemText.activator.entityMode." + this.toString();
        }
    }

    public static enum LookDirection {
        LEVEL,
        ABOVE,
        BELOW;


        public String getTranslationKey() {
            return "itemText.activator.direction." + this.toString();
        }
    }

    public static enum ActionType {
        ACTIVATE_BLOCK,
        USE_ITEM,
        USE_ITEM_ON_ENTITY;


        public String getTranslationKey() {
            return "itemText.activator.action." + this.toString();
        }
    }
}

