/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.item.module.TargetedModule;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledSenderModule2;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CompiledDistributorModule
extends CompiledSenderModule2 {
    public static final String NBT_STRATEGY = "DistStrategy";
    private final DistributionStrategy distributionStrategy;
    private int nextTarget = 0;

    public CompiledDistributorModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        CompoundNBT compound = stack.func_179543_a("modularrouters");
        if (compound != null) {
            this.distributionStrategy = DistributionStrategy.values()[compound.func_74762_e(NBT_STRATEGY)];
            if (this.distributionStrategy == DistributionStrategy.FURTHEST_FIRST) {
                this.nextTarget = this.getTargets().size() - 1;
            }
        } else {
            this.distributionStrategy = DistributionStrategy.ROUND_ROBIN;
        }
    }

    public DistributionStrategy getDistributionStrategy() {
        return this.distributionStrategy;
    }

    @Override
    protected List<ModuleTarget> setupTargets(TileEntityItemRouter router, ItemStack stack) {
        Set<ModuleTarget> t = TargetedModule.getTargets(stack, router != null && !router.func_145831_w().field_72995_K);
        ArrayList l = Lists.newArrayList(t);
        if (router == null) {
            return l;
        }
        l.sort(Comparator.comparingDouble(o -> CompiledDistributorModule.calcDist(o, router)));
        return l;
    }

    private static double calcDist(ModuleTarget tgt, TileEntity te) {
        double distance = tgt.gPos.func_218180_b().func_177951_i((Vector3i)te.func_174877_v());
        if (!tgt.isSameWorld(te.func_145831_w())) {
            distance += 1.0E8;
        }
        return distance;
    }

    @Override
    public ModuleTarget getEffectiveTarget(TileEntityItemRouter router) {
        if (this.getTargets() == null || this.getTargets().isEmpty()) {
            return null;
        }
        int nTargets = this.getTargets().size();
        if (nTargets == 1) {
            return this.getTargets().get(0);
        }
        ModuleTarget res = null;
        ItemStack stack = router.peekBuffer(this.getItemsPerTick(router));
        block0 : switch (this.distributionStrategy) {
            case ROUND_ROBIN: {
                for (int i = 1; i <= nTargets; ++i) {
                    ModuleTarget tgt;
                    ++this.nextTarget;
                    if (this.nextTarget >= nTargets) {
                        this.nextTarget -= nTargets;
                    }
                    if (!this.okToInsert(tgt = this.getTargets().get(this.nextTarget), stack)) continue;
                    res = tgt;
                    break block0;
                }
                break;
            }
            case RANDOM: {
                int r = router.func_145831_w().field_73012_v.nextInt(this.getTargets().size());
                res = this.getTargets().get(r);
                break;
            }
            case NEAREST_FIRST: {
                for (ModuleTarget tgt : this.getTargets()) {
                    if (!this.okToInsert(tgt, stack)) continue;
                    res = tgt;
                    break block0;
                }
                break;
            }
            case FURTHEST_FIRST: {
                for (int i = this.getTargets().size() - 1; i >= 0; --i) {
                    if (!this.okToInsert(this.getTargets().get(i), stack)) continue;
                    res = this.getTargets().get(i);
                    break block0;
                }
                break;
            }
        }
        return res;
    }

    private boolean okToInsert(ModuleTarget target, ItemStack stack) {
        return (Boolean)target.getItemHandler().map(h -> ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)stack, (boolean)true).func_190926_b()).orElse((Object)false);
    }

    public static enum DistributionStrategy {
        ROUND_ROBIN,
        RANDOM,
        NEAREST_FIRST,
        FURTHEST_FIRST;


        public String getTranslationKey() {
            return "itemText.distributor.strategy." + this.toString();
        }
    }
}

