/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.IPickaxeUser;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.network.PushEntityMessage;
import me.desht.modularrouters.util.BlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.network.PacketDistributor;

public class CompiledExtruderModule1
extends CompiledModule {
    public static final String NBT_EXTRUDER_DIST = "ExtruderDist";
    private static final double BASE_PUSH_STRENGTH = 0.55;
    private static final double AUGMENT_BOOST = 0.15;
    int distance;
    private final int pushingAugments;
    private final ItemStack pickaxe;

    public CompiledExtruderModule1(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        this.distance = router == null ? 0 : router.getExtData().func_74762_e(NBT_EXTRUDER_DIST + this.getFacing());
        this.pushingAugments = this.getAugmentCount((Item)ModItems.PUSHING_AUGMENT.get());
        ItemStack itemStack = this.pickaxe = stack.func_77973_b() instanceof IPickaxeUser ? ((IPickaxeUser)stack.func_77973_b()).getPickaxe(stack) : ItemStack.field_190927_a;
        if (!EnchantmentHelper.func_82781_a((ItemStack)stack).isEmpty() && EnchantmentHelper.func_82781_a((ItemStack)this.pickaxe).isEmpty()) {
            EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)stack), (ItemStack)this.pickaxe);
        }
    }

    @Override
    public boolean execute(@Nonnull TileEntityItemRouter router) {
        boolean extend = this.shouldExtend(router);
        World world = router.func_145831_w();
        if (extend && !router.isBufferEmpty() && this.distance < this.getRange() && this.isRegulationOK(router, false)) {
            BlockPos placePos = router.func_174877_v().func_177967_a(this.getFacing(), this.distance + 1);
            ItemStack toPlace = router.peekBuffer(1);
            BlockState state = BlockUtil.tryPlaceAsBlock(toPlace, world, placePos, this.getFacing(), this.getRouterFacing());
            if (state != null) {
                router.extractBuffer(1);
                router.getExtData().func_74768_a(NBT_EXTRUDER_DIST + this.getFacing(), ++this.distance);
                if (MRConfig.Common.Module.extruderSound) {
                    router.playSound(null, placePos, state.func_177230_c().getSoundType(state, (IWorldReader)world, placePos, null).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                }
                this.tryPushEntities(router.func_145831_w(), placePos, this.getFacing());
                return true;
            }
        } else if (!extend && this.distance > 0 && this.isRegulationOK(router, true)) {
            BlockPos breakPos = router.func_174877_v().func_177967_a(this.getFacing(), this.distance);
            BlockState oldState = world.func_180495_p(breakPos);
            Block oldBlock = oldState.func_177230_c();
            if (world.func_175623_d(breakPos) || oldBlock instanceof IFluidBlock) {
                router.getExtData().func_74768_a(NBT_EXTRUDER_DIST + this.getFacing(), --this.distance);
                return false;
            }
            BlockUtil.BreakResult dropResult = BlockUtil.tryBreakBlock(world, breakPos, this.getFilter(), this.pickaxe);
            if (dropResult.isBlockBroken()) {
                router.getExtData().func_74768_a(NBT_EXTRUDER_DIST + this.getFacing(), --this.distance);
                dropResult.processDrops(world, breakPos, router.getBuffer());
                if (MRConfig.Common.Module.extruderSound) {
                    router.playSound(null, breakPos, oldBlock.getSoundType(oldState, (IWorldReader)world, breakPos, null).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                }
                return true;
            }
        }
        return false;
    }

    void tryPushEntities(World world, BlockPos placePos, Direction facing) {
        if (!MRConfig.Common.Module.extruderPushEntities) {
            return;
        }
        Vector3d v = Vector3d.func_237492_c_((Vector3i)facing.func_176730_m()).func_186678_a(0.55 + (double)this.pushingAugments * 0.15);
        for (Entity entity : world.func_217357_a(Entity.class, new AxisAlignedBB(placePos))) {
            if (entity.func_184192_z() == PushReaction.IGNORE) continue;
            entity.func_213317_d(v);
            entity.func_230245_c_(false);
            entity.field_70123_F = false;
            entity.field_70124_G = false;
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).func_70637_d(true);
            }
            PacketDistributor.TargetPoint tp = new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 32.0, world.func_234923_W_());
            PacketHandler.NETWORK.send(PacketDistributor.NEAR.with(() -> tp), (Object)new PushEntityMessage(entity, v.field_72450_a, v.field_72448_b, v.field_72449_c));
        }
    }

    @Override
    public boolean shouldRun(boolean powered, boolean pulsed) {
        return true;
    }

    boolean shouldExtend(TileEntityItemRouter router) {
        switch (this.getRedstoneBehaviour()) {
            case ALWAYS: {
                return router.getRedstonePower() > 0;
            }
            case HIGH: {
                return router.getRedstonePower() == 15;
            }
            case LOW: {
                return router.getRedstonePower() == 0;
            }
        }
        return false;
    }
}

