/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.function.Supplier;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.network.GuiSyncMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;

public class FilterSettingsMessage {
    private Operation op;
    private CompoundNBT payload;
    private MFLocator locator;

    public FilterSettingsMessage() {
    }

    public FilterSettingsMessage(Operation op, MFLocator locator, CompoundNBT payload) {
        this.op = op;
        this.locator = locator;
        this.payload = payload;
    }

    public FilterSettingsMessage(PacketBuffer buf) {
        this.op = Operation.values()[buf.readByte()];
        this.locator = MFLocator.fromBuffer(buf);
        this.payload = buf.func_150793_b();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeByte(this.op.ordinal());
        this.locator.writeBuf(buf);
        buf.func_150786_a(this.payload);
    }

    public Operation getOp() {
        return this.op;
    }

    public CompoundNBT getPayload() {
        return this.payload;
    }

    public LazyOptional<IItemHandler> getTargetInventory() {
        ModuleTarget target = ModuleTarget.fromNBT(this.payload);
        return target.getItemHandler();
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                this.processPacket(player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void processPacket(ServerPlayerEntity player) {
        ItemStack moduleStack = this.locator.getModuleStack((PlayerEntity)player);
        ItemStack filterStack = this.locator.getTargetItem((PlayerEntity)player);
        if (filterStack.func_77973_b() instanceof ItemSmartFilter) {
            ItemSmartFilter sf = (ItemSmartFilter)filterStack.func_77973_b();
            GuiSyncMessage response = sf.onReceiveSettingsMessage((PlayerEntity)player, this, filterStack, moduleStack);
            if (!moduleStack.func_190926_b()) {
                TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockReader)player.field_70170_p, this.locator.routerPos).orElse(null);
                BaseModuleHandler.ModuleFilterHandler filterHandler = new BaseModuleHandler.ModuleFilterHandler(moduleStack, router);
                filterHandler.setStackInSlot(this.locator.filterSlot, filterStack);
                filterHandler.save();
                if (this.locator.hand != null) {
                    player.func_184611_a(this.locator.hand, filterHandler.getHolderStack());
                } else if (router != null) {
                    router.recompileNeeded(1);
                }
            }
            if (response != null) {
                PacketDistributor.TargetPoint tp = new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 8.0, player.func_130014_f_().func_234923_W_());
                PacketHandler.NETWORK.send(PacketDistributor.NEAR.with(() -> tp), (Object)response);
            }
        }
    }

    public static enum Operation {
        CLEAR_ALL,
        REMOVE_ITEM,
        MERGE,
        LOAD,
        ADD_STRING,
        REMOVE_AT,
        ANY_ALL_FLAG;

    }
}

