/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.function.Supplier;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.render.item_beam.ItemBeam;
import me.desht.modularrouters.client.util.ClientUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class ItemBeamMessage {
    private boolean reversed;
    private int duration;
    private BlockPos pos1;
    private BlockPos pos2;
    private ItemStack stack;
    private int color;
    private boolean itemFade;

    public ItemBeamMessage() {
    }

    public ItemBeamMessage(PacketBuffer buf) {
        this.reversed = buf.readBoolean();
        this.pos1 = buf.func_179259_c();
        this.pos2 = buf.func_179259_c();
        this.stack = buf.func_150791_c();
        this.color = buf.readInt();
        this.itemFade = buf.readBoolean();
        this.duration = buf.func_150792_a();
    }

    public ItemBeamMessage(TileEntity te, BlockPos other, boolean reversed, ItemStack stack, int color, int duration) {
        this.reversed = reversed;
        this.pos1 = te.func_174877_v();
        this.pos2 = other;
        this.stack = stack;
        this.color = color;
        this.itemFade = false;
        this.duration = duration;
    }

    public ItemBeamMessage withFadeout() {
        this.itemFade = true;
        return this;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.reversed);
        buf.func_179255_a(this.pos1);
        buf.func_179255_a(this.pos2);
        buf.func_150788_a(this.stack);
        buf.writeInt(this.color);
        buf.writeBoolean(this.itemFade);
        buf.func_150787_b(this.duration);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> TileEntityItemRouter.getRouterAt((IBlockReader)ClientUtil.theClientWorld(), this.pos1).ifPresent(te -> {
            BlockPos start = this.reversed ? this.pos2 : this.pos1;
            BlockPos end = this.reversed ? this.pos1 : this.pos2;
            te.addItemBeam(new ItemBeam(start, end, this.reversed, this.stack, this.color, Math.max(5, this.duration + 1), this.itemFade));
        }));
        ctx.get().setPacketHandled(true);
    }
}

