/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Supplier;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class OpenGuiMessage {
    private Operation operation;
    private MFLocator locator;

    public OpenGuiMessage() {
    }

    private OpenGuiMessage(Operation operation, MFLocator locator) {
        this.operation = operation;
        this.locator = locator;
    }

    OpenGuiMessage(PacketBuffer buf) {
        this.operation = Operation.values()[buf.readByte()];
        this.locator = MFLocator.fromBuffer(buf);
    }

    public static OpenGuiMessage openRouter(MFLocator locator) {
        return new OpenGuiMessage(Operation.ROUTER, locator);
    }

    public static OpenGuiMessage openModuleInHand(MFLocator locator) {
        return new OpenGuiMessage(Operation.MODULE_HELD, locator);
    }

    public static OpenGuiMessage openModuleInRouter(MFLocator locator) {
        return new OpenGuiMessage(Operation.MODULE_INSTALLED, locator);
    }

    public static OpenGuiMessage openFilterInHeldModule(MFLocator locator) {
        return new OpenGuiMessage(Operation.FILTER_HELD, locator);
    }

    public static OpenGuiMessage openFilterInInstalledModule(MFLocator locator) {
        return new OpenGuiMessage(Operation.FILTER_INSTALLED, locator);
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        pb.writeByte(this.operation.ordinal());
        this.locator.writeBuf(pb);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            assert (player != null);
            Optional<TileEntityItemRouter> r = this.locator.routerPos == null ? Optional.empty() : TileEntityItemRouter.getRouterAt((IBlockReader)player.func_130014_f_(), this.locator.routerPos);
            switch (this.operation) {
                case ROUTER: {
                    r.ifPresent(router -> NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)router, (BlockPos)this.locator.routerPos));
                    break;
                }
                case MODULE_HELD: {
                    NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new ItemModule.ContainerProvider((PlayerEntity)player, this.locator), this.locator::writeBuf);
                    break;
                }
                case MODULE_INSTALLED: {
                    r.ifPresent(router -> NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new ItemModule.ContainerProvider((PlayerEntity)player, this.locator), this.locator::writeBuf));
                    break;
                }
                case FILTER_HELD: {
                    NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new ItemSmartFilter.ContainerProvider((PlayerEntity)player, this.locator), this.locator::writeBuf);
                    break;
                }
                case FILTER_INSTALLED: {
                    r.ifPresent(router -> NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new ItemSmartFilter.ContainerProvider((PlayerEntity)player, this.locator), this.locator::writeBuf));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static enum Operation {
        ROUTER,
        MODULE_HELD,
        MODULE_INSTALLED,
        FILTER_HELD,
        FILTER_INSTALLED;

    }
}

