/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.function.Supplier;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.util.ClientUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class RouterUpgradesSyncMessage {
    private BlockPos pos;
    private ItemStackHandler handler;

    public RouterUpgradesSyncMessage() {
    }

    public RouterUpgradesSyncMessage(TileEntityItemRouter router) {
        this.pos = router.func_174877_v();
        IItemHandler upgradesHandler = router.getUpgrades();
        this.handler = new ItemStackHandler(upgradesHandler.getSlots());
        for (int i = 0; i < upgradesHandler.getSlots(); ++i) {
            this.handler.setStackInSlot(i, upgradesHandler.getStackInSlot(i));
        }
    }

    public RouterUpgradesSyncMessage(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.handler = new ItemStackHandler();
        this.handler.deserializeNBT(buf.func_150793_b());
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_150786_a(this.handler.serializeNBT());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World w = ClientUtil.theClientWorld();
            if (w != null) {
                TileEntityItemRouter.getRouterAt((IBlockReader)w, this.pos).ifPresent(router -> router.setUpgradesFrom((IItemHandler)this.handler));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

