/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class ParticleTextureStitcher<T> {
    private final ResourceLocation[] textures;
    private TextureAtlasSprite[] loadedSprites;

    public static <T extends Particle> ParticleTextureStitcher create(Class<T> cls, ResourceLocation[] textures) {
        return new ParticleTextureStitcher<T>(textures);
    }

    public static <T extends Particle> ParticleTextureStitcher create(Class<T> cls, ResourceLocation texture) {
        return ParticleTextureStitcher.create(cls, new ResourceLocation[]{texture});
    }

    private ParticleTextureStitcher(ResourceLocation[] textures) {
        this.textures = textures;
    }

    public ResourceLocation[] getTextures() {
        return this.textures;
    }

    public void setSprites(TextureAtlasSprite[] sprites) {
        this.loadedSprites = sprites;
    }

    public TextureAtlasSprite[] getSprites() {
        return this.loadedSprites;
    }

    public static enum Stitcher {
        INSTANCE;


        @SubscribeEvent
        public void onTextureStitch(TextureStitchEvent.Pre event) {
            MMParticle[] particles;
            TextureMap map = event.getMap();
            for (MMParticle particle : particles = MMParticle.values()) {
                ParticleTextureStitcher<Particle> stitcher = particle.getFactory().getStitcher();
                if (stitcher == null) continue;
                ResourceLocation[] textures = stitcher.getTextures();
                TextureAtlasSprite[] sprites = new TextureAtlasSprite[textures.length];
                for (int i = 0; i < textures.length; ++i) {
                    sprites[i] = map.func_174942_a(textures[i]);
                }
                stitcher.setSprites(sprites);
            }
        }
    }

    public static interface IParticleSpriteReceiver {
        default public void setStitchedSprites(TextureAtlasSprite[] sprites) {
            ((Particle)this).func_187117_a(sprites[0]);
        }
    }
}

