/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particles;

import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.client.particle.ParticleTextureStitcher;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ParticleCloud
extends Particle
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    private int whichTex;
    private float red;
    private float green;
    private float blue;
    private float scale;
    private EnumCloudBehavior behavior;
    private float airDrag;

    public ParticleCloud(World world, double x, double y, double z, double vx, double vy, double vz, double r, double g, double b, int sprite, double scale, int duration, EnumCloudBehavior behavior, double airDrag) {
        super(world, x, y, z);
        this.scale = (float)scale * 0.5f;
        this.field_70547_e = duration;
        this.whichTex = sprite;
        this.field_187129_i = vx;
        this.field_187130_j = vy;
        this.field_187131_k = vz;
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
        this.behavior = behavior;
        this.field_190014_F = this.field_190015_G = (float)((double)this.field_187136_p.nextInt(4) * Math.PI / 2.0);
        this.airDrag = (float)airDrag;
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187129_i *= (double)this.airDrag;
        this.field_187130_j *= (double)this.airDrag;
        this.field_187131_k *= (double)this.airDrag;
        ++this.field_70546_d;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float var = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        this.field_82339_as = 0.2f * (float)(1.0 - Math.exp(5.0f * (var - 1.0f)) - Math.pow(2000.0, -var));
        if ((double)this.field_82339_as < 0.01) {
            this.field_82339_as = 0.01f;
        }
        this.field_70552_h = this.red;
        this.field_70553_i = this.green;
        this.field_70551_j = this.blue;
        this.field_70544_f = this.behavior == EnumCloudBehavior.SHRINK ? this.scale * (1.0f - 0.7f * var + 0.3f) : (this.behavior == EnumCloudBehavior.GROW ? this.scale * (0.7f * var + 0.3f) : this.scale);
        float f = (float)this.field_94054_b / 16.0f;
        float f1 = f + 0.0624375f;
        float f2 = (float)this.field_94055_c / 16.0f;
        float f3 = f2 + 0.0624375f;
        float f4 = 0.1f * this.field_70544_f;
        if (this.field_187119_C != null) {
            int row = this.whichTex / 2;
            int column = this.whichTex % 2;
            f = this.field_187119_C.func_94214_a((double)((float)row / 2.0f * 16.0f));
            f1 = this.field_187119_C.func_94214_a((double)((float)(row + 1) / 2.0f * 16.0f));
            f2 = this.field_187119_C.func_94207_b((double)((float)column / 2.0f * 16.0f));
            f3 = this.field_187119_C.func_94207_b((double)((float)(column + 1) / 2.0f * 16.0f));
        }
        float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(-rotationYZ * f4 - rotationXZ * f4)), new Vec3d((double)(-rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(-rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(rotationYZ * f4 - rotationXZ * f4))};
        if (this.field_190014_F != 0.0f) {
            float f8 = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float f9 = MathHelper.func_76134_b((float)(f8 * 0.5f));
            float f10 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleCloud.field_190016_K.field_72450_a;
            float f11 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleCloud.field_190016_K.field_72448_b;
            float f12 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleCloud.field_190016_K.field_72449_c;
            Vec3d vec3d = new Vec3d((double)f10, (double)f11, (double)f12);
            for (int l = 0; l < 4; ++l) {
                avec3d[l] = vec3d.func_186678_a(2.0 * avec3d[l].func_72430_b(vec3d)).func_178787_e(avec3d[l].func_186678_a((double)(f9 * f9) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(avec3d[l]).func_186678_a((double)(2.0f * f9)));
            }
        }
        buffer.func_181662_b((double)f5 + avec3d[0].field_72450_a, (double)f6 + avec3d[0].field_72448_b, (double)f7 + avec3d[0].field_72449_c).func_187315_a((double)f1, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[1].field_72450_a, (double)f6 + avec3d[1].field_72448_b, (double)f7 + avec3d[1].field_72449_c).func_187315_a((double)f1, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[2].field_72450_a, (double)f6 + avec3d[2].field_72448_b, (double)f7 + avec3d[2].field_72449_c).func_187315_a((double)f, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[3].field_72450_a, (double)f6 + avec3d[3].field_72448_b, (double)f7 + avec3d[3].field_72449_c).func_187315_a((double)f, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
    }

    public void func_70536_a(int particleTextureIndex) {
        if (this.func_70537_b() == 0) {
            this.field_94054_b = particleTextureIndex / 16;
            this.field_94055_c = particleTextureIndex % 16;
        }
    }

    public boolean func_187111_c() {
        return true;
    }

    public static final class CloudFactory
    extends ParticleFactory<CloudFactory, ParticleCloud> {
        public CloudFactory() {
            super(ParticleCloud.class, ParticleTextureStitcher.create(ParticleCloud.class, new ResourceLocation("mowziesmobs", "particles/cloud")));
        }

        @Override
        public ParticleCloud createParticle(ParticleFactory.ImmutableParticleArgs args) {
            if (args.data.length >= 11) {
                return new ParticleCloud(args.world, args.x, args.y, args.z, (Double)args.data[0], (Double)args.data[1], (Double)args.data[2], (Double)args.data[3], (Double)args.data[4], (Double)args.data[5], (Integer)args.data[6], (Double)args.data[7], (Integer)args.data[8], (EnumCloudBehavior)((Object)args.data[9]), (Double)args.data[10]);
            }
            if (args.data.length >= 10) {
                return new ParticleCloud(args.world, args.x, args.y, args.z, (Double)args.data[0], (Double)args.data[1], (Double)args.data[2], (Double)args.data[3], (Double)args.data[4], (Double)args.data[5], (Integer)args.data[6], (Double)args.data[7], (Integer)args.data[8], (EnumCloudBehavior)((Object)args.data[9]), 1.0);
            }
            return new ParticleCloud(args.world, args.x, args.y, args.z, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0, 10.0, 40, EnumCloudBehavior.CONSTANT, 1.0);
        }
    }

    public static enum EnumCloudBehavior {
        SHRINK,
        GROW,
        CONSTANT;

    }
}

