/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai;

import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public class MMWalkNodeProcessor
extends WalkNodeProcessor {
    public PathPoint func_186318_b() {
        BlockPos.MutableBlockPos pos;
        int y;
        AxisAlignedBB bounds = this.field_186326_b.func_174813_aQ();
        if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
            y = (int)bounds.field_72338_b;
            pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), y, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
            Block block = this.field_176169_a.func_180495_p((BlockPos)pos).func_177230_c();
            while (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
                pos.func_185336_p(++y);
                block = this.field_176169_a.func_180495_p((BlockPos)pos).func_177230_c();
            }
        } else if (this.field_186326_b.field_70122_E) {
            y = MathHelper.func_76128_c((double)(bounds.field_72338_b + 0.5));
        } else {
            y = MathHelper.func_76128_c((double)this.field_186326_b.field_70163_u);
            pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), y, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
            while (y > 0 && (this.field_176169_a.func_180495_p((BlockPos)pos).func_185904_a() == Material.field_151579_a || this.field_176169_a.func_180495_p((BlockPos)pos).func_177230_c().func_176205_b(this.field_176169_a, (BlockPos)pos))) {
                pos.func_185336_p(y--);
            }
            ++y;
        }
        float r = this.field_186326_b.field_70130_N * 0.5f;
        int x = MathHelper.func_76128_c((double)(this.field_186326_b.field_70165_t - (double)r));
        int z = MathHelper.func_76128_c((double)(this.field_186326_b.field_70161_v - (double)r));
        if (this.field_186326_b.func_184643_a(this.getPathType(this.field_186326_b, x, y, z)) < 0.0f) {
            HashSet diagonals = Sets.newHashSet();
            diagonals.add(new BlockPos(bounds.field_72340_a - (double)r, (double)y, bounds.field_72339_c - (double)r));
            diagonals.add(new BlockPos(bounds.field_72340_a - (double)r, (double)y, bounds.field_72334_f - (double)r));
            diagonals.add(new BlockPos(bounds.field_72336_d - (double)r, (double)y, bounds.field_72339_c - (double)r));
            diagonals.add(new BlockPos(bounds.field_72336_d - (double)r, (double)y, bounds.field_72334_f - (double)r));
            for (BlockPos p : diagonals) {
                PathNodeType pathnodetype = this.getPathType(this.field_186326_b, p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
                if (!(this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f)) continue;
                return this.func_176159_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
            }
        }
        return this.func_176159_a(x, y, z);
    }

    public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        PathPoint southeast;
        PathPoint southwest;
        PathPoint northeast;
        PathPoint northwest;
        boolean westPassable;
        int optionCount = 0;
        int step = 0;
        PathNodeType pathnodetype = this.getPathType(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f) {
            step = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        BlockPos under = new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c).func_177977_b();
        double floor = (double)currentPoint.field_75837_b - (1.0 - this.field_176169_a.func_180495_p((BlockPos)under).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)under).field_72337_e);
        PathPoint south = this.getNode(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, step, floor, EnumFacing.SOUTH);
        PathPoint west = this.getNode(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, step, floor, EnumFacing.WEST);
        PathPoint east = this.getNode(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, step, floor, EnumFacing.EAST);
        PathPoint north = this.getNode(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, step, floor, EnumFacing.NORTH);
        if (south != null && !south.field_75842_i && south.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionCount++] = south;
        }
        if (west != null && !west.field_75842_i && west.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionCount++] = west;
        }
        if (east != null && !east.field_75842_i && east.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionCount++] = east;
        }
        if (north != null && !north.field_75842_i && north.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionCount++] = north;
        }
        boolean northPassable = north == null || north.field_186287_m == PathNodeType.OPEN || north.field_186286_l != 0.0f;
        boolean southPassable = south == null || south.field_186287_m == PathNodeType.OPEN || south.field_186286_l != 0.0f;
        boolean eastPassable = east == null || east.field_186287_m == PathNodeType.OPEN || east.field_186286_l != 0.0f;
        boolean bl = westPassable = west == null || west.field_186287_m == PathNodeType.OPEN || west.field_186286_l != 0.0f;
        if (northPassable && westPassable && (northwest = this.getNode(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, step, floor, EnumFacing.NORTH)) != null && !northwest.field_75842_i && northwest.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionCount++] = northwest;
        }
        if (northPassable && eastPassable && (northeast = this.getNode(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, step, floor, EnumFacing.NORTH)) != null && !northeast.field_75842_i && northeast.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionCount++] = northeast;
        }
        if (southPassable && westPassable && (southwest = this.getNode(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, step, floor, EnumFacing.SOUTH)) != null && !southwest.field_75842_i && southwest.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionCount++] = southwest;
        }
        if (southPassable && eastPassable && (southeast = this.getNode(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, step, floor, EnumFacing.SOUTH)) != null && !southeast.field_75842_i && southeast.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionCount++] = southeast;
        }
        return optionCount;
    }

    @Nullable
    private PathPoint getNode(int x, int y, int z, int step, double floor, EnumFacing dir) {
        PathPoint result = null;
        BlockPos pos = new BlockPos(x, y, z);
        BlockPos under = pos.func_177977_b();
        double dirFloor = (double)y - (1.0 - this.field_176169_a.func_180495_p((BlockPos)under).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)under).field_72337_e);
        if (dirFloor - floor > 1.125) {
            return null;
        }
        PathNodeType atNode = this.getPathType(this.field_186326_b, x, y, z);
        float malus = this.field_186326_b.func_184643_a(atNode);
        double r = (double)this.field_186326_b.field_70130_N / 2.0;
        if (malus >= 0.0f) {
            result = this.func_176159_a(x, y, z);
            result.field_186287_m = atNode;
            result.field_186286_l = Math.max(result.field_186286_l, malus);
        }
        if (atNode == PathNodeType.WALKABLE) {
            return result;
        }
        if (result == null && step > 0 && atNode != PathNodeType.FENCE && atNode != PathNodeType.TRAPDOOR && (result = this.getNode(x, y + 1, z, step - 1, floor, dir)) != null && (result.field_186287_m == PathNodeType.OPEN || result.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.field_70130_N < 1.0f) {
            double px = (double)(x - dir.func_82601_c()) + 0.5;
            double pz = (double)(z - dir.func_82599_e()) + 0.5;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(px - r, (double)y + 0.001, pz - r, px + r, (double)((float)y + this.field_186326_b.field_70131_O), pz + r);
            AxisAlignedBB floorShape = this.field_176169_a.func_180495_p(pos).func_185900_c(this.field_176169_a, pos);
            AxisAlignedBB collision = axisalignedbb.func_72321_a(0.0, floorShape.field_72337_e - 0.002, 0.0);
            if (this.field_186326_b.field_70170_p.func_184143_b(collision)) {
                result = null;
            }
        }
        if (atNode == PathNodeType.OPEN) {
            PathNodeType down;
            AxisAlignedBB collision = new AxisAlignedBB((double)x - r + (double)this.field_176168_c * 0.5, (double)y + 0.001, (double)z - r + (double)this.field_176166_e * 0.5, (double)x + r + (double)this.field_176168_c * 0.5, (double)((float)y + this.field_186326_b.field_70131_O), (double)z + r + (double)this.field_176166_e * 0.5);
            if (this.field_186326_b.field_70170_p.func_184143_b(collision)) {
                return null;
            }
            if (this.field_186326_b.field_70130_N >= 1.0f && (down = this.getPathType(this.field_186326_b, x, y - 1, z)) == PathNodeType.BLOCKED) {
                result = this.func_176159_a(x, y, z);
                result.field_186287_m = PathNodeType.WALKABLE;
                result.field_186286_l = Math.max(result.field_186286_l, malus);
                return result;
            }
            int fallDistance = 0;
            while (y-- > 0 && atNode == PathNodeType.OPEN) {
                if (fallDistance++ >= this.field_186326_b.func_82143_as()) {
                    return null;
                }
                atNode = this.getPathType(this.field_186326_b, x, y, z);
                malus = this.field_186326_b.func_184643_a(atNode);
                if (atNode != PathNodeType.OPEN && malus >= 0.0f) {
                    result = this.func_176159_a(x, y, z);
                    result.field_186287_m = atNode;
                    result.field_186286_l = Math.max(result.field_186286_l, malus);
                    break;
                }
                if (!(malus < 0.0f)) continue;
                return null;
            }
        }
        return result;
    }

    private PathNodeType getPathType(EntityLiving living, int x, int y, int z) {
        return this.func_186319_a(this.field_176169_a, x, y, z, living, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
    }
}

