/*
 * Decompiled with CFR 0.152.
 */
package nebulaecraft;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import nebulaecraft.NebulaecraftMod;
import nebulaecraft.NebulaecraftModVariables;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class NebulaecraftModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public NebulaecraftModElements() {
        sounds.put(new ResourceLocation("nebulaecraft", "so_below"), new SoundEvent(new ResourceLocation("nebulaecraft", "so_below")));
        sounds.put(new ResourceLocation("nebulaecraft", "chrysopoeia"), new SoundEvent(new ResourceLocation("nebulaecraft", "chrysopoeia")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("nebulaecraft").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
        this.addNetworkMessage(NebulaecraftModVariables.WorldSavedDataSyncMessage.class, NebulaecraftModVariables.WorldSavedDataSyncMessage::buffer, NebulaecraftModVariables.WorldSavedDataSyncMessage::new, NebulaecraftModVariables.WorldSavedDataSyncMessage::handler);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            NebulaecraftModVariables.MapVariables mapdata = NebulaecraftModVariables.MapVariables.get(event.getPlayer().field_70170_p);
            NebulaecraftModVariables.WorldVariables worlddata = NebulaecraftModVariables.WorldVariables.get(event.getPlayer().field_70170_p);
            if (mapdata != null) {
                NebulaecraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new NebulaecraftModVariables.WorldSavedDataSyncMessage(0, mapdata));
            }
            if (worlddata != null) {
                NebulaecraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new NebulaecraftModVariables.WorldSavedDataSyncMessage(1, worlddata));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        NebulaecraftModVariables.WorldVariables worlddata;
        if (!event.getPlayer().field_70170_p.field_72995_K && (worlddata = NebulaecraftModVariables.WorldVariables.get(event.getPlayer().field_70170_p)) != null) {
            NebulaecraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new NebulaecraftModVariables.WorldSavedDataSyncMessage(1, worlddata));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        NebulaecraftMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<Biome>> getBiomes() {
        return this.biomes;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final NebulaecraftModElements elements;
        protected final int sortid;

        public ModElement(NebulaecraftModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

