/*
 * Decompiled with CFR 0.152.
 */
package nebulaecraft.world.dimension;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.LongFunction;
import javax.annotation.Nullable;
import nebulaecraft.NebulaecraftModElements;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.OverworldChunkGenerator;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.carver.CaveWorldCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.layer.IslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IC0Transformer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.common.extensions.IForgeDimension;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;

@NebulaecraftModElements.ModElement.Tag
public class Kepler186fDimension
extends NebulaecraftModElements.ModElement {
    @ObjectHolder(value="nebulaecraft:kepler186f")
    public static final ModDimension dimension = null;
    public static DimensionType type = null;
    private static Biome[] dimensionBiomes;

    public Kepler186fDimension(NebulaecraftModElements instance) {
        super(instance, 153);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @SubscribeEvent
    public void registerDimension(RegistryEvent.Register<ModDimension> event) {
        event.getRegistry().register(new CustomModDimension().setRegistryName("kepler186f"));
    }

    @SubscribeEvent
    public void onRegisterDimensionsEvent(RegisterDimensionsEvent event) {
        if (DimensionType.func_193417_a((ResourceLocation)new ResourceLocation("nebulaecraft:kepler186f")) == null) {
            DimensionManager.registerDimension((ResourceLocation)new ResourceLocation("nebulaecraft:kepler186f"), (ModDimension)dimension, null, (boolean)true);
        }
        type = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation("nebulaecraft:kepler186f"));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        dimensionBiomes = new Biome[]{(Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("nebulaecraft:swampyvalley")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("nebulaecraft:highfield")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("nebulaecraft:icyfield")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("nebulaecraft:colddesert")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("nebulaecraft:aliveocean")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("nebulaecraft:snowyaliveocean")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("nebulaecraft:poles")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("nebulaecraft:redjungle")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("nebulaecraft:frolda"))};
    }

    public static class BiomeProviderCustom
    extends BiomeProvider {
        private Layer genBiomes;

        public BiomeProviderCustom(World world) {
            super(new HashSet<Biome>(Arrays.asList(dimensionBiomes)));
            this.genBiomes = this.getBiomeLayer(world.func_72905_C());
            for (final Biome biome : this.field_226837_c_) {
                biome.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)new CaveWorldCarver(ProbabilityConfig::func_214645_a, 256){
                    {
                        super(x0, x1);
                        this.field_222718_j = ImmutableSet.of((Object)Blocks.field_150348_b.func_176223_P().func_177230_c(), (Object)biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c(), (Object)biome.func_205401_q().func_215452_a().func_204109_b().func_177230_c());
                    }
                }, (ICarverConfig)new ProbabilityConfig(0.14285715f)));
            }
        }

        public Biome func_225526_b_(int x, int y, int z) {
            return this.genBiomes.func_215738_a(x, z);
        }

        private Layer getBiomeLayer(long seed) {
            LongFunction<IExtendedNoiseRandom> contextFactory = l -> new LazyAreaLayerContext(25, seed, l);
            IAreaFactory parentLayer = IslandLayer.INSTANCE.func_202823_a(contextFactory.apply(1L));
            IAreaFactory biomeLayer = new BiomeLayerCustom().func_202713_a(contextFactory.apply(200L), parentLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1000L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1001L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1002L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1003L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1004L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1005L), biomeLayer);
            return new Layer(biomeLayer);
        }
    }

    public static class BiomeLayerCustom
    implements IC0Transformer {
        public int func_202726_a(INoiseRandom context, int value) {
            return Registry.field_212624_m.func_148757_b((Object)dimensionBiomes[context.func_202696_a(dimensionBiomes.length)]);
        }
    }

    public static class ChunkProviderModded
    extends OverworldChunkGenerator {
        private static final int SEALEVEL = 63;

        public ChunkProviderModded(IWorld world, BiomeProvider provider) {
            super(world, provider, new OverworldGenSettings(){

                public BlockState func_205532_l() {
                    return Blocks.field_150348_b.func_176223_P();
                }

                public BlockState func_205533_m() {
                    return Blocks.field_150355_j.func_176223_P();
                }
            });
            this.field_222558_e.func_202423_a(5349);
        }

        public int func_222530_f() {
            return 63;
        }

        public void func_203222_a(ServerWorld worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        }
    }

    public static class CustomDimension
    extends Dimension {
        private BiomeProviderCustom biomeProviderCustom = null;

        public CustomDimension(World world, DimensionType type) {
            super(world, type, 0.0f);
            this.field_76576_e = false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public Vec3d func_76562_b(float cangle, float ticks) {
            return new Vec3d(1.0, 0.4, 0.2);
        }

        public ChunkGenerator<?> func_186060_c() {
            if (this.biomeProviderCustom == null) {
                this.biomeProviderCustom = new BiomeProviderCustom(this.field_76579_a);
            }
            return new ChunkProviderModded((IWorld)this.field_76579_a, this.biomeProviderCustom);
        }

        public boolean func_76569_d() {
            return true;
        }

        public boolean func_76567_e() {
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_76568_b(int x, int z) {
            return false;
        }

        public IForgeDimension.SleepResult canSleepAt(PlayerEntity player, BlockPos pos) {
            return IForgeDimension.SleepResult.ALLOW;
        }

        @Nullable
        public BlockPos func_206920_a(ChunkPos chunkPos, boolean checkValid) {
            return null;
        }

        @Nullable
        public BlockPos func_206921_a(int x, int z, boolean checkValid) {
            return null;
        }

        public boolean func_177500_n() {
            return false;
        }

        public float func_76563_a(long worldTime, float partialTicks) {
            double d0 = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
            double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
            return (float)(d0 * 2.0 + d1) / 3.0f;
        }
    }

    public static class CustomModDimension
    extends ModDimension {
        public BiFunction<World, DimensionType, ? extends Dimension> getFactory() {
            return CustomDimension::new;
        }
    }
}

