/*
 * Decompiled with CFR 0.152.
 */
package nebulaecraft.world.structure;

import java.util.Random;
import nebulaecraft.NebulaecraftModElements;
import nebulaecraft.world.dimension.Kepler186fDimension;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@NebulaecraftModElements.ModElement.Tag
public class ShortressTree1eStructure
extends NebulaecraftModElements.ModElement {
    public ShortressTree1eStructure(NebulaecraftModElements instance) {
        super(instance, 148);
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        Feature<NoFeatureConfig> feature = new Feature<NoFeatureConfig>(NoFeatureConfig::func_214639_a){

            public boolean place(IWorld iworld, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
                int ci = pos.func_177958_n();
                int ck = pos.func_177952_p();
                DimensionType dimensionType = iworld.func_201675_m().func_186058_p();
                boolean dimensionCriteria = false;
                if (dimensionType == Kepler186fDimension.type) {
                    dimensionCriteria = true;
                }
                if (!dimensionCriteria) {
                    return false;
                }
                if (random.nextInt(1000000) + 1 <= 1000000) {
                    int count = random.nextInt(1) + 1;
                    for (int a = 0; a < count; ++a) {
                        int i = ci + random.nextInt(16) + 8;
                        int k = ck + random.nextInt(16) + 8;
                        int j = iworld.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, i, k);
                        BlockState blockAt = iworld.func_180495_p(new BlockPos(i, --j, k));
                        boolean blockCriteria = false;
                        if (blockAt.func_177230_c() == Blocks.field_196658_i.func_176223_P().func_177230_c()) {
                            blockCriteria = true;
                        }
                        if (!blockCriteria) continue;
                        Template template = ((ServerWorld)iworld.func_201672_e()).func_217485_w().func_186340_h().func_200220_a(new ResourceLocation("nebulaecraft", "shortresstree1"));
                        if (template == null) {
                            return false;
                        }
                        Rotation rotation = Rotation.values()[random.nextInt(3)];
                        Mirror mirror = Mirror.values()[random.nextInt(2)];
                        BlockPos spawnTo = new BlockPos(i, j + 1, k);
                        template.func_186260_a(iworld, spawnTo, new PlacementSettings().func_186220_a(rotation).func_189950_a(random).func_186214_a(mirror).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a).func_186218_a((ChunkPos)null).func_186222_a(false));
                    }
                }
                return true;
            }
        };
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            boolean biomeCriteria = false;
            if (ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).equals((Object)new ResourceLocation("nebulaecraft:swampyvalley"))) {
                biomeCriteria = true;
            }
            if (!biomeCriteria) continue;
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, feature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        }
    }
}

