/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.nethercraft.entities;

import com.legacy.nethercraft.Nethercraft;
import com.legacy.nethercraft.entities.block.EntityGhastBomb;
import com.legacy.nethercraft.entities.hostile.EntityBloodyZombie;
import com.legacy.nethercraft.entities.hostile.EntityCamouflageSpider;
import com.legacy.nethercraft.entities.hostile.EntityDarkZombie;
import com.legacy.nethercraft.entities.hostile.EntityImp;
import com.legacy.nethercraft.entities.hostile.EntityLavaSlime;
import com.legacy.nethercraft.entities.item.EntityLavaBoat;
import com.legacy.nethercraft.entities.item.EntityNPainting;
import com.legacy.nethercraft.entities.projectile.EntityLiniumArrow;
import com.legacy.nethercraft.entities.projectile.EntityNeridiumArrow;
import com.legacy.nethercraft.entities.projectile.EntityNetherArrow;
import com.legacy.nethercraft.entities.projectile.EntityPyridiumArrow;
import com.legacy.nethercraft.entities.projectile.EntitySlimeEggs;
import com.legacy.nethercraft.entities.tribal.EntityTribalTrainee;
import com.legacy.nethercraft.entities.tribal.EntityTribalWarrior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class NetherEntityRegistry {
    private static int modEntityId;

    public static void initialization() {
        NetherEntityRegistry.register("dark_zombie", EntityDarkZombie.class, 0x700C0C, 0x323131);
        NetherEntityRegistry.register("lava_slime", EntityLavaSlime.class, 0xA43434, 12278313);
        NetherEntityRegistry.register("camouflage_spider", EntityCamouflageSpider.class, 4134703, 7409184);
        NetherEntityRegistry.register("imp", EntityImp.class, 2051348, 9320449);
        NetherEntityRegistry.register("ghast_bomb", EntityGhastBomb.class);
        NetherEntityRegistry.register("linium_arrow", EntityLiniumArrow.class);
        NetherEntityRegistry.register("neridium_arrow", EntityNeridiumArrow.class);
        NetherEntityRegistry.register("nether_arrow", EntityNetherArrow.class);
        NetherEntityRegistry.register("pyridium_arrow", EntityPyridiumArrow.class);
        NetherEntityRegistry.register("slime_eggs", EntitySlimeEggs.class);
        NetherEntityRegistry.register("lava_boat", EntityLavaBoat.class);
        NetherEntityRegistry.register("nether_painting", EntityNPainting.class);
        NetherEntityRegistry.register("tribal_trainee", EntityTribalTrainee.class, 0x787878, 7409184);
        NetherEntityRegistry.register("tribal_warrior", EntityTribalWarrior.class, 0x787878, 5246577);
        NetherEntityRegistry.register("bloody_zombie", EntityBloodyZombie.class, 0x700C0C, 3478034);
        NetherEntityRegistry.register(EntityImp.class, 100, 1, 4);
        NetherEntityRegistry.register(EntityTribalTrainee.class, 50, 1, 3);
        NetherEntityRegistry.register(EntityTribalWarrior.class, 50, 1, 3);
        if (Loader.isModLoaded((String)"sponge") || Loader.isModLoaded((String)"spongeforge")) {
            NetherEntityRegistry.register(EntityDarkZombie.class, 10, 0, 2);
            NetherEntityRegistry.register(EntityBloodyZombie.class, 10, 0, 2);
            NetherEntityRegistry.register(EntityCamouflageSpider.class, 10, 1, 3);
            NetherEntityRegistry.register(EntityLavaSlime.class, 10, 2, 4);
        } else {
            NetherEntityRegistry.register(EntityDarkZombie.class, 60, 0, 2);
            NetherEntityRegistry.register(EntityBloodyZombie.class, 60, 0, 2);
            NetherEntityRegistry.register(EntityCamouflageSpider.class, 70, 1, 3);
            NetherEntityRegistry.register(EntityLavaSlime.class, 60, 2, 4);
        }
    }

    private static void register(String entityName, Class<? extends Entity> clazz, int primaryEggColor, int secondaryEggColor) {
        EntityRegistry.registerModEntity((ResourceLocation)Nethercraft.locate(entityName), clazz, (String)("nethercraft." + entityName), (int)modEntityId, (Object)Nethercraft.instance, (int)80, (int)3, (boolean)false, (int)primaryEggColor, (int)secondaryEggColor);
        ++modEntityId;
    }

    private static void register(String entityName, Class<? extends Entity> clazz) {
        EntityRegistry.registerModEntity((ResourceLocation)Nethercraft.locate(entityName), clazz, (String)("nethercraft." + entityName), (int)modEntityId, (Object)Nethercraft.instance, (int)64, (int)3, (boolean)false);
        ++modEntityId;
    }

    public static void register(Class<? extends EntityLiving> entityClass, int weight, int min, int max) {
        EntityRegistry.addSpawn(entityClass, (int)weight, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76778_j});
    }
}

