/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.nethercraft.tileentity;

import com.legacy.nethercraft.blocks.container.BlockNetherChest;
import com.legacy.nethercraft.tileentity.ability.NetherDoubleChestItemHandler;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityGlowoodChest
extends TileEntityLockableLoot
implements ITickable,
IInventory {
    private NonNullList<ItemStack> chestContents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    public boolean adjacentChestChecked;
    public TileEntityGlowoodChest adjacentChestZNeg;
    public TileEntityGlowoodChest adjacentChestXPos;
    public TileEntityGlowoodChest adjacentChestXNeg;
    public TileEntityGlowoodChest adjacentChestZPos;
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    private int ticksSinceSync;
    private String customName;
    public NetherDoubleChestItemHandler doubleChestHandler;

    public int func_70302_i_() {
        return 27;
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        this.func_184281_d(null);
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.chestContents, (int)index, (int)count);
        if (itemstack != null) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.chestContents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        this.func_184281_d(null);
        return ItemStackHelper.func_188383_a(this.chestContents, (int)index);
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.chest";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void func_190575_a(String name) {
        this.customName = name;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.chestContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.chestContents);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.chestContents);
        }
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.adjacentChestChecked = false;
        this.doubleChestHandler = null;
    }

    private void setNeighbor(TileEntityGlowoodChest chestTe, EnumFacing side) {
        if (chestTe.func_145837_r()) {
            this.adjacentChestChecked = false;
        } else if (this.adjacentChestChecked) {
            switch (side) {
                case NORTH: {
                    if (this.adjacentChestZNeg == chestTe) break;
                    this.adjacentChestChecked = false;
                    break;
                }
                case SOUTH: {
                    if (this.adjacentChestZPos == chestTe) break;
                    this.adjacentChestChecked = false;
                    break;
                }
                case EAST: {
                    if (this.adjacentChestXPos == chestTe) break;
                    this.adjacentChestChecked = false;
                    break;
                }
                case WEST: {
                    if (this.adjacentChestXNeg == chestTe) break;
                    this.adjacentChestChecked = false;
                }
            }
        }
    }

    public void checkForAdjacentChests() {
        if (!this.adjacentChestChecked) {
            this.adjacentChestChecked = true;
            this.adjacentChestXNeg = this.getAdjacentChest(EnumFacing.WEST);
            this.adjacentChestXPos = this.getAdjacentChest(EnumFacing.EAST);
            this.adjacentChestZNeg = this.getAdjacentChest(EnumFacing.NORTH);
            this.adjacentChestZPos = this.getAdjacentChest(EnumFacing.SOUTH);
        }
    }

    @Nullable
    protected TileEntityGlowoodChest getAdjacentChest(EnumFacing side) {
        TileEntity tileentity;
        BlockPos blockpos = this.field_174879_c.func_177972_a(side);
        if (this.isChestAt(blockpos) && (tileentity = this.field_145850_b.func_175625_s(blockpos)) instanceof TileEntityGlowoodChest) {
            TileEntityGlowoodChest tileentitychest = (TileEntityGlowoodChest)tileentity;
            tileentitychest.setNeighbor(this, side.func_176734_d());
            return tileentitychest;
        }
        return null;
    }

    private boolean isChestAt(BlockPos posIn) {
        if (this.field_145850_b == null) {
            return false;
        }
        Block block = this.field_145850_b.func_180495_p(posIn).func_177230_c();
        return block instanceof BlockNetherChest;
    }

    public void func_73660_a() {
        this.checkForAdjacentChests();
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            this.numPlayersUsing = 0;
            float f = 5.0f;
            for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - f), (double)((float)j - f), (double)((float)k - f), (double)((float)(i + 1) + f), (double)((float)(j + 1) + f), (double)((float)(k + 1) + f)))) {
                IInventory iinventory;
                if (!(entityplayer.field_71070_bA instanceof ContainerChest) || (iinventory = ((ContainerChest)entityplayer.field_71070_bA).func_85151_d()) != this && (!(iinventory instanceof InventoryLargeChest) || !((InventoryLargeChest)iinventory).func_90010_a((IInventory)this))) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        float f1 = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f && this.adjacentChestZNeg == null && this.adjacentChestXNeg == null) {
            double d1 = (double)i + 0.5;
            double d2 = (double)k + 0.5;
            if (this.adjacentChestZPos != null) {
                d2 += 0.5;
            }
            if (this.adjacentChestXPos != null) {
                d1 += 0.5;
            }
            this.field_145850_b.func_184148_a((EntityPlayer)null, d1, (double)j + 0.5, d2, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f3;
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += f1) : (this.lidAngle -= f1);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f3 = 0.5f) && f2 >= f3 && this.adjacentChestZNeg == null && this.adjacentChestXNeg == null) {
                double d3 = (double)i + 0.5;
                double d0 = (double)k + 0.5;
                if (this.adjacentChestZPos != null) {
                    d0 += 0.5;
                }
                if (this.adjacentChestXPos != null) {
                    d3 += 0.5;
                }
                this.field_145850_b.func_184148_a((EntityPlayer)null, d3, (double)j + 0.5, d0, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v() && this.func_145838_q() instanceof BlockNetherChest) {
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
        this.checkForAdjacentChests();
    }

    public String func_174875_k() {
        return "minecraft:chest";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.func_184281_d(playerIn);
        return new ContainerChest((IInventory)playerInventory, (IInventory)this, playerIn);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.doubleChestHandler == null || this.doubleChestHandler.needsRefresh()) {
                this.doubleChestHandler = NetherDoubleChestItemHandler.get(this);
            }
            if (this.doubleChestHandler != null && this.doubleChestHandler != NetherDoubleChestItemHandler.NO_ADJACENT_CHESTS_INSTANCE) {
                return (T)this.doubleChestHandler;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public IItemHandler getSingleChestHandler() {
        return (IItemHandler)super.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.chestContents;
    }
}

