/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.nethercraft.world;

import com.legacy.nethercraft.blocks.BlocksNether;
import com.legacy.nethercraft.items.ItemsNether;
import com.legacy.nethercraft.world.NetherGenMinable;
import com.legacy.nethercraft.world.NetherGenReeds;
import com.legacy.nethercraft.world.NetherGenTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NetherWorldEvent {
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] depthBuffer = new double[256];
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    private Random rand = new Random();
    public WorldGenerator fouliteGen;
    public WorldGenerator neridiumGen;
    public WorldGenerator liniumGen;
    public WorldGenerator pyridiumGen;
    public WorldGenerator wGen;

    public NetherWorldEvent() {
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.fouliteGen = new NetherGenMinable(BlocksNether.foulite_ore.func_176223_P(), 14);
        this.neridiumGen = new NetherGenMinable(BlocksNether.neridium_ore.func_176223_P(), 14);
        this.liniumGen = new NetherGenMinable(BlocksNether.linium_ore.func_176223_P(), 4);
        this.pyridiumGen = new NetherGenMinable(BlocksNether.pyridium_ore.func_176223_P(), 6);
        this.wGen = new NetherGenMinable(BlocksNether.w_ore.func_176223_P(), 4);
    }

    @SubscribeEvent
    public void livingSpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPigZombie && this.rand.nextInt(3) == 0) {
            event.getEntity().func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemsNether.neridium_sword));
        }
    }

    @SubscribeEvent
    public void onGenerateLand(ChunkGeneratorEvent.ReplaceBiomeBlocks event) {
        if (event.getWorld() == null || event.getWorld() != null && event.getWorld().func_180494_b(new BlockPos(event.getX(), 0, event.getZ())) != Biomes.field_76778_j) {
            return;
        }
        double d0 = 0.03125;
        int i = event.getWorld().func_181545_F() + 1;
        this.slowsandNoise = this.slowsandGravelNoiseGen.func_76304_a(this.slowsandNoise, event.getX() * 16, event.getZ() * 16, 0, 16, 16, 1, d0, d0, 1.0);
        this.gravelNoise = this.slowsandGravelNoiseGen.func_76304_a(this.gravelNoise, event.getX() * 16, 109, event.getZ() * 16, 16, 1, 16, d0, 1.0, d0);
        this.depthBuffer = this.netherrackExculsivityNoiseGen.func_76304_a(this.depthBuffer, event.getX() * 16, event.getZ() * 16, 0, 16, 16, 1, d0 * 2.0, d0 * 2.0, d0 * 2.0);
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                boolean flag = this.slowsandNoise[j + k * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelNoise[j + k * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                IBlockState iblockstate = BlocksNether.nether_dirt.func_176223_P();
                IBlockState iblockstate1 = BlocksNether.nether_dirt.func_176223_P();
                int l = (int)(this.depthBuffer[j + k * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int i1 = -1;
                for (int j1 = 127; j1 >= 0; --j1) {
                    ChunkPrimer primer = event.getPrimer();
                    Block block = event.getPrimer().func_177856_a(k, j1, j).func_177230_c();
                    if (j1 >= 127 - this.rand.nextInt(5) || j1 <= this.rand.nextInt(5)) continue;
                    if (block == Blocks.field_150424_aL) {
                        if (i1 == -1) {
                            if (l <= 0) {
                                iblockstate = Blocks.field_150350_a.func_176223_P();
                                iblockstate1 = BlocksNether.nether_dirt.func_176223_P();
                            } else if (j1 >= i - 4 && j1 <= i + 1) {
                                iblockstate = BlocksNether.nether_dirt.func_176223_P();
                                iblockstate1 = BlocksNether.nether_dirt.func_176223_P();
                                if (flag1) {
                                    iblockstate = BlocksNether.heat_sand.func_176223_P();
                                    iblockstate1 = BlocksNether.nether_dirt.func_176223_P();
                                }
                                if (flag) {
                                    iblockstate = BlocksNether.heat_sand.func_176223_P();
                                    iblockstate1 = BlocksNether.heat_sand.func_176223_P();
                                }
                            }
                            i1 = l;
                            if (j1 >= i - 1) {
                                primer.func_177855_a(k, j1, j, iblockstate);
                                continue;
                            }
                            primer.func_177855_a(k, j1, j, iblockstate1);
                            continue;
                        }
                        if (i1 <= 0) continue;
                        --i1;
                        primer.func_177855_a(k, j1, j, iblockstate1);
                        continue;
                    }
                    i1 = -1;
                }
            }
        }
    }

    @SubscribeEvent
    public void onNetherDecorated(DecorateBiomeEvent.Pre event) {
        if (event.getWorld().field_73011_w.getDimension() == -1) {
            int k2;
            this.generateAllNetherOres(event.getWorld(), event.getPos(), event.getRand());
            for (k2 = 0; k2 < event.getRand().nextInt(5) + 35; ++k2) {
                new NetherGenTree().func_180709_b(event.getWorld(), event.getRand(), event.getPos().func_177982_a(event.getRand().nextInt(16), event.getRand().nextInt(120) + 4, event.getRand().nextInt(16)));
            }
            for (int l4 = 0; l4 < 7; ++l4) {
                if (event.getRand().nextInt(10) != 0) continue;
                new NetherGenReeds().func_180709_b(event.getWorld(), event.getRand(), event.getPos().func_177982_a(event.getRand().nextInt(16) + 8, 32, event.getRand().nextInt(16) + 8));
            }
            for (k2 = 0; k2 < 3; ++k2) {
                BlockPos blockpos2 = event.getPos().func_177982_a(event.getRand().nextInt(16) + 8, event.getRand().nextInt(120) + 4, event.getRand().nextInt(16) + 8);
                if (event.getRand().nextInt(4) == 0) {
                    new WorldGenBush((BlockBush)BlocksNether.purple_glowshroom).func_180709_b(event.getWorld(), event.getRand(), blockpos2);
                }
                if (event.getRand().nextInt(8) != 0) continue;
                new WorldGenBush((BlockBush)BlocksNether.green_glowshroom).func_180709_b(event.getWorld(), event.getRand(), blockpos2);
            }
        }
    }

    private void generateAllNetherOres(World world, BlockPos pos, Random random) {
        this.generateNetherOre(world, pos, random, 20, this.fouliteGen);
        this.generateNetherOre(world, pos, random, 8, this.neridiumGen);
        this.generateNetherOre(world, pos, random, 5, this.liniumGen);
        this.generateNetherOre(world, pos, random, 4, this.pyridiumGen);
        this.generateNetherOre(world, pos, random, 2, this.wGen);
    }

    private void generateNetherOre(World worldIn, BlockPos pos, Random random, int blockCount, WorldGenerator generator) {
        for (int j = 0; j < blockCount; ++j) {
            BlockPos blockpos = pos.func_177982_a(random.nextInt(16), random.nextInt(108) + 10, random.nextInt(16));
            generator.func_180709_b(worldIn, random, blockpos);
        }
    }
}

