/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.nethercraft.entity;

import com.legacy.nethercraft.Nethercraft;
import com.legacy.nethercraft.NethercraftRegistry;
import com.legacy.nethercraft.block.NetherBlocks;
import com.legacy.nethercraft.entity.BloodyZombieEntity;
import com.legacy.nethercraft.entity.CamouflageSpiderEntity;
import com.legacy.nethercraft.entity.DarkZombieEntity;
import com.legacy.nethercraft.entity.ImpEntity;
import com.legacy.nethercraft.entity.LavaSlimeEntity;
import com.legacy.nethercraft.entity.misc.GhastBombEntity;
import com.legacy.nethercraft.entity.misc.LavaBoatEntity;
import com.legacy.nethercraft.entity.misc.NetherPaintingEntity;
import com.legacy.nethercraft.entity.projectile.LiniumArrowEntity;
import com.legacy.nethercraft.entity.projectile.NeridiumArrowEntity;
import com.legacy.nethercraft.entity.projectile.NetherrackArrowEntity;
import com.legacy.nethercraft.entity.projectile.PyridiumArrowEntity;
import com.legacy.nethercraft.entity.projectile.SlimeEggEntity;
import com.legacy.nethercraft.entity.tribal.TribalArcherEntity;
import com.legacy.nethercraft.entity.tribal.TribalTraineeEntity;
import com.legacy.nethercraft.entity.tribal.TribalWarriorEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="nethercraft")
public class NetherEntityTypes {
    public static final EntityType<ImpEntity> IMP = NetherEntityTypes.buildEntity("imp", EntityType.Builder.func_220322_a(ImpEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220320_c().func_220321_a(1.0f, 1.8f));
    public static final EntityType<DarkZombieEntity> DARK_ZOMBIE = NetherEntityTypes.buildEntity("dark_zombie", EntityType.Builder.func_220322_a(DarkZombieEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f));
    public static final EntityType<BloodyZombieEntity> BLOODY_ZOMBIE = NetherEntityTypes.buildEntity("bloody_zombie", EntityType.Builder.func_220322_a(BloodyZombieEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f));
    public static final EntityType<LavaSlimeEntity> LAVA_SLIME = NetherEntityTypes.buildEntity("lava_slime", EntityType.Builder.func_220322_a(LavaSlimeEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220320_c().func_220321_a(2.04f, 2.04f));
    public static final EntityType<CamouflageSpiderEntity> CAMOUFLAGE_SPIDER = NetherEntityTypes.buildEntity("camouflage_spider", EntityType.Builder.func_220322_a(CamouflageSpiderEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220320_c().func_220321_a(1.4f, 0.9f));
    public static final EntityType<TribalWarriorEntity> TRIBAL_WARRIOR = NetherEntityTypes.buildEntity("tribal_warrior", EntityType.Builder.func_220322_a(TribalWarriorEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220320_c().func_220321_a(0.6f, 1.95f));
    public static final EntityType<TribalArcherEntity> TRIBAL_ARCHER = NetherEntityTypes.buildEntity("tribal_archer", EntityType.Builder.func_220322_a(TribalArcherEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220320_c().func_220321_a(0.6f, 1.95f));
    public static final EntityType<TribalTraineeEntity> TRIBAL_TRAINEE = NetherEntityTypes.buildEntity("tribal_trainee", EntityType.Builder.func_220322_a(TribalTraineeEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220320_c().func_220321_a(0.4f, 1.3f));
    public static final EntityType<NetherrackArrowEntity> NETHERRACK_ARROW = NetherEntityTypes.buildEntity("netherrack_arrow", EntityType.Builder.func_220322_a(NetherrackArrowEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(NetherrackArrowEntity::new).setShouldReceiveVelocityUpdates(true).func_220321_a(0.5f, 0.5f));
    public static final EntityType<NeridiumArrowEntity> NERIDIUM_ARROW = NetherEntityTypes.buildEntity("neridium_arrow", EntityType.Builder.func_220322_a(NeridiumArrowEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(NeridiumArrowEntity::new).setShouldReceiveVelocityUpdates(true).func_220321_a(0.5f, 0.5f));
    public static final EntityType<PyridiumArrowEntity> PYRIDIUM_ARROW = NetherEntityTypes.buildEntity("pyridium_arrow", EntityType.Builder.func_220322_a(PyridiumArrowEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(PyridiumArrowEntity::new).setShouldReceiveVelocityUpdates(true).func_220321_a(0.5f, 0.5f));
    public static final EntityType<LiniumArrowEntity> LINIUM_ARROW = NetherEntityTypes.buildEntity("linium_arrow", EntityType.Builder.func_220322_a(LiniumArrowEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(LiniumArrowEntity::new).setShouldReceiveVelocityUpdates(true).func_220321_a(0.5f, 0.5f));
    public static final EntityType<SlimeEggEntity> SLIME_EGGS = NetherEntityTypes.buildEntity("slime_eggs", EntityType.Builder.func_220322_a(SlimeEggEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(SlimeEggEntity::new).setShouldReceiveVelocityUpdates(true).func_220321_a(0.25f, 0.25f));
    public static final EntityType<GhastBombEntity> GHAST_BOMB = NetherEntityTypes.buildEntity("ghast_bomb", EntityType.Builder.func_220322_a(GhastBombEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(GhastBombEntity::new).setShouldReceiveVelocityUpdates(true).func_220320_c().func_220321_a(0.98f, 0.98f));
    public static final EntityType<NetherPaintingEntity> NETHER_PAINTING = NetherEntityTypes.buildEntity("nether_painting", EntityType.Builder.func_220322_a(NetherPaintingEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(NetherPaintingEntity::new).func_220320_c().func_220321_a(0.5f, 0.5f));
    public static final EntityType<LavaBoatEntity> LAVA_BOAT = NetherEntityTypes.buildEntity("lava_boat", EntityType.Builder.func_220322_a(LavaBoatEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(LavaBoatEntity::new).setShouldReceiveVelocityUpdates(true).func_220320_c().func_220321_a(1.375f, 0.5625f));

    public static void init(RegistryEvent.Register<EntityType<?>> event) {
        NethercraftRegistry.register(event.getRegistry(), "imp", IMP);
        NethercraftRegistry.register(event.getRegistry(), "dark_zombie", DARK_ZOMBIE);
        NethercraftRegistry.register(event.getRegistry(), "bloody_zombie", BLOODY_ZOMBIE);
        NethercraftRegistry.register(event.getRegistry(), "lava_slime", LAVA_SLIME);
        NethercraftRegistry.register(event.getRegistry(), "camouflage_spider", CAMOUFLAGE_SPIDER);
        NethercraftRegistry.register(event.getRegistry(), "tribal_warrior", TRIBAL_WARRIOR);
        NethercraftRegistry.register(event.getRegistry(), "tribal_archer", TRIBAL_ARCHER);
        NethercraftRegistry.register(event.getRegistry(), "tribal_trainee", TRIBAL_TRAINEE);
        NethercraftRegistry.register(event.getRegistry(), "netherrack_arrow", NETHERRACK_ARROW);
        NethercraftRegistry.register(event.getRegistry(), "neridium_arrow", NERIDIUM_ARROW);
        NethercraftRegistry.register(event.getRegistry(), "pyridium_arrow", PYRIDIUM_ARROW);
        NethercraftRegistry.register(event.getRegistry(), "linium_arrow", LINIUM_ARROW);
        NethercraftRegistry.register(event.getRegistry(), "slime_eggs", SLIME_EGGS);
        NethercraftRegistry.register(event.getRegistry(), "ghast_bomb", GHAST_BOMB);
        NethercraftRegistry.register(event.getRegistry(), "nether_painting", NETHER_PAINTING);
        NethercraftRegistry.register(event.getRegistry(), "lava_boat", LAVA_BOAT);
        NetherEntityTypes.registerSpawnConditions();
    }

    private static <T extends Entity> EntityType<T> buildEntity(String key, EntityType.Builder<T> builder) {
        return builder.func_206830_a(Nethercraft.find(key));
    }

    public static boolean canSpawn(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public static boolean canSpawnSand(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && world.func_180495_p(pos.func_177977_b()).func_177230_c() == NetherBlocks.heat_sand;
    }

    private static void registerSpawnConditions() {
        EntitySpawnPlacementRegistry.func_209343_a(IMP, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, NetherEntityTypes::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(DARK_ZOMBIE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, NetherEntityTypes::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(BLOODY_ZOMBIE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, NetherEntityTypes::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(LAVA_SLIME, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, NetherEntityTypes::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(CAMOUFLAGE_SPIDER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, NetherEntityTypes::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(TRIBAL_WARRIOR, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, NetherEntityTypes::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(TRIBAL_ARCHER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, NetherEntityTypes::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(TRIBAL_TRAINEE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, NetherEntityTypes::canSpawn);
    }
}

