/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.nethercraft.player;

import com.google.common.collect.ImmutableMap;
import com.legacy.nethercraft.block.NetherBlocks;
import com.legacy.nethercraft.entity.misc.LavaBoatEntity;
import com.legacy.nethercraft.item.NetherItems;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NetherPlayerEvents {
    public static final Map<Block, BlockState> HOE_LOOKUP = new ImmutableMap.Builder().put((Object)NetherBlocks.nether_dirt, (Object)NetherBlocks.nether_farmland.func_176223_P()).build();
    private int burnTime;

    @SubscribeEvent
    public void onPlayerRightClickAxe(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().func_77973_b() instanceof AxeItem) {
            BlockRayTraceResult rayTraceResult;
            BlockPos pos;
            PlayerEntity player = event.getPlayer();
            World world = event.getWorld();
            BlockState blockState = world.func_180495_p(pos = (rayTraceResult = (BlockRayTraceResult)NetherPlayerEvents.rayTrace(world, player)).func_216350_a());
            if (blockState.func_177230_c() == NetherBlocks.glowood_log) {
                player.func_130014_f_().func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184609_a(event.getHand());
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, (BlockState)NetherBlocks.stripped_glowood_log.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, blockState.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M)), 11);
                    if (player != null) {
                        event.getItemStack().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(event.getHand()));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickHoe(UseHoeEvent event) {
        BlockPos pos;
        PlayerEntity player = event.getPlayer();
        World world = event.getContext().func_195991_k();
        BlockState dirtState = world.func_180495_p(pos = event.getContext().func_195995_a());
        BlockState resultState = HOE_LOOKUP.get(dirtState.func_177230_c());
        if (resultState != null && event.getContext().func_196000_l() != Direction.DOWN && world.func_175623_d(pos.func_177984_a())) {
            if (world.field_73012_v.nextInt(10) == 0) {
                ItemEntity itementity = new ItemEntity(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((IItemProvider)NetherItems.dark_seeds));
                itementity.func_174869_p();
                world.func_217376_c((Entity)itementity);
            }
            player.func_130014_f_().func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            player.func_184609_a(event.getContext().func_221531_n());
            if (!world.field_72995_K) {
                world.func_180501_a(pos, resultState, 11);
                if (player != null) {
                    event.getContext().func_195996_i().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(event.getContext().func_221531_n()));
                }
            }
            event.setCanceled(true);
        }
    }

    protected static RayTraceResult rayTrace(World worldIn, PlayerEntity player) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vec3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)player));
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingAttackEvent event) {
        if (event.getEntityLiving().func_184187_bx() instanceof LavaBoatEntity && event.getSource().func_76347_k()) {
            event.getEntityLiving().func_70066_B();
            event.setCanceled(true);
            this.burnTime = 40;
        }
        if (this.burnTime > 0 && event.getSource().func_76347_k() && event.getEntityLiving().func_184187_bx() == null) {
            event.getEntityLiving().func_70066_B();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && this.burnTime > 0 && event.getEntityLiving().func_184187_bx() == null) {
            --this.burnTime;
        }
    }
}

