/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.nethercraft.entity.misc;

import com.legacy.nethercraft.block.NetherBlocks;
import com.legacy.nethercraft.entity.NetherEntityTypes;
import com.legacy.nethercraft.item.NetherItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class LavaBoatEntity
extends Entity {
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(LavaBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(LavaBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(LavaBoatEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> field_199704_e = EntityDataManager.func_187226_a(LavaBoatEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_199705_f = EntityDataManager.func_187226_a(LavaBoatEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ROCKING_TICKS = EntityDataManager.func_187226_a(LavaBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final float[] paddlePositions = new float[2];
    private float momentum;
    private float outOfControlTicks;
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private boolean leftInputDown;
    private boolean rightInputDown;
    private boolean forwardInputDown;
    private boolean backInputDown;
    private double lavaLevel;
    private float boatGlide;
    private Status status;
    private Status previousStatus;
    private double lastYd;
    private boolean rocking;
    private boolean field_203060_aN;
    private float rockingIntensity;
    private float rockingAngle;
    private float prevRockingAngle;
    private boolean removed = !this.func_70089_S();

    public LavaBoatEntity(EntityType<? extends LavaBoatEntity> p_i50129_1_, World p_i50129_2_) {
        super(p_i50129_1_, p_i50129_2_);
        this.field_70156_m = true;
    }

    public LavaBoatEntity(World worldIn, double x, double y, double z) {
        this(NetherEntityTypes.LAVA_BOAT, worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vec3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public LavaBoatEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(NetherEntityTypes.LAVA_BOAT, world);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(FORWARD_DIRECTION, (Object)1);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(field_199704_e, (Object)false);
        this.field_70180_af.func_187214_a(field_199705_f, (Object)false);
        this.field_70180_af.func_187214_a(ROCKING_TICKS, (Object)0);
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return -0.1;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.removed) {
            boolean flag;
            if (source instanceof IndirectEntityDamageSource && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199703_a((IItemProvider)this.getItemBoat());
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void func_203002_i(boolean downwards) {
        if (!this.field_70170_p.field_72995_K) {
            this.rocking = true;
            this.field_203060_aN = downwards;
            if (this.getRockingTicks() == 0) {
                this.setRockingTicks(60);
            }
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)this.field_70146_Z.nextFloat(), this.func_226278_cu_() + 0.7, this.func_226281_cx_() + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0);
        if (this.field_70146_Z.nextInt(20) == 0) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_184181_aa(), this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat(), false);
        }
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof LavaBoatEntity) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entityIn);
        }
    }

    public Item getItemBoat() {
        return NetherItems.lava_boat;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean func_70067_L() {
        return !this.removed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    public Direction func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    public void func_70071_h_() {
        this.previousStatus = this.status;
        this.status = this.getBoatStatus();
        this.outOfControlTicks = this.status != Status.UNDER_LAVA && this.status != Status.UNDER_FLOWING_LAVA ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.field_70170_p.field_72995_K && this.outOfControlTicks >= 60.0f) {
            this.func_184226_ay();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        super.func_70071_h_();
        this.tickLerp();
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().size() == 0 || !(this.func_184188_bt().get(0) instanceof PlayerEntity)) {
                this.setPaddleState(false, false);
            }
            this.updateMotion();
            if (this.func_184207_aI() && this.func_184188_bt().get(0) instanceof PlayerEntity) {
                PlayerEntity entity = (PlayerEntity)this.func_184188_bt().get(0);
                if (entity.field_70702_br != 0.0f || entity.field_191988_bg != 0.0f) {
                    this.controlBoat();
                }
                if (entity.field_191988_bg != 0.0f) {
                    this.updateInputs(false, false, entity.field_191988_bg > 0.01f, entity.field_191988_bg < 0.01f);
                }
                if (entity.field_70702_br != 0.0f) {
                    this.updateInputs(entity.field_70702_br > 0.01f, entity.field_70702_br < 0.01f, false, false);
                }
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            this.func_213317_d(Vec3d.field_186680_a);
        }
        this.updateRocking();
        for (int i = 0; i <= 1; ++i) {
            if (this.getPaddleState(i)) {
                SoundEvent soundevent;
                if (!this.func_174814_R() && (double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && ((double)this.paddlePositions[i] + (double)0.3926991f) % 6.2831854820251465 >= 0.7853981852531433 && (soundevent = this.getPaddleSound()) != null) {
                    Vec3d vec3d = this.func_70676_i(1.0f);
                    double d0 = i == 1 ? -vec3d.field_72449_c : vec3d.field_72449_c;
                    double d1 = i == 1 ? vec3d.field_72450_a : -vec3d.field_72450_a;
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_() + d0, this.func_226278_cu_(), this.func_226281_cx_() + d1, soundevent, this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
                }
                this.paddlePositions[i] = (float)((double)this.paddlePositions[i] + (double)0.3926991f);
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof PlayerEntity);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.func_184196_w((Entity)this)) continue;
                if (flag && this.func_184188_bt().size() < 2 && !entity.func_184218_aH() && entity.func_213311_cf() < this.func_213311_cf() && entity instanceof LivingEntity && !(entity instanceof WaterMobEntity) && !(entity instanceof PlayerEntity)) {
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
    }

    private void updateRocking() {
        if (this.field_70170_p.field_72995_K) {
            int i = this.getRockingTicks();
            this.rockingIntensity = i > 0 ? (this.rockingIntensity += 0.05f) : (this.rockingIntensity -= 0.1f);
            this.rockingIntensity = MathHelper.func_76131_a((float)this.rockingIntensity, (float)0.0f, (float)1.0f);
            this.prevRockingAngle = this.rockingAngle;
            this.rockingAngle = 10.0f * (float)Math.sin(0.5f * (float)this.field_70170_p.func_82737_E()) * this.rockingIntensity;
        } else {
            int k;
            if (!this.rocking) {
                this.setRockingTicks(0);
            }
            if ((k = this.getRockingTicks()) > 0) {
                this.setRockingTicks(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.setRockingTicks(0);
                    Vec3d vec3d = this.func_213322_ci();
                    if (this.field_203060_aN) {
                        this.func_213317_d(vec3d.func_72441_c(0.0, -0.7, 0.0));
                        this.func_184226_ay();
                    } else {
                        this.func_213293_j(vec3d.field_72450_a, this.func_205708_a(PlayerEntity.class) ? 2.7 : 0.6, vec3d.field_72449_c);
                    }
                }
                this.rocking = false;
            }
        }
    }

    @Nullable
    protected SoundEvent getPaddleSound() {
        switch (this.getBoatStatus()) {
            case IN_LAVA: 
            case UNDER_LAVA: 
            case UNDER_FLOWING_LAVA: {
                return SoundEvents.field_193779_I;
            }
            case ON_LAND: {
                return SoundEvents.field_193778_H;
            }
        }
        return null;
    }

    private void tickLerp() {
        if (this.func_184186_bw()) {
            this.lerpSteps = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.func_226277_ct_() + (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double d1 = this.func_226278_cu_() + (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double d2 = this.func_226281_cx_() + (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void setPaddleState(boolean left, boolean right) {
        this.field_70180_af.func_187227_b(field_199704_e, (Object)left);
        this.field_70180_af.func_187227_b(field_199705_f, (Object)right);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRowingTime(int side, float limbSwing) {
        return this.getPaddleState(side) ? (float)MathHelper.func_151238_b((double)((double)this.paddlePositions[side] - (double)0.3926991f), (double)this.paddlePositions[side], (double)limbSwing) : 0.0f;
    }

    private Status getBoatStatus() {
        Status LavaBoatEntity$status = this.getUnderLavaStatus();
        if (LavaBoatEntity$status != null) {
            this.lavaLevel = this.func_174813_aQ().field_72337_e;
            return LavaBoatEntity$status;
        }
        if (this.checkInLava()) {
            return Status.IN_LAVA;
        }
        float f = this.getBoatGlide();
        if (f > 0.0f) {
            this.boatGlide = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float getLavaLevelAbove() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.lastYd));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            float f1;
            block12: for (int k1 = k; k1 < l; ++k1) {
                float f2;
                float f = 0.0f;
                for (int l1 = i; l1 < j; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutable.func_181079_c(l1, k1, i2);
                        IFluidState ifluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$pooledmutable);
                        if (ifluidstate.func_206884_a(FluidTags.field_206960_b)) {
                            f = Math.max(f, ifluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$pooledmutable));
                        }
                        if (f >= 1.0f) continue block12;
                    }
                }
                if (!(f < 1.0f)) continue;
                float f3 = f2 = (float)blockpos$pooledmutable.func_177956_o() + f;
                return f3;
            }
            float f = f1 = (float)(l + 1);
            return f;
        }
    }

    public float getBoatGlide() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b - 0.001, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        int i = MathHelper.func_76128_c((double)axisalignedbb1.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)axisalignedbb1.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)axisalignedbb1.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)axisalignedbb1.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)axisalignedbb1.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)axisalignedbb1.field_72334_f) + 1;
        VoxelShape voxelshape = VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb1);
        float f = 0.0f;
        int k1 = 0;
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                    if (j2 == 2) continue;
                    for (int k2 = k; k2 < l; ++k2) {
                        if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                        blockpos$pooledmutable.func_181079_c(l1, k2, i2);
                        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutable);
                        if (blockstate.func_177230_c() instanceof LilyPadBlock || !VoxelShapes.func_197879_c((VoxelShape)blockstate.func_196952_d((IBlockReader)this.field_70170_p, (BlockPos)blockpos$pooledmutable).func_197751_a((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
                        f += blockstate.getSlipperiness((IWorldReader)this.field_70170_p, (BlockPos)blockpos$pooledmutable, (Entity)this);
                        ++k1;
                    }
                }
            }
        }
        return f / (float)k1;
    }

    private boolean checkInLava() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.lavaLevel = Double.MIN_VALUE;
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutable.func_181079_c(k1, l1, i2);
                        IFluidState ifluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$pooledmutable);
                        if (!ifluidstate.func_206884_a(FluidTags.field_206960_b)) continue;
                        float f = (float)l1 + ifluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$pooledmutable);
                        this.lavaLevel = Math.max((double)f, this.lavaLevel);
                        flag |= axisalignedbb.field_72338_b < (double)f;
                    }
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status getUnderLavaStatus() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutable.func_181079_c(k1, l1, i2);
                        IFluidState ifluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$pooledmutable);
                        if (!ifluidstate.func_206884_a(FluidTags.field_206960_b) || !(d0 < (double)((float)blockpos$pooledmutable.func_177956_o() + ifluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$pooledmutable)))) continue;
                        if (!ifluidstate.func_206889_d()) {
                            Status LavaBoatEntity$status;
                            Status status = LavaBoatEntity$status = Status.UNDER_FLOWING_LAVA;
                            return status;
                        }
                        flag = true;
                    }
                }
            }
        }
        return flag ? Status.UNDER_LAVA : null;
    }

    private void updateMotion() {
        double d0 = -0.04f;
        double d1 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.momentum = 0.05f;
        if (this.previousStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.lavaLevel = this.func_174813_aQ().field_72338_b + (double)this.func_213302_cg();
            this.func_70107_b(this.func_180425_c().func_177958_n(), (double)(this.getLavaLevelAbove() - this.func_213302_cg()) + 0.101, this.func_180425_c().func_177952_p());
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = Status.IN_LAVA;
        } else {
            if (this.status == Status.IN_LAVA) {
                d2 = (this.lavaLevel - this.func_174813_aQ().field_72338_b) / (double)this.func_213302_cg();
                this.momentum = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_LAVA) {
                d1 = -7.0E-4;
                this.momentum = 0.9f;
            } else if (this.status == Status.UNDER_LAVA) {
                d2 = 0.01f;
                this.momentum = 0.45f;
            } else if (this.status == Status.IN_AIR) {
                this.momentum = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                this.momentum = this.boatGlide;
                if (this.func_184179_bs() instanceof PlayerEntity) {
                    this.boatGlide /= 2.0f;
                }
            }
            Vec3d vec3d = this.func_213322_ci();
            this.func_213293_j(vec3d.field_72450_a * (double)this.momentum, vec3d.field_72448_b + d1, vec3d.field_72449_c * (double)this.momentum);
            this.deltaRotation *= this.momentum;
            if (d2 > 0.0) {
                Vec3d vec3d1 = this.func_213322_ci();
                this.func_213293_j(vec3d1.field_72450_a, d2 * (-d0 / 0.65), vec3d1.field_72449_c);
            }
        }
    }

    private void controlBoat() {
        if (this.func_184207_aI()) {
            float f = 0.005f;
            if (this.leftInputDown) {
                this.deltaRotation -= 1.0f;
            }
            if (this.rightInputDown) {
                this.deltaRotation += 1.0f;
            }
            if (this.rightInputDown != this.leftInputDown && !this.forwardInputDown && !this.backInputDown) {
                f += 0.005f;
            }
            this.field_70177_z += this.deltaRotation;
            if (this.forwardInputDown) {
                f += 0.04f;
            }
            if (this.backInputDown) {
                f -= 0.005f;
            }
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f)));
            this.setPaddleState(this.rightInputDown && !this.leftInputDown || this.forwardInputDown, this.leftInputDown && !this.rightInputDown || this.forwardInputDown);
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.removed ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof AnimalEntity) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vec3d.field_72450_a, this.func_226278_cu_() + (double)f1, this.func_226281_cx_() + vec3d.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.applyYawToEntity(passenger);
            if (passenger instanceof AnimalEntity && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((AnimalEntity)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_226563_dT_()) {
            return false;
        }
        return !this.field_70170_p.field_72995_K && this.outOfControlTicks < 60.0f ? player.func_184220_m((Entity)this) : false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.lastYd = this.func_213322_ci().field_72448_b;
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.status != Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_225503_b_(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.removed) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            for (int i = 0; i < 3; ++i) {
                                this.func_199703_a((IItemProvider)NetherBlocks.glowood_planks.func_199767_j());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.func_199703_a((IItemProvider)NetherItems.glowood_stick);
                            }
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (!this.field_70170_p.func_204610_c(new BlockPos((Entity)this).func_177977_b()).func_206884_a(FluidTags.field_206960_b) && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public boolean getPaddleState(int side) {
        return (Boolean)this.field_70180_af.func_187225_a(side == 0 ? field_199704_e : field_199705_f) != false && this.func_184179_bs() != null;
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    private void setRockingTicks(int p_203055_1_) {
        this.field_70180_af.func_187227_b(ROCKING_TICKS, (Object)p_203055_1_);
    }

    private int getRockingTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ROCKING_TICKS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRockingAngle(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevRockingAngle, (float)this.rockingAngle);
    }

    public void setForwardDirection(int forwardDirection) {
        this.field_70180_af.func_187227_b(FORWARD_DIRECTION, (Object)forwardDirection);
    }

    public int getForwardDirection() {
        return (Integer)this.field_70180_af.func_187225_a(FORWARD_DIRECTION);
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2 && !this.func_208600_a(FluidTags.field_206960_b);
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateInputs(boolean p_184442_1_, boolean p_184442_2_, boolean p_184442_3_, boolean p_184442_4_) {
        this.leftInputDown = p_184442_1_;
        this.rightInputDown = p_184442_2_;
        this.forwardInputDown = p_184442_3_;
        this.backInputDown = p_184442_4_;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.func_70080_a(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYaw, (float)this.lerpPitch);
        }
    }

    public ItemEntity func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.field_70170_p, (double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o() + (double)offsetY, (double)this.func_180425_c().func_177952_p(), stack);
        itementity.func_184224_h(true);
        itementity.func_213293_j(0.0, (double)0.3f, 0.0);
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.field_70170_p.func_217376_c((Entity)itementity);
        }
        return itementity;
    }

    public static enum Status {
        IN_LAVA,
        UNDER_LAVA,
        UNDER_FLOWING_LAVA,
        ON_LAND,
        IN_AIR;

    }
}

