/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.nethercraft.world;

import com.legacy.nethercraft.block.NetherBlocks;
import com.legacy.nethercraft.entity.DarkZombieEntity;
import com.legacy.nethercraft.entity.NetherEntityTypes;
import com.legacy.nethercraft.entity.goal.PigmanRangedBowAttackGoal;
import com.legacy.nethercraft.entity.tribal.TribalEntity;
import com.legacy.nethercraft.item.NetherItems;
import com.legacy.nethercraft.world.NetherDirtSurfaceBuilder;
import com.legacy.nethercraft.world.feature.GlowoodTreeFeature;
import com.legacy.nethercraft.world.feature.LavaReedFeature;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class NetherEvents {
    public static final TreeFeatureConfig GLOWOOD_CONFIG = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(NetherBlocks.glowood_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(NetherBlocks.glowood_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(2, 0)).func_225569_d_(5).func_227354_b_(2).func_227360_i_(3).func_227352_a_().setSapling((IPlantable)NetherBlocks.glowood_sapling).func_225568_b_();
    public static final BlockClusterFeatureConfig PURPLE_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(NetherBlocks.purple_glowshroom.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig GREEN_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(NetherBlocks.green_glowshroom.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    private Random rand = new Random();
    public static HashMap<String, Boolean> uuidMeleeRemoved = new HashMap();
    public static HashMap<String, Boolean> uuidJankFixed = new HashMap();

    public static void setupNetherFeatures(FMLCommonSetupEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, NetherBlocks.foulite_ore.func_176223_P(), 14)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 10, 20, 128))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, NetherBlocks.neridium_ore.func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 10, 20, 128))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, NetherBlocks.pyridium_ore.func_176223_P(), 5)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 10, 20, 128))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, NetherBlocks.linium_ore.func_176223_P(), 3)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(5, 10, 20, 128))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, NetherBlocks.w_ore.func_176223_P(), 4)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 10, 20, 128))));
            biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry(NetherEntityTypes.IMP, 30, 2, 3));
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(NetherEntityTypes.DARK_ZOMBIE, 50, 0, 2));
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(NetherEntityTypes.BLOODY_ZOMBIE, 50, 0, 2));
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(NetherEntityTypes.CAMOUFLAGE_SPIDER, 60, 1, 3));
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(NetherEntityTypes.LAVA_SLIME, 40, 1, 2));
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(NetherEntityTypes.TRIBAL_WARRIOR, 50, 0, 3));
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(NetherEntityTypes.TRIBAL_ARCHER, 50, 1, 2));
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(NetherEntityTypes.TRIBAL_TRAINEE, 50, 1, 3));
            if (biome != Biomes.field_76778_j) continue;
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, new GlowoodTreeFeature(TreeFeatureConfig::func_227338_a_, true).func_225566_b_((IFeatureConfig)GLOWOOD_CONFIG).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(40, 30, 0, 50))));
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, new LavaReedFeature(NoFeatureConfig::func_214639_a).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(20))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)PURPLE_MUSHROOM_CONFIG).func_227228_a_(Placement.field_215032_r.func_227446_a_((IPlacementConfig)new ChanceRangeConfig(0.5f, 0, 0, 128))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)GREEN_MUSHROOM_CONFIG).func_227228_a_(Placement.field_215032_r.func_227446_a_((IPlacementConfig)new ChanceRangeConfig(0.5f, 0, 0, 128))));
            NetherEvents.setNetherBuilder(biome, new ConfiguredSurfaceBuilder((SurfaceBuilder)new NetherDirtSurfaceBuilder(SurfaceBuilderConfig::func_215455_a), (ISurfaceBuilderConfig)SurfaceBuilder.field_215394_E));
        }
    }

    @SubscribeEvent
    public void livingSpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ZombiePigmanEntity) {
            ZombiePigmanEntity pigman = (ZombiePigmanEntity)event.getEntity();
            if (this.rand.nextInt(5) == 0 && !((ZombiePigmanEntity)event.getEntity()).func_70631_g_()) {
                event.getEntity().func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)NetherItems.pyridium_bow));
                pigman.field_70714_bg.func_75776_a(1, new PigmanRangedBowAttackGoal<ZombiePigmanEntity>(pigman, 1.0, 20, 15.0f));
                pigman.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
                pigman.func_70606_j(30.0f);
            }
            this.removePigmanAnger(pigman);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof ZombiePigmanEntity) {
            ZombiePigmanEntity pigman = (ZombiePigmanEntity)event.getEntityLiving();
            if (pigman.func_184614_ca().func_77973_b() instanceof BowItem && !pigman.func_70631_g_() && uuidMeleeRemoved.containsKey(pigman.func_110124_au().toString())) {
                if (uuidMeleeRemoved.get(pigman.func_110124_au().toString()).booleanValue()) {
                    return;
                }
                pigman.field_70714_bg.func_85156_a((Goal)new ZombieAttackGoal((ZombieEntity)pigman, 1.0, false));
                uuidMeleeRemoved.put(pigman.func_110124_au().toString(), true);
            } else {
                uuidMeleeRemoved.put(pigman.func_110124_au().toString(), false);
            }
            if (uuidJankFixed.containsKey(pigman.func_110124_au().toString())) {
                if (uuidJankFixed.get(pigman.func_110124_au().toString()).booleanValue()) {
                    return;
                }
                this.removePigmanAnger(pigman);
                uuidJankFixed.put(pigman.func_110124_au().toString(), true);
            } else {
                uuidJankFixed.put(pigman.func_110124_au().toString(), false);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof GhastEntity && event.getEntityLiving().field_70170_p.field_73012_v.nextInt(3) == 0 && event.getEntityLiving().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            ItemStack bones = new ItemStack((IItemProvider)NetherItems.ghast_bones);
            bones.func_190920_e(event.getEntityLiving().field_70170_p.field_73012_v.nextInt(2) + 1);
            event.getEntityLiving().func_199701_a_(bones);
        }
    }

    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof ZombiePigmanEntity && event.getSource() instanceof IndirectEntityDamageSource && event.getSource().func_76346_g() instanceof ZombiePigmanEntity) {
            event.getSource().func_76364_f().func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onZombieSummoned(ZombieEvent.SummonAidEvent event) {
        if (event.getEntity().field_71093_bK == DimensionType.field_223228_b_) {
            ZombieEntity summoningZombie = (ZombieEntity)event.getEntity();
            IAttribute SPAWN_REINFORCEMENTS_CHANCE = (IAttribute)ObfuscationReflectionHelper.getPrivateValue(ZombieEntity.class, (Object)summoningZombie, (String)"field_110186_bp");
            boolean canSpawn = summoningZombie != null && summoningZombie.field_70170_p.func_175659_aa() == Difficulty.HARD && (double)summoningZombie.field_70170_p.field_73012_v.nextFloat() < summoningZombie.func_110148_a(SPAWN_REINFORCEMENTS_CHANCE).func_111126_e() && summoningZombie.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223601_d);
            DarkZombieEntity reinforcements = (DarkZombieEntity)NetherEntityTypes.DARK_ZOMBIE.func_200721_a(event.getWorld());
            event.setCustomSummonedAid((ZombieEntity)reinforcements);
            if (canSpawn) {
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    private void removePigmanAnger(ZombiePigmanEntity pigman) {
        try {
            pigman.field_70715_bh.field_220892_d.clear();
            for (PrioritizedGoal goalSet : pigman.field_70715_bh.field_220892_d) {
                if (goalSet == null || goalSet.func_220772_j() == null) continue;
                System.out.println(goalSet.func_220772_j());
            }
            pigman.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)pigman, new Class[0]).func_220794_a(new Class[]{ZombieEntity.class}));
            pigman.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)pigman, TribalEntity.class, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setNetherBuilder(Biome biome, ConfiguredSurfaceBuilder<?> builder) {
        try {
            ObfuscationReflectionHelper.setPrivateValue(Biome.class, (Object)biome, builder, (String)"field_201875_ar");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

