/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread.util;

import com.natamus.collective.functions.BlockFunctions;
import com.natamus.collective.functions.StringFunctions;
import com.natamus.collective.objects.RandomCollection;
import com.natamus.netherportalspread.config.ConfigHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.registries.ForgeRegistries;

public class Util {
    public static World world = null;
    public static List<BlockPos> portals = new ArrayList<BlockPos>();
    private static HashMap<BlockPos, Boolean> preventedportals = new HashMap();
    private static HashMap<Block, HashMap<Block, Double>> convertinto = new HashMap();
    private static List<Block> convertblocks = new ArrayList<Block>();
    private static List<Block> convertedblocks = new ArrayList<Block>();
    private static Block preventSpreadBlock = null;

    public static void loadSpreadBlocks() throws IOException {
        String dirpath = System.getProperty("user.dir") + File.separator + "config" + File.separator + "netherportalspread";
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "spreadsettings.txt");
        if (dir.isDirectory() && file.isFile()) {
            String spreadsettings = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "spreadsettings.txt", new String[0])));
            spreadsettings = spreadsettings.replace("\n", "").replace("\r", "").replace(" ", "");
            for (String line : spreadsettings.split(",")) {
                ResourceLocation frl;
                if (line.length() < 4) {
                    System.out.println("The Nether Portal Spread spread settings contains an empty line. Ignoring it.");
                    continue;
                }
                String[] linespl = line.split(";");
                if (linespl.length != 2) {
                    System.out.println("[Nether Portal Spread] The spread settings line '" + line + "' contains errors. Ignoring it.");
                    continue;
                }
                String fromblockstr = linespl[0];
                if (!fromblockstr.contains(":")) {
                    fromblockstr = "minecraft:" + fromblockstr;
                }
                if (!ForgeRegistries.BLOCKS.containsKey(frl = new ResourceLocation(fromblockstr))) {
                    System.out.println("[Nether Portal Spread] Unable to find from-block '" + fromblockstr + "' in the Forge block registry. Ignoring it.");
                    continue;
                }
                Block fromblock = (Block)ForgeRegistries.BLOCKS.getValue(frl);
                String toblocks = linespl[1].replace("[", "").replace("]", "");
                double totalweight = 0.0;
                HashMap<Object, Double> tempmap = new HashMap<Object, Double>();
                for (String tb : toblocks.split("\\+")) {
                    String[] tbspl = tb.split(">");
                    String toblockstr = tbspl[0];
                    if (!toblockstr.contains(":")) {
                        toblockstr = "minecraft:" + toblockstr;
                    }
                    Double weight = 1.0;
                    try {
                        weight = Double.parseDouble(tbspl[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    totalweight += weight.doubleValue();
                    ResourceLocation trl = new ResourceLocation(toblockstr);
                    if (ForgeRegistries.BLOCKS.containsKey(trl)) {
                        tempmap.put(ForgeRegistries.BLOCKS.getValue(trl), weight);
                        continue;
                    }
                    System.out.println("[Nether Portal Spread] Unable to find to-block '" + toblockstr + "' in the Forge block registry. Ignoring it.");
                }
                if (tempmap.size() == 0 || totalweight == 0.0) {
                    System.out.println("[Nether Portal Spread] The spread settings line '" + line + "' contains errors, no convert blocks were found. Ignoring it.");
                    continue;
                }
                for (Block key : tempmap.keySet()) {
                    Double weightvalue = (Double)tempmap.get(key);
                    tempmap.put(key, 1.0 / totalweight * weightvalue);
                }
                convertinto.put(fromblock, tempmap);
            }
            for (Block b0 : convertinto.keySet()) {
                convertblocks.add(b0);
                for (Block b1 : convertinto.get(b0).keySet()) {
                    convertedblocks.add(b1);
                }
            }
        } else {
            dir.mkdirs();
            PrintWriter writer = new PrintWriter(dirpath + File.separator + "spreadsettings.txt", "UTF-8");
            writer.println("stone; [netherrack>10 + magma_block>2 + nether_quartz_ore>1],");
            writer.println("grass_block; [netherrack>1],");
            writer.println("dirt; [netherrack>1],");
            writer.println("sand; [soul_sand>1],");
            writer.println("gravel; [soul_sand>1],");
            writer.println("stone_bricks; [nether_bricks>2 + red_nether_bricks>1],");
            writer.println("sea_lantern; [glowstone>1],");
            writer.println("farmland; [soul_sand>1],");
            writer.println("wheat; [nether_wart>1],");
            writer.close();
            Util.loadSpreadBlocks();
        }
        if (preventSpreadBlock == null) {
            String psbstr = (String)ConfigHandler.GENERAL.preventSpreadBlockString.get();
            ResourceLocation psbrl = new ResourceLocation(psbstr);
            if (ForgeRegistries.BLOCKS.containsKey(psbrl)) {
                preventSpreadBlock = (Block)ForgeRegistries.BLOCKS.getValue(psbrl);
            } else {
                System.out.println("[Nether Portal Spread] Unable to get a prevent-spread-block from the string '" + psbstr + "'. Using the default coal block instead.");
                preventSpreadBlock = Blocks.field_150402_ci;
            }
        }
    }

    public static Boolean portalExists(BlockPos pos) {
        for (BlockPos portalpos : portals) {
            Double distance = pos.func_218140_a((double)portalpos.func_177958_n(), (double)portalpos.func_177956_o(), (double)portalpos.func_177952_p(), true);
            if (!(distance < 10.0)) continue;
            return true;
        }
        return false;
    }

    public static void addPortal(BlockPos pos) {
        portals.add(pos);
    }

    public static void initSpread(final BlockPos portal, int delayms, final int loopcount, final Boolean resetafter) {
        if (delayms < 0) {
            delayms = (Integer)ConfigHandler.GENERAL.spreadDelay.get();
        }
        final int delay = delayms;
        if (loopcount > 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (Util.spreadNextBlock(portal).booleanValue()) {
                        Util.initSpread(portal, delay, loopcount - 1, resetafter);
                    } else {
                        portals.remove(portal);
                    }
                }
            }).start();
        } else if (resetafter.booleanValue()) {
            Util.initSpread(portal, (Integer)ConfigHandler.GENERAL.spreadDelay.get(), 10000000, false);
        }
    }

    public static Boolean spreadNextBlock(BlockPos p) {
        if (world == null || p == null) {
            return false;
        }
        BlockState pbs = world.func_180495_p(p);
        if (pbs == null) {
            return false;
        }
        if (!world.func_180495_p(p).func_177230_c().equals(Blocks.field_150427_aO)) {
            if (preventedportals.containsKey(p)) {
                preventedportals.remove(p);
            }
            return false;
        }
        int r = (Integer)ConfigHandler.GENERAL.portalSpreadRadius.get();
        BlockPos closest = null;
        double nearestdistance = 100000.0;
        int coalcount = 0;
        Integer psamount = (Integer)ConfigHandler.GENERAL.preventSpreadBlockAmountNeeded.get();
        Iterator it = BlockPos.func_218287_a((int)(p.func_177958_n() - r), (int)(p.func_177956_o() - r), (int)(p.func_177952_p() - r), (int)(p.func_177958_n() + r), (int)(p.func_177956_o() + r), (int)(p.func_177952_p() + r)).iterator();
        while (it.hasNext()) {
            try {
                BlockPos np = (BlockPos)it.next();
                if (((Boolean)ConfigHandler.GENERAL.preventSpreadWithBlock.get()).booleanValue() && world.func_180495_p(np).func_177230_c().equals(preventSpreadBlock) && ++coalcount >= psamount) break;
                double npnd = p.func_218140_a((double)np.func_177958_n(), (double)np.func_177956_o(), (double)np.func_177952_p(), true);
                if (!(npnd < nearestdistance) || !Util.isNetherTarget(np, false).booleanValue()) continue;
                nearestdistance = npnd;
                closest = np.func_185334_h();
            }
            catch (NullPointerException ex) {}
        }
        if (((Boolean)ConfigHandler.GENERAL.preventSpreadWithBlock.get()).booleanValue() && coalcount >= psamount) {
            boolean prevented = true;
            if (preventedportals.containsKey(p)) {
                prevented = preventedportals.get(p);
            }
            if (!prevented) {
                Util.sendPreventedMessage(p);
            }
            preventedportals.put(p, true);
            return true;
        }
        if (closest != null) {
            boolean prevented = false;
            if (preventedportals.containsKey(p)) {
                prevented = preventedportals.get(p);
            } else {
                Util.sendSpreadingMessage(p);
            }
            if (prevented) {
                Util.sendSpreadingMessage(p);
            }
            preventedportals.put(p, false);
            Util.spreadNetherToBlock(closest);
            return true;
        }
        return false;
    }

    public static int countNetherBlocks(BlockPos p) {
        int nethercount = 0;
        int r = (Integer)ConfigHandler.GENERAL.portalSpreadRadius.get();
        Iterator it = BlockPos.func_218287_a((int)(p.func_177958_n() - r), (int)(p.func_177956_o() - r), (int)(p.func_177952_p() - r), (int)(p.func_177958_n() + r), (int)(p.func_177956_o() + r), (int)(p.func_177952_p() + r)).iterator();
        while (it.hasNext()) {
            BlockPos np = (BlockPos)it.next();
            if (!Util.isNetherTarget(np, true).booleanValue()) continue;
            ++nethercount;
        }
        return nethercount;
    }

    public static Boolean isNetherTarget(BlockPos pos, Boolean count) {
        if (world == null) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (count.booleanValue()) {
            if (convertedblocks.contains(block)) {
                return true;
            }
            return false;
        }
        if (convertblocks.contains(block)) {
            return true;
        }
        return false;
    }

    public static void spreadNetherToBlock(BlockPos pos) {
        if (world == null) {
            return;
        }
        BlockState newblockstate = null;
        BlockState curstate = world.func_180495_p(pos);
        Block curblock = curstate.func_177230_c();
        if (convertblocks.contains(curblock)) {
            RandomCollection rc = new RandomCollection();
            HashMap<Block, Double> hashmap = convertinto.get(curblock);
            for (Block b0 : hashmap.keySet()) {
                Double weight = hashmap.get(b0);
                rc.add(weight * 100.0, (Object)b0);
            }
            newblockstate = ((Block)rc.next()).func_176223_P();
        }
        if (newblockstate != null) {
            world.func_175656_a(pos, newblockstate);
        }
    }

    public static void checkChunkForPortals(Chunk chunk, Boolean fromclick) {
        int a = chunk.func_76632_l().field_77276_a * 16;
        int b = chunk.func_76632_l().field_77275_b * 16;
        for (double x = 0.0; x <= 15.0; x += 1.0) {
            for (double y = 0.0; y <= 256.0; y += 1.0) {
                for (double z = 0.0; z <= 15.0; z += 1.0) {
                    int nethercount;
                    BlockPos actualPosition = new BlockPos((double)a + x, y, (double)b + z).func_185334_h();
                    BlockState state = chunk.func_180495_p(actualPosition);
                    Block block = state.func_177230_c();
                    if (!block.equals(Blocks.field_150427_aO) || Util.portalExists(actualPosition).booleanValue()) continue;
                    Util.addPortal(actualPosition);
                    if (fromclick.booleanValue() && (nethercount = Util.countNetherBlocks(actualPosition)) < (Integer)ConfigHandler.GENERAL.instantConvertAmount.get()) {
                        Util.initSpread(actualPosition, 20, (Integer)ConfigHandler.GENERAL.instantConvertAmount.get() - nethercount, true);
                        continue;
                    }
                    Util.initSpread(actualPosition, (Integer)ConfigHandler.GENERAL.spreadDelay.get(), 10000000, false);
                }
            }
        }
    }

    private static void sendSpreadingMessage(BlockPos p) {
        if (!((Boolean)ConfigHandler.GENERAL.sendMessageOnPortalCreation.get()).booleanValue()) {
            return;
        }
        String message = (String)ConfigHandler.GENERAL.messageOnPortalCreation.get();
        StringFunctions.sendMessageToPlayersAround((World)world, (BlockPos)p, (int)((Integer)ConfigHandler.GENERAL.portalSpreadRadius.get()), (String)Util.formatAroundString(message, (Integer)ConfigHandler.GENERAL.preventSpreadBlockAmountNeeded.get()), (TextFormatting)TextFormatting.RED);
    }

    private static void sendPreventedMessage(BlockPos p) {
        if (!((Boolean)ConfigHandler.GENERAL.sendMessageOnPreventSpreadBlocksFound.get()).booleanValue()) {
            return;
        }
        String message = (String)ConfigHandler.GENERAL.messageOnPreventSpreadBlocksFound.get();
        StringFunctions.sendMessageToPlayersAround((World)world, (BlockPos)p, (int)((Integer)ConfigHandler.GENERAL.portalSpreadRadius.get()), (String)Util.formatAroundString(message, 1), (TextFormatting)TextFormatting.DARK_GREEN);
    }

    private static String formatAroundString(String message, int amountneeded) {
        if (preventSpreadBlock == null) {
            preventSpreadBlock = Blocks.field_150402_ci;
        }
        String blockstring = BlockFunctions.blockToReadableString((Block)preventSpreadBlock, (int)amountneeded);
        message = message.replace("%preventSpreadBlockString%", blockstring);
        message = message.replace("%preventSpreadBlockAmountNeeded%", amountneeded + "");
        message = message.replace("%portalSpreadRadius%", ConfigHandler.GENERAL.portalSpreadRadius.get() + "");
        return message;
    }
}

