/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHandler {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Boolean> sendMessageOnPortalCreation;
        public final ForgeConfigSpec.ConfigValue<String> messageOnPortalCreation;
        public final ForgeConfigSpec.ConfigValue<Boolean> sendMessageOnPreventSpreadBlocksFound;
        public final ForgeConfigSpec.ConfigValue<String> messageOnPreventSpreadBlocksFound;
        public final ForgeConfigSpec.ConfigValue<Integer> portalSpreadRadius;
        public final ForgeConfigSpec.ConfigValue<Integer> spreadDelay;
        public final ForgeConfigSpec.ConfigValue<Integer> instantConvertAmount;
        public final ForgeConfigSpec.ConfigValue<Boolean> preventSpreadWithBlock;
        public final ForgeConfigSpec.ConfigValue<Integer> preventSpreadBlockAmountNeeded;
        public final ForgeConfigSpec.ConfigValue<String> preventSpreadBlockString;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.sendMessageOnPortalCreation = builder.comment("When enabled, sends a message to players around the portal that the nether is spreading and that you can stop the spread with 'preventSpreadBlockAmountNeeded' of the 'preventSpreadBlockString' block.").define("sendMessageOnPortalCreation", true);
            this.messageOnPortalCreation = builder.comment("The message send on portal creation.").define("messageOnPortalCreation", (Object)"You feel a corrupt energy coming from the portal. The nether will slowly spread into the overworld unless %preventSpreadBlockAmountNeeded% %preventSpreadBlockString% are placed within a %portalSpreadRadius% block radius around the portal.");
            this.sendMessageOnPreventSpreadBlocksFound = builder.comment("When enabled, sends a message to players around the portal that the nether spread has stopped when the portal detects new 'preventSpreadBlockString' blocks.").define("sendMessageOnPreventSpreadBlocksFound", true);
            this.messageOnPreventSpreadBlocksFound = builder.comment("The message send on preventspread blocks found.").define("messageOnPreventSpreadBlocksFound", (Object)"While placing the last %preventSpreadBlockString%, you feel the corrupted energy fade.");
            this.portalSpreadRadius = builder.comment("The radius around the portal to which the nether blocks can spread.").defineInRange("portalSpreadRadius", 30, 1, 100);
            this.spreadDelay = builder.comment("The delay in ms in between the spread around the nether portal.").defineInRange("spreadDelay", 2500, 20, 360000);
            this.instantConvertAmount = builder.comment("The amount of blocks that are instantly converted to a nether block around a portal when it is detected. If there are existing nether blocks within the radius, their count is substracted from this number.").defineInRange("instantConvertAmount", 50, 0, 1000);
            this.preventSpreadWithBlock = builder.comment("When enabled, blocks the spread effect when there are n (defined) prevent-spread-blocks (defined) within the radius.").define("preventSpreadWithBlock", true);
            this.preventSpreadBlockAmountNeeded = builder.comment("The amount of prevent-spread-blocks (defined) needed within the radius of the nether portal to prevent spread.").define("preventSpreadBlockAmountNeeded", (Object)2);
            this.preventSpreadBlockString = builder.comment("The block which prevents the nether portal from spreading. By default a coal block (minecraft:coal_block is the namespace ID).").define("preventSpreadBlockString", (Object)"minecraft:coal_block");
            builder.pop();
        }
    }
}

