/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.neverbreak;

import cjminecraft.neverbreak.NeverBreakEnchantment;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="neverbreak")
public class Events {
    public static final NeverBreakEnchantment NEVER_BREAK = new NeverBreakEnchantment();

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().register((IForgeRegistryEntry)NEVER_BREAK);
    }

    public static boolean hasNeverBreakEnchantment(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NEVER_BREAK, (ItemStack)stack) > 0;
    }

    @SubscribeEvent
    public static void onItemDestroy(PlayerDestroyItemEvent event) {
        if (event.getOriginal() == null) {
            return;
        }
        if (!event.getEntityPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getOriginal())) {
            ItemStack stack = event.getOriginal();
            stack.func_77964_b(stack.func_77958_k());
            if (event.getHand() != null) {
                event.getEntityPlayer().func_184611_a(event.getHand(), stack);
            } else {
                event.setCanceled(true);
                if (event.getEntityPlayer().func_184614_ca() == ItemStack.field_190927_a) {
                    event.getEntityPlayer().func_184611_a(EnumHand.MAIN_HAND, stack);
                } else {
                    event.getEntityPlayer().func_184611_a(EnumHand.OFF_HAND, stack);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHoeUse(UseHoeEvent event) {
        if (!event.getEntityPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getEntityPlayer().func_184614_ca()) && event.getEntityPlayer().func_184614_ca().func_77952_i() >= event.getEntityPlayer().func_184614_ca().func_77958_k() - 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        if (!event.getEntityPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getEntityPlayer().func_184614_ca()) && event.getEntityPlayer().func_184614_ca().func_77952_i() >= event.getEntityPlayer().func_184614_ca().func_77958_k() - 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!event.getEntityPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getEntityPlayer().func_184614_ca()) && event.getEntityPlayer().func_184614_ca().func_77952_i() >= event.getEntityPlayer().func_184614_ca().func_77958_k() - 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getPlayer().func_184614_ca()) && event.getPlayer().func_184614_ca().func_77952_i() >= event.getPlayer().func_184614_ca().func_77958_k() - 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemFished(ItemFishedEvent event) {
        if (!event.getEntityPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getEntityPlayer().func_184614_ca()) && event.getEntityPlayer().func_184614_ca().func_77952_i() >= event.getEntityPlayer().func_184614_ca().func_77958_k() - 2) {
            event.damageRodBy(0);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onArrowLoose(ArrowLooseEvent event) {
        if (!event.getEntityPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getBow()) && event.getBow().func_77952_i() >= event.getBow().func_77958_k() - 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.getEntityPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getItemStack()) && event.getItemStack().func_77952_i() >= event.getItemStack().func_77958_k() - 1 && !(event.getItemStack().func_77973_b() instanceof ItemArmor)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && ((EntityPlayer)event.getEntityLiving()).func_184812_l_()) {
            return;
        }
        AtomicBoolean hasNeverBreakEnchant = new AtomicBoolean(false);
        event.getEntityLiving().func_184209_aF().forEach(stack -> {
            if (Events.hasNeverBreakEnchantment(stack)) {
                hasNeverBreakEnchant.set(true);
            }
        });
        if (hasNeverBreakEnchant.get()) {
            event.setCanceled(true);
            EntityLivingBase entity = event.getEntityLiving();
            DamageSource source = event.getSource();
            float damageAmount = event.getAmount();
            ArrayList<ItemStack> armourList = new ArrayList<ItemStack>();
            if (!source.func_76363_c()) {
                float totalArmourValue = 0.0f;
                float totalArmourToughness = 0.0f;
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (damageAmount > 0.0f) {
                        float damage = damageAmount / 4.0f;
                        if (damage < 1.0f) {
                            damage = 1.0f;
                        }
                        InventoryPlayer inventory = player.field_71071_by;
                        for (int i = 0; i < inventory.field_70460_b.size(); ++i) {
                            ItemStack stack2 = (ItemStack)inventory.field_70460_b.get(i);
                            if (!(stack2.func_77973_b() instanceof ItemArmor) || Events.hasNeverBreakEnchantment(stack2) && !((float)stack2.func_77952_i() < (float)stack2.func_77958_k() - damage)) continue;
                            stack2.func_77972_a((int)damage, (EntityLivingBase)player);
                            ItemArmor.ArmorMaterial armourMaterial = ((ItemArmor)stack2.func_77973_b()).func_82812_d();
                            totalArmourValue += (float)armourMaterial.func_78044_b(EntityEquipmentSlot.values()[i + 2]);
                            totalArmourToughness += armourMaterial.func_189416_e();
                            armourList.add(stack2);
                        }
                    }
                }
                damageAmount = CombatRules.func_189427_a((float)damageAmount, (float)totalArmourValue, (float)totalArmourToughness);
            }
            if (!source.func_151517_h()) {
                float damage = damageAmount;
                if (entity.func_70644_a(MobEffects.field_76429_m) && source != DamageSource.field_76380_i) {
                    int i = (entity.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
                    int j = 25 - i;
                    float f1 = damage * (float)j;
                    damage = f1 / 25.0f;
                }
                if (damage <= 0.0f) {
                    damageAmount = 0.0f;
                } else {
                    int k = EnchantmentHelper.func_77508_a(armourList, (DamageSource)source);
                    if (k > 0) {
                        damage = CombatRules.func_188401_b((float)damage, (float)k);
                    }
                    damageAmount = damage;
                }
            }
            float f = damageAmount;
            damageAmount = Math.max(damageAmount - entity.func_110139_bj(), 0.0f);
            entity.func_110149_m(entity.func_110139_bj() - (f - damageAmount));
            damageAmount = ForgeHooks.onLivingDamage((EntityLivingBase)entity, (DamageSource)source, (float)damageAmount);
            if (damageAmount != 0.0f) {
                float f1 = entity.func_110143_aJ();
                entity.func_110142_aN().func_94547_a(source, f1, damageAmount);
                entity.func_70606_j(f1 - damageAmount);
                entity.func_110149_m(entity.func_110139_bj() - damageAmount);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntityPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getItemStack()) && event.getItemStack().func_77952_i() >= event.getItemStack().func_77958_k() - 1 && !(event.getItemStack().func_77973_b() instanceof ItemArmor)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityRightClicked(PlayerInteractEvent.EntityInteract event) {
        if (!event.getEntityPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getItemStack()) && event.getItemStack().func_77952_i() >= event.getItemStack().func_77958_k() - 1 && !(event.getItemStack().func_77973_b() instanceof ItemArmor)) {
            event.setCanceled(true);
        }
    }
}

