/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.neverbreak;

import cjminecraft.neverbreak.NeverBreak;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="neverbreak")
public class Events {
    public static boolean hasNeverBreakEnchantment(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)NeverBreak.NEVER_BREAK, (ItemStack)stack) > 0;
    }

    @SubscribeEvent
    public static void onItemDestroy(PlayerDestroyItemEvent event) {
        if (event.getOriginal() == null) {
            return;
        }
        if (!event.getPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getOriginal())) {
            ItemStack stack = event.getOriginal();
            stack.func_196085_b(stack.func_77958_k());
            if (event.getHand() != null) {
                event.getPlayer().func_184611_a(event.getHand(), stack);
            } else {
                event.setCanceled(true);
                if (event.getPlayer().func_184614_ca() == ItemStack.field_190927_a) {
                    event.getPlayer().func_184611_a(Hand.MAIN_HAND, stack);
                } else {
                    event.getPlayer().func_184611_a(Hand.OFF_HAND, stack);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHoeUse(UseHoeEvent event) {
        if (!event.getPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getPlayer().func_184614_ca()) && event.getPlayer().func_184614_ca().func_77952_i() >= event.getPlayer().func_184614_ca().func_77958_k() - 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        if (!event.getPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getPlayer().func_184614_ca()) && event.getPlayer().func_184614_ca().func_77952_i() >= event.getPlayer().func_184614_ca().func_77958_k() - 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!event.getPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getPlayer().func_184614_ca()) && event.getPlayer().func_184614_ca().func_77952_i() >= event.getPlayer().func_184614_ca().func_77958_k() - 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getPlayer().func_184614_ca()) && event.getPlayer().func_184614_ca().func_77952_i() >= event.getPlayer().func_184614_ca().func_77958_k() - 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemFished(ItemFishedEvent event) {
        if (!event.getPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getPlayer().func_184614_ca()) && event.getPlayer().func_184614_ca().func_77952_i() >= event.getPlayer().func_184614_ca().func_77958_k() - 2) {
            event.damageRodBy(0);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onArrowLoose(ArrowLooseEvent event) {
        if (!event.getPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getBow()) && event.getBow().func_77952_i() >= event.getBow().func_77958_k() - 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.getPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getItemStack()) && event.getItemStack().func_77952_i() >= event.getItemStack().func_77958_k() - 1 && !(event.getItemStack().func_77973_b() instanceof ArmorItem)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && ((PlayerEntity)event.getEntityLiving()).func_184812_l_()) {
            return;
        }
        AtomicBoolean hasNeverBreakEnchant = new AtomicBoolean(false);
        event.getEntityLiving().func_184209_aF().forEach(stack -> {
            if (EnchantmentHelper.func_77506_a((Enchantment)NeverBreak.NEVER_BREAK, (ItemStack)stack) > 0) {
                hasNeverBreakEnchant.set(true);
            }
        });
        if (hasNeverBreakEnchant.get()) {
            event.setCanceled(true);
            LivingEntity entity = event.getEntityLiving();
            DamageSource source = event.getSource();
            float damageAmount = event.getAmount();
            ArrayList<ItemStack> armourList = new ArrayList<ItemStack>();
            if (!source.func_76363_c()) {
                float totalArmourValue = 0.0f;
                float totalArmourToughness = 0.0f;
                if (entity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)entity;
                    if (damageAmount > 0.0f) {
                        float damage = damageAmount / 4.0f;
                        if (damage < 1.0f) {
                            damage = 1.0f;
                        }
                        PlayerInventory inventory = player.field_71071_by;
                        for (int i = 0; i < inventory.field_70460_b.size(); ++i) {
                            ItemStack stack2 = (ItemStack)inventory.field_70460_b.get(i);
                            if (!(stack2.func_77973_b() instanceof ArmorItem) || Events.hasNeverBreakEnchantment(stack2) && !((float)stack2.func_77952_i() < (float)stack2.func_77958_k() - damage)) continue;
                            int finalI = i;
                            stack2.func_222118_a((int)damage, (LivingEntity)player, p -> p.func_213361_c(EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)finalI)));
                            totalArmourValue += (float)((ArmorItem)stack2.func_77973_b()).func_200881_e();
                            totalArmourToughness += ((ArmorItem)stack2.func_77973_b()).getToughness();
                            armourList.add(stack2);
                        }
                    }
                }
                damageAmount = CombatRules.func_189427_a((float)damageAmount, (float)totalArmourValue, (float)totalArmourToughness);
            }
            if (!source.func_151517_h()) {
                int i;
                int j;
                float f;
                float f1;
                float f2;
                float damage = damageAmount;
                if (entity.func_70644_a(Effects.field_76429_m) && source != DamageSource.field_76380_i && (f2 = (f1 = damage) - (damage = Math.max((f = damage * (float)(j = 25 - (i = (entity.func_70660_b(Effects.field_76429_m).func_76458_c() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
                    if (entity instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)entity).func_195067_a(Stats.field_212739_K, Math.round(f2 * 10.0f));
                    } else if (source.func_76346_g() instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)source.func_76346_g()).func_195067_a(Stats.field_212736_G, Math.round(f2 * 10.0f));
                    }
                }
                if (damage <= 0.0f) {
                    damageAmount = 0.0f;
                } else {
                    int k = EnchantmentHelper.func_77508_a(armourList, (DamageSource)source);
                    if (k > 0) {
                        damage = CombatRules.func_188401_b((float)damage, (float)k);
                    }
                    damageAmount = damage;
                }
            }
            float f2 = Math.max(damageAmount - entity.func_110139_bj(), 0.0f);
            entity.func_110149_m(entity.func_110139_bj() - (damageAmount - f2));
            float f = damageAmount - f2;
            if (f > 0.0f && f < 3.4028235E37f && source.func_76346_g() instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)source.func_76346_g()).func_195067_a(Stats.field_212735_F, Math.round(f * 10.0f));
            }
            if ((f2 = ForgeHooks.onLivingDamage((LivingEntity)entity, (DamageSource)source, (float)f2)) != 0.0f) {
                float f1 = entity.func_110143_aJ();
                entity.func_110142_aN().func_94547_a(source, f1, f2);
                entity.func_70606_j(f1 - f2);
                entity.func_110149_m(entity.func_110139_bj() - f2);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getItemStack()) && event.getItemStack().func_77952_i() >= event.getItemStack().func_77958_k() - 1 && !(event.getItemStack().func_77973_b() instanceof ArmorItem)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityRightClicked(PlayerInteractEvent.EntityInteract event) {
        if (!event.getPlayer().func_184812_l_() && Events.hasNeverBreakEnchantment(event.getItemStack()) && event.getItemStack().func_77952_i() >= event.getItemStack().func_77958_k() - 1 && !(event.getItemStack().func_77973_b() instanceof ArmorItem)) {
            event.setCanceled(true);
        }
    }
}

