/*
 * Decompiled with CFR 0.152.
 */
package com.github.wimpingego.nnow.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class ToolUtil3x3 {
    public static BlockRayTraceResult getLookingAt(PlayerEntity player, double range) {
        return ToolUtil3x3.getLookingAt(player, range, RayTraceContext.FluidMode.NONE);
    }

    public static BlockRayTraceResult getLookingAt(PlayerEntity player, double range, RayTraceContext.FluidMode fluidMode) {
        World world = player.field_70170_p;
        Vec3d look = player.func_70040_Z();
        Vec3d startPos = ToolUtil3x3.getVec3d((Entity)player).func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d endPos = startPos.func_178787_e(look.func_216372_d(range, range, range));
        RayTraceContext context = new RayTraceContext(startPos, endPos, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player);
        return world.func_217299_a(context);
    }

    public static Vec3d getVec3d(BlockPos pos) {
        return new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static Vec3d getVec3d(Entity entity) {
        return entity.func_213303_ch();
    }

    public static BlockRayTraceResult getLookingAt(Vec3d position, Vec3d look, double range, Entity entity) {
        Vec3d endPos = position.func_178787_e(look.func_216372_d(range, range, range));
        RayTraceContext context = new RayTraceContext(position, endPos, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, entity);
        return entity.field_70170_p.func_217299_a(context);
    }

    public static List<BlockPos> getBlocks(BlockPos pos, Direction facing) {
        return ToolUtil3x3.getBlocks(pos, facing, 3);
    }

    public static List<BlockPos> getBlocks(BlockPos pos, Direction facing, int radius) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (radius % 2 == 0) {
            return positions;
        }
        if (radius < 3) {
            positions.add(pos);
            return positions;
        }
        int d = radius / 2;
        int min = -d;
        int max = d;
        switch (facing) {
            case DOWN: 
            case UP: {
                for (int x = min; x <= max; ++x) {
                    for (int z = min; z <= max; ++z) {
                        positions.add(pos.func_177982_a(x, 0, z));
                    }
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                for (int x = min; x <= max; ++x) {
                    for (int y = min; y <= max; ++y) {
                        positions.add(pos.func_177982_a(x, y, 0));
                    }
                }
                break;
            }
            case WEST: 
            case EAST: {
                for (int z = min; z <= max; ++z) {
                    for (int y = min; y <= max; ++y) {
                        positions.add(pos.func_177982_a(0, y, z));
                    }
                }
                break;
            }
        }
        return positions;
    }

    public static void dropItems(World world, List<ItemStack> items, BlockPos pos) {
        for (ItemStack stack : items) {
            if (stack.func_190926_b()) continue;
            ToolUtil3x3.dropItem(world, stack, pos);
        }
    }

    public static void dropItems(World world, ItemStackHandler handler, BlockPos pos) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ToolUtil3x3.dropItem(world, stack, pos);
        }
    }

    public static void dropItem(World world, ItemStack stack, BlockPos pos) {
        InventoryHelper.func_180173_a((World)world, (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)stack);
    }

    public static int spawnExp(World world, BlockPos pos, BlockState state, int fortune, int silk) {
        return ToolUtil3x3.spawnExp(world, pos, state.getExpDrop((IWorldReader)world, pos, fortune, silk));
    }

    public static int spawnExp(World world, BlockPos pos, int exp) {
        return ToolUtil3x3.spawnExp(world, pos, exp, true);
    }

    public static int spawnExp(World world, BlockPos pos, int exp, boolean split) {
        if (exp > 0) {
            if (split) {
                while (exp > 0) {
                    int drop = ExperienceOrbEntity.func_70527_a((int)exp);
                    exp -= drop;
                    world.func_217376_c((Entity)new ExperienceOrbEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop));
                }
            } else {
                world.func_217376_c((Entity)new ExperienceOrbEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, exp));
            }
        }
        return exp;
    }
}

