/*
Copyright (C) 2019 RRe36

All Rights Reserved unless otherwise explicitly stated.


By downloading this you have agreed to the license and terms of use.
These can be found inside the included license-file or here: https://github.com/rre36/glsl_kappa/blob/master/LICENSE

Violating these terms may be penalized with actions according to the Digital Millennium Copyright Act (DMCA), the Information Society Directive and/or similar laws depending on your country.
*/

#define sunlight_luma 1.0 //[0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0]
#define skylight_luma 1.0 //[0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0]
#define blocklight_luma 1.0 //[0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0]

#define blocklight_color_preset 0          //[0 1 2 3] 0-warm 1-warm-ish 2-neutral warm 3-neutral

#if blocklight_color_preset==0
    #define blocklight_color vec3(1.0, 0.28, 0.0)
#elif blocklight_color_preset==1
    #define blocklight_color vec3(1.0, 0.36, 0.08)
#elif blocklight_color_preset==2
    #define blocklight_color vec3(1.0, 0.55, 0.23)
#elif blocklight_color_preset==3
    #define blocklight_color vec3(1.0, 0.78, 0.53)
#endif

flat out mat3x3 light_color;

#define end_tint_int 1.0    //[0.0 0.2 0.4 0.6 0.8 1.0]

void make_colors() {
    light_color[0]  = vec3(0.5, 0.3, 1.0);
    light_color[0]  = mix(vec3(v3avg(light_color[0])), light_color[0], end_tint_int);
    light_color[0] *= sunlight_luma*0.1;

    light_color[1]  = vec3(0.4, 0.2, 1.0);
    light_color[1]  = mix(vec3(v3avg(light_color[1])), light_color[1], end_tint_int);
    light_color[1] *= skylight_luma*0.3;

    light_color[2]  = blocklight_color*blocklight_luma;
}