/*
Copyright (C) 2019 RRe36

All Rights Reserved unless otherwise explicitly stated.


By downloading this you have agreed to the license and terms of use.
These can be found inside the included license-file or here: https://github.com/rre36/glsl_kappa/blob/master/LICENSE

Violating these terms may be penalized with actions according to the Digital Millennium Copyright Act (DMCA), the Information Society Directive and/or similar laws depending on your country.
*/

#include "/lib/common.glsl"
#include "/lib/util/srgb.glsl"

#define INFO 0  //[0]

/* ------ color grading related settings ------ */
//#define do_colorgrading

#define vibrance_int 1.00       //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]
#define saturation_int 1.00     //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]
#define gamma_curve 1.00        //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]
#define brightness_int 0.00     //[-0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.5]
#define constrast_int 1.00      //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]

#define colorlum_r 1.00         //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]
#define colorlum_g 1.00         //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]
#define colorlum_b 1.00         //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]

#define vignette_enabled
#define vignette_start 0.15     //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define vignette_end 0.85       //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define vignette_intensity 0.75 //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define vignette_exponent 2.00  //[0.50 0.75 1.0 1.25 1.50 1.75 2.00 2.25 2.50 2.75 3.00 3.25 3.50 3.75 4.00 4.25 4.50 4.75 5.00]

in vec2 coord;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex3;
uniform sampler2D colortex4;

uniform int frameCounter;

uniform float aspectRatio;
uniform float frameTimeCounter;
uniform float nightVision;
uniform float rainStrength;
uniform vec2 pixelSize;
uniform vec2 viewSize;

uniform vec3 sunPosition;
uniform vec3 sunvec;

uniform mat4 gbufferProjection;

vec3 tonemap_reinhard(vec3 hdr) {
    float luma      = getLuma(hdr);

    float coeff     = 0.9 - nightVision*0.7;

    vec3 col        = hdr/(hdr + coeff);
        col         = mix(hdr/(luma + coeff), col, col);

    return toSRGB(col);
}

struct hable_param {
    float curve;
    float toe;
    float angle;
    float slope;
    float black;
    float range;
    float white;
} hable;

vec3 hable_curve(vec3 x) {
    float A   = hable.curve;
    float B   = hable.toe;
    float C   = hable.slope;
    float D   = hable.angle;
    float E   = hable.black;
    float F   = hable.range;
    return ((x * (A*x + C*B) + D*E) / (x * (A*x + B) + D*F)) - E/F;
}

vec3 tonemap_hable(vec3 hdr) {
    hable.curve        = 0.22;
    hable.toe          = 0.81 + nightVision * 0.15;
    hable.slope        = 0.62;
    hable.angle        = 0.39;
    hable.black        = 0.00;
    hable.range        = 1.70;
    hable.white        = 14.00;

    vec3 white = hable_curve(vec3(hable.white));

    vec3 col    = hable_curve(hdr);
        col     = col * rcp(white);

    return toSRGB(saturate(col));
}

/* ------ color grading utilities ------ */

vec3 rgb_luma(vec3 x) {
    x.r *= colorlum_r;
    x.g *= colorlum_g;
    x.b *= colorlum_b;

    return x;
}

/* --- post tonemap color grading --- */
vec3 gammacurve(vec3 x) {
    #if color_preset == 0
    const float gint    = gamma_curve;
    #elif color_preset == 1
    const float gint    = gamma_curve - 0.2;
    #elif color_preset == 2
    const float gint    = gamma_curve + 0.08;
    #endif

    return pow(x, vec3(gint));
}

vec3 vibrance_saturation(vec3 color) {
    #ifdef do_colorgrading
        #if color_preset == 0
        const float vint    = vibrance_int + 0.1;
        const float sint    = saturation_int + 0.02;
        #elif color_preset == 1
        const float vint    = vibrance_int + 0.2;
        const float sint    = saturation_int + 0.18;
        #elif color_preset == 2
        const float vint    = vibrance_int;
        const float sint    = saturation_int + 0.02;
        #endif
    #else
        const float vint    = 1.1;
        const float sint    = 1.02;
    #endif

    float lum   = dot(color, lumacoeff_rec709);
    float mn    = min(min(color.r, color.g), color.b);
    float mx    = max(max(color.r, color.g), color.b);
    float sat   = (1.0 - saturate(mx-mn)) * saturate(1.0-mx) * lum * 5.0;
    vec3 light  = vec3((mn + mx) / 2.0);

    color   = mix(color, mix(light, color, vint), saturate(sat));

    color   = mix(color, light, saturate(1.0-light) * (1.0-vint) / 2.0 * abs(vint));

    color   = mix(vec3(lum), color, sint);

    return color;
}

vec3 brightness_contrast(vec3 color) {
    #if color_preset == 0
    const float bint    = brightness_int;
    const float cint    = constrast_int;
    #elif color_preset == 1
    const float bint    = brightness_int;
    const float cint    = constrast_int + 0.13;
    #elif color_preset == 2
    const float bint    = brightness_int + 0.02;
    const float cint    = constrast_int + 0.02;
    #endif

    return (color - 0.5) * cint + 0.5 + bint;
}

vec3 vignette(vec3 color) {
    float fade      = length(coord*2.0-1.0);
        fade        = linStep(abs(fade) * 0.5, vignette_start, vignette_end);
        fade        = 1.0 - pow(fade, vignette_exponent) * vignette_intensity;

    return color * fade;
}

#ifndef dim
#include "/lib/frag/bslflare.glsl"

vec3 get_lensflare(){
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
        tpos.xyz /= tpos.w;
        tpos.xy = tpos.xy/tpos.z;

	vec2 lightPos = tpos.xy * 0.5;
	float truepos = sunPosition.z/abs(sunPosition.z);
	vec3 visible = texture(colortex1, lightPos.xy + 0.5).rgb;
        visible *= sstep(sunvec.y, 0.0, 0.1);

        visible *= 1.0-linStep(length(tpos.xy), 0.85, 1.25);

    if(min(visible.x, min(visible.y, visible.z))>0.01 && truepos < 1.0) {
        return genLensFlare(lightPos, truepos, lens_intensity);
    } else {
        return vec3(0.0);
    }
}
#endif

void main() {
    vec3 scene_hdr  = stex(colortex0).rgb;

    #ifdef bloom_enabled
        vec2 cres       = max(viewSize, vec2(1920.0, 1080.0));

        float bloom_int = 0.014 + max(stex(colortex4).a, 1.0)*0.0025;

        #if dim == -1
            bloom_int  *= 1.5;
        #elif dim == 1
            bloom_int  *= 1.5;
        #endif

            scene_hdr  += texture(colortex3, coord/cres*vec2(1920.0, 1080.0)*0.5).rgb * bloom_int * bloom_intensity;  //apply bloom
    #endif

    #ifndef dim
        #ifdef lens_flare
        scene_hdr += get_lensflare();
        #endif
    #endif

    #ifdef manual_exposure_enabled
        scene_hdr  *= rcp(manual_exposure);
    #else
        scene_hdr  *= stex(colortex4).a;
    #endif

        scene_hdr   = vibrance_saturation(scene_hdr);

    #ifdef do_colorgrading
        scene_hdr   = rgb_luma(scene_hdr);
    #endif

    #ifdef vignette_enabled
        scene_hdr    = vignette(scene_hdr);
    #endif

    vec3 scene_sdr  = tonemap_hable(scene_hdr);

    #ifdef do_colorgrading
        scene_sdr    = brightness_contrast(scene_sdr);
        scene_sdr    = gammacurve(scene_sdr);
    #endif

    //if (isnan3(scene_sdr)) scene_sdr.rgb    = vec3(1.0, 0.0, 0.0);
    //if (isinf3(scene_sdr)) scene_sdr.rgb    = vec3(1.0, 1.0, 0.0);

    /*DRAWBUFFERS:0*/
    gl_FragData[0]  = makeDrawbuffer(scene_sdr);
}