/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching;

import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public final class Config {
    public static final CommonConfig COMMON = Config.register(ModConfig.Type.COMMON, x$0 -> new CommonConfig((ForgeConfigSpec.Builder)x$0));
    public static final ServerConfig SERVER = Config.register(ModConfig.Type.SERVER, x$0 -> new ServerConfig((ForgeConfigSpec.Builder)x$0));

    public static void init() {
    }

    private static <T> T register(ModConfig.Type type, Function<ForgeConfigSpec.Builder, T> factory) {
        Pair configPair = new ForgeConfigSpec.Builder().configure(factory);
        ModLoadingContext.get().registerConfig(type, (ForgeConfigSpec)configPair.getRight());
        return (T)configPair.getLeft();
    }

    public static final class ServerConfig {
        public final ForgeConfigSpec.BooleanValue noMiningWithoutCorrectTool;
        public final ForgeConfigSpec.BooleanValue noBlockDropsWithoutCorrectTool;
        public final ForgeConfigSpec.BooleanValue doInstantBreakBlocksRequireTool;
        public final ForgeConfigSpec.BooleanValue doInstantBreakBlocksDamageKnives;
        public final ForgeConfigSpec.DoubleValue flintKnappingConsumeChance;
        public final ForgeConfigSpec.DoubleValue flintKnappingSuccessChance;
        public final ForgeConfigSpec.DoubleValue fireStarterFireStartChance;

        private ServerConfig(ForgeConfigSpec.Builder builder) {
            this.noMiningWithoutCorrectTool = builder.comment("Makes blocks take forever to mine if using the wrong tool").define("noMiningWithoutCorrectTool", true);
            this.noBlockDropsWithoutCorrectTool = builder.comment("Makes blocks not drop anything when broken with the wrong tool").define("noBlockDropsWithoutCorrectTool", true);
            this.doInstantBreakBlocksRequireTool = builder.comment("Makes blocks that would otherwise be broken instantly unbreakable if using the wrong tool.").define("doInstantBreakBlocksRequireTool", false);
            this.doInstantBreakBlocksDamageKnives = builder.comment("If blocks such as tall grass which break instantly consume durability when broken with a knife (only affects No Tree Punching knives)").define("doInstantBreakBlocksDamageKnives", true);
            this.flintKnappingConsumeChance = builder.comment("The chance to consume a piece of flint when knapping").defineInRange("flintKnappingConsumeChance", 0.4, 0.0, 1.0);
            this.flintKnappingSuccessChance = builder.comment("The chance to produce flint shards if a piece of flint has been consumed while knapping").defineInRange("flintKnappingSuccessChance", 0.7, 0.0, 1.0);
            this.fireStarterFireStartChance = builder.comment("The chance for a fire starter to start fires").defineInRange("fireStarterFireStartChance", 0.3, 0.0, 1.0);
        }
    }

    public static final class CommonConfig {
        public final ForgeConfigSpec.BooleanValue enableLooseRocksWorldGen;

        private CommonConfig(ForgeConfigSpec.Builder builder) {
            this.enableLooseRocksWorldGen = builder.comment(new String[]{"Enables loose rock world gen added automatically to biomes.", "Note: Requires a world restart to take effect!"}).define("enableLooseRocksWorldGen", true);
        }
    }
}

