/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching;

import com.alcatrazescapee.notreepunching.Config;
import com.alcatrazescapee.notreepunching.client.ModSounds;
import com.alcatrazescapee.notreepunching.common.ModTags;
import com.alcatrazescapee.notreepunching.common.items.ModItems;
import com.alcatrazescapee.notreepunching.util.HarvestBlockHandler;
import com.alcatrazescapee.notreepunching.world.ModFeatures;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="notreepunching", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventHandler {
    private static final Random RANDOM = new Random();
    private static final Set<Biome.Category> CATEGORIES_WITHOUT_ROCKS = new HashSet<Biome.Category>(Arrays.asList(Biome.Category.NONE, Biome.Category.THEEND, Biome.Category.NETHER, Biome.Category.OCEAN));

    @SubscribeEvent
    public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        boolean canHarvest = event.canHarvest();
        canHarvest = ModTags.Blocks.ALWAYS_DROPS.func_230235_a_((Object)event.getTargetBlock().func_177230_c()) ? true : (((Boolean)Config.SERVER.noBlockDropsWithoutCorrectTool.get()).booleanValue() ? (canHarvest |= HarvestBlockHandler.canHarvest(event.getTargetBlock(), event.getPlayer())) : (canHarvest |= HarvestBlockHandler.doesBlockRequireNoToolByDefault(event.getTargetBlock().func_177230_c())));
        event.setCanHarvest(canHarvest);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (((Boolean)Config.SERVER.noMiningWithoutCorrectTool.get()).booleanValue() && !HarvestBlockHandler.canHarvest(event.getState(), event.getPlayer()) && !ModTags.Blocks.ALWAYS_BREAKABLE.func_230235_a_((Object)event.getState().func_177230_c())) {
            float newSpeed = (Boolean)Config.SERVER.doInstantBreakBlocksRequireTool.get() != false ? 0.0f : 1.0E-10f;
            event.setNewSpeed(newSpeed);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        if (ModTags.Items.FLINT_KNAPPABLE.func_230235_a_((Object)stack.func_77973_b()) && state.func_185904_a() == Material.field_151576_e) {
            if (!world.field_72995_K) {
                if ((double)RANDOM.nextFloat() < (Double)Config.SERVER.flintKnappingConsumeChance.get()) {
                    if ((double)RANDOM.nextFloat() < (Double)Config.SERVER.flintKnappingSuccessChance.get()) {
                        Direction face = event.getFace() == null ? Direction.UP : event.getFace();
                        InventoryHelper.func_180173_a((World)world, (double)((double)pos.func_177958_n() + 0.5 + (double)face.func_82601_c() * 0.5), (double)((double)pos.func_177956_o() + 0.5 + (double)face.func_96559_d() * 0.5), (double)((double)pos.func_177952_p() + 0.5 + (double)face.func_82599_e() * 0.5), (ItemStack)new ItemStack((IItemProvider)ModItems.FLINT_SHARD.get(), 2));
                    }
                    stack.func_190918_g(1);
                    event.getPlayer().func_184611_a(event.getHand(), stack);
                }
                world.func_184133_a(null, pos, (SoundEvent)ModSounds.KNAPPING.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (((Boolean)Config.COMMON.enableLooseRocksWorldGen.get()).booleanValue() && !CATEGORIES_WITHOUT_ROCKS.contains(event.getCategory())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, (ConfiguredFeature)ModFeatures.LOOSE_ROCKS_CONFIGURED.get());
        }
    }
}

