/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.items;

import com.alcatrazescapee.notreepunching.mixin.item.AxeItemAccess;
import com.alcatrazescapee.notreepunching.mixin.item.HoeItemAccess;
import com.alcatrazescapee.notreepunching.mixin.item.ShovelItemAccess;
import com.alcatrazescapee.notreepunching.util.HarvestBlockHandler;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.ForgeEventFactory;

public class MattockItem
extends ToolItem {
    public static final Set<Block> EFFECTIVE_BLOCKS = Stream.of(AxeItemAccess.getEffectiveBlocks(), ShovelItemAccess.getEffectiveBlocks(), HoeItemAccess.getEffectiveBlocks()).flatMap(Collection::stream).collect(Collectors.toSet());

    public MattockItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, tier, EFFECTIVE_BLOCKS, builder.addToolType(ToolType.AXE, tier.func_200925_d()).addToolType(ToolType.SHOVEL, tier.func_200925_d()).addToolType(ToolType.HOE, tier.func_200925_d()).addToolType(HarvestBlockHandler.MATTOCK, tier.func_200925_d()));
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return AxeItemAccess.getEffectiveMaterials().contains(material) ? this.field_77864_a : super.func_150893_a(stack, state);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType result = this.onAxeItemUse(context);
        if (result == ActionResultType.PASS) {
            if (context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
                result = this.onHoeItemUse(context);
                if (result == ActionResultType.PASS) {
                    result = this.onShovelItemUse(context);
                }
            } else {
                result = this.onShovelItemUse(context);
                if (result == ActionResultType.PASS) {
                    result = this.onHoeItemUse(context);
                }
            }
        }
        return result;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return blockIn.func_203425_a(Blocks.field_150433_aE) || blockIn.func_203425_a(Blocks.field_196604_cC);
    }

    private ActionResultType onAxeItemUse(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.func_195991_k();
        BlockState stateIn = world.func_180495_p(blockpos = context.func_195995_a());
        BlockState stateOut = stateIn.getToolModifiedState(world, blockpos, context.func_195999_j(), context.func_195996_i(), ToolType.AXE);
        if (stateOut != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, stateOut, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, p_220040_1_ -> p_220040_1_.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private ActionResultType onHoeItemUse(ItemUseContext context) {
        BlockState blockstate;
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        int hook = ForgeEventFactory.onHoeUse((ItemUseContext)context);
        if (hook != 0) {
            return hook > 0 ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        if (context.func_196000_l() != Direction.DOWN && world.func_175623_d(blockpos.func_177984_a()) && (blockstate = world.func_180495_p(blockpos).getToolModifiedState(world, blockpos, context.func_195999_j(), context.func_195996_i(), ToolType.HOE)) != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, p_220043_1_ -> p_220043_1_.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private ActionResultType onShovelItemUse(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (context.func_196000_l() == Direction.DOWN) {
            return ActionResultType.PASS;
        }
        PlayerEntity playerentity = context.func_195999_j();
        BlockState blockstate1 = blockstate.getToolModifiedState(world, context.func_195995_a(), playerentity, context.func_195996_i(), ToolType.SHOVEL);
        BlockState blockstate2 = null;
        if (blockstate1 != null && world.func_175623_d(blockpos.func_177984_a())) {
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            blockstate2 = blockstate1;
        } else if (blockstate.func_177230_c() instanceof CampfireBlock && ((Boolean)blockstate.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
            world.func_217378_a((PlayerEntity)null, 1009, blockpos, 0);
            blockstate2 = (BlockState)blockstate.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate2 != null) {
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate2, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, p_220041_1_ -> p_220041_1_.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

