/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.util;

import com.alcatrazescapee.notreepunching.Config;
import com.alcatrazescapee.notreepunching.common.ModTags;
import com.alcatrazescapee.notreepunching.mixin.block.AbstractBlockAccess;
import com.alcatrazescapee.notreepunching.mixin.block.AbstractBlockPropertiesAccess;
import com.alcatrazescapee.notreepunching.mixin.block.AbstractBlockStateAccess;
import com.alcatrazescapee.notreepunching.util.Helpers;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.TieredItem;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HarvestBlockHandler {
    public static final ToolType SWORD = ToolType.get((String)"sword");
    public static final ToolType MATTOCK = ToolType.get((String)"mattock");
    private static final Set<Block> DEFAULT_NO_TOOL_BLOCKS = new HashSet<Block>();
    private static final Map<Block, ToolType> ADDITIONAL_TOOL_TYPE_BLOCKS = new HashMap<Block, ToolType>();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Field HARVEST_TOOL_FIELD = Helpers.findUnobfField(Block.class, "harvestTool");
    private static final Field HARVEST_LEVEL_FIELD = Helpers.findUnobfField(Block.class, "harvestLevel");
    private static final Field TOOL_CLASSES_FIELD = Helpers.findUnobfField(Item.class, "toolClasses");

    public static void setup() {
        HashMap inferredTools = new HashMap();
        Helpers.putAll(inferredTools, ToolType.AXE, Material.field_151575_d, Material.field_237214_y_);
        Helpers.putAll(inferredTools, ToolType.PICKAXE, Material.field_151576_e, Material.field_151573_f, Material.field_151574_g, Material.field_76233_E);
        Helpers.putAll(inferredTools, ToolType.SHOVEL, Material.field_151578_c, Material.field_151572_C, Material.field_151595_p, Material.field_151571_B, Material.field_151597_y, Material.field_151596_z);
        Helpers.putAll(inferredTools, ToolType.HOE, Material.field_151577_b, Material.field_242934_h, Material.field_151583_m, Material.field_151584_j);
        Helpers.putAll(inferredTools, SWORD, Material.field_151585_k, Material.field_203243_f, Material.field_151582_l, Material.field_204868_h, Material.field_215713_z, Material.field_215712_y, Material.field_151570_A);
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            AbstractBlockAccess blockAccess = (AbstractBlockAccess)block;
            AbstractBlock.Properties settings = blockAccess.getProperties();
            AbstractBlockPropertiesAccess settingsAccess = (AbstractBlockPropertiesAccess)settings;
            Material material = blockAccess.getMaterial();
            if (!settingsAccess.getRequiresCorrectToolForDrops()) {
                DEFAULT_NO_TOOL_BLOCKS.add(block);
            }
            settings.func_235861_h_();
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                ((AbstractBlockStateAccess)state).setRequiresCorrectToolForDrops(true);
            }
            try {
                ToolType harvestTool = (ToolType)HARVEST_TOOL_FIELD.get(block);
                int harvestLevel = HARVEST_LEVEL_FIELD.getInt(block);
                if (harvestTool == null) {
                    harvestTool = (ToolType)inferredTools.get(material);
                    if (harvestTool == null) continue;
                    HARVEST_TOOL_FIELD.set(block, harvestTool);
                    HARVEST_LEVEL_FIELD.set(block, Math.max(0, harvestLevel));
                    continue;
                }
                ToolType extraTool = (ToolType)inferredTools.get(material);
                if (extraTool == null) continue;
                ADDITIONAL_TOOL_TYPE_BLOCKS.put(block, extraTool);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("Unable to set harvest tool and level for block: {}. Cause: {}. Please report this to NTP!", (Object)block, (Object)e.getMessage());
            }
        }
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            try {
                Map toolClasses = (Map)TOOL_CLASSES_FIELD.get(item);
                if (item instanceof SwordItem && !toolClasses.containsKey(SWORD)) {
                    toolClasses.put(SWORD, ((SwordItem)item).func_200891_e().func_200925_d());
                }
                if (!(item instanceof ShearsItem) || toolClasses.containsKey(SWORD)) continue;
                toolClasses.put(SWORD, 0);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.warn("Unable to add tool class(es) for item: {}. Cause: {}. Please report this to NTP!", (Object)item, (Object)e.getMessage());
            }
        }
    }

    public static boolean doesBlockRequireNoToolByDefault(Block block) {
        return DEFAULT_NO_TOOL_BLOCKS.contains(block);
    }

    public static boolean canHarvest(BlockState state, PlayerEntity player) {
        if (!(!((Boolean)Config.SERVER.noBlockDropsWithoutCorrectTool.get()).booleanValue() && HarvestBlockHandler.doesBlockRequireNoToolByDefault(state.func_177230_c()) || ModTags.Blocks.ALWAYS_DROPS.func_230235_a_((Object)state.func_177230_c()))) {
            ItemStack stack = player.func_184614_ca();
            if (!stack.func_190926_b()) {
                ToolType tool = state.getHarvestTool();
                if (tool != null && HarvestBlockHandler.canHarvestWithTool(state, player, stack, tool)) {
                    return true;
                }
                tool = ADDITIONAL_TOOL_TYPE_BLOCKS.get(state.func_177230_c());
                return tool == null || HarvestBlockHandler.canHarvestWithTool(state, player, stack, tool);
            }
            return player.field_71071_by.func_70448_g().func_150998_b(state);
        }
        return true;
    }

    private static boolean canHarvestWithTool(BlockState state, PlayerEntity player, ItemStack stack, ToolType tool) {
        int harvestLevel;
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
        if (toolLevel == -1) {
            toolLevel = HarvestBlockHandler.getExtraHarvestLevel(stack, tool);
        }
        if ((harvestLevel = state.getHarvestLevel()) == -1) {
            harvestLevel = 0;
        }
        return toolLevel >= harvestLevel;
    }

    private static int getExtraHarvestLevel(ItemStack stack, ToolType tool) {
        if (tool == ToolType.SHOVEL && stack.getToolTypes().contains(ToolType.PICKAXE)) {
            return 0;
        }
        if (tool == SWORD && (ModTags.Items.KNIVES.func_230235_a_((Object)stack.func_77973_b()) || Tags.Items.SHEARS.func_230235_a_((Object)stack.func_77973_b()))) {
            if (stack.func_77973_b() instanceof TieredItem) {
                return ((TieredItem)stack.func_77973_b()).func_200891_e().func_200925_d();
            }
            return 0;
        }
        return -1;
    }
}

