/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.util;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Helpers {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RANDOM = new Random();

    public static <T> Optional<T> getTE(IBlockReader world, BlockPos pos, Class<T> tileClass) {
        TileEntity tile = world.func_175625_s(pos);
        if (tileClass.isInstance(tile)) {
            return Optional.of(tile);
        }
        return Optional.empty();
    }

    public static ItemStack hurtAndBreak(ItemStack stack, int amount) {
        if (stack.func_77984_f() && stack.func_96631_a(amount, RANDOM, null)) {
            stack.func_190918_g(1);
            stack.func_196085_b(0);
        }
        return stack;
    }

    public static ItemStack hurtAndBreak(@Nullable PlayerEntity player, @Nullable Hand hand, ItemStack stack, int amount) {
        if (player != null && hand != null) {
            stack.func_222118_a(amount, (LivingEntity)player, entity -> entity.func_213334_d(hand));
            return stack;
        }
        return Helpers.hurtAndBreak(stack, amount);
    }

    public static <T> void ifPresentOrElse(LazyOptional<T> lazyOptional, Consumer<T> ifPresent, Runnable orElse) {
        lazyOptional.map(internal -> {
            ifPresent.accept(internal);
            return Unit.INSTANCE;
        }).orElseGet(() -> {
            orElse.run();
            return Unit.INSTANCE;
        });
    }

    public static <T> void ifPresentOrElse(Optional<T> optional, Consumer<T> ifPresent, Runnable orElse) {
        optional.map(internal -> {
            ifPresent.accept(internal);
            return Unit.INSTANCE;
        }).orElseGet(() -> {
            orElse.run();
            return Unit.INSTANCE;
        });
    }

    public static <T, R> LazyOptional<R> getCapabilityOrElse(@Nullable Capability<R> capability, @Nullable Capability<T> capabilityToCheck, LazyOptional<T> instance) {
        if (capabilityToCheck == null || capability == null) {
            LOGGER.warn("Something called getCapability with a null capability! This is illegal");
            LOGGER.debug((Object)new RuntimeException("Stacktrace"));
            return LazyOptional.empty();
        }
        return capabilityToCheck.orEmpty(capability, instance);
    }

    @Nonnull
    public static <T> T getNull() {
        return null;
    }

    public static <K, V> void putAll(Map<K, V> map, V value, K ... keys) {
        for (K k : keys) {
            map.put(k, value);
        }
    }

    public static Field findUnobfField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unable to find unobf field for " + clazz.getSimpleName() + "#" + fieldName + ", this is a bug!");
        }
    }
}

