/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.util;

import com.alcatrazescapee.notreepunching.util.Helpers;
import com.alcatrazescapee.notreepunching.util.ISlotCallback;
import com.alcatrazescapee.notreepunching.util.ItemStackHandlerCallback;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackItemHandler
implements ICapabilitySerializable<CompoundNBT>,
ISlotCallback {
    protected final LazyOptional<IItemHandler> capability;
    protected final ItemStackHandler inventory;
    protected final ItemStack stack;

    public ItemStackItemHandler(@Nullable CompoundNBT capNbt, ItemStack stack, int slots) {
        this.stack = stack;
        this.inventory = new ItemStackHandlerCallback(this, slots);
        this.capability = LazyOptional.of(() -> this.inventory);
        this.deserializeNBT(capNbt);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        this.stack.func_77983_a("inventory", (INBT)this.inventory.serializeNBT());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return Helpers.getCapabilityOrElse(cap, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.capability);
    }

    public CompoundNBT serializeNBT() {
        return this.inventory.serializeNBT();
    }

    public void deserializeNBT(@Nullable CompoundNBT nbt) {
        if (nbt != null) {
            this.inventory.deserializeNBT(nbt);
            this.stack.func_77983_a("inventory", (INBT)nbt);
        }
    }
}

