/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.world;

import com.alcatrazescapee.notreepunching.common.ModTags;
import com.alcatrazescapee.notreepunching.common.blocks.ModBlocks;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.util.Lazy;

public class LooseRocksFeature
extends Feature<NoFeatureConfig> {
    private static final Lazy<Map<Block, Supplier<? extends Block>>> LOOSE_ROCK_STONE_LOOKUP = Lazy.of(() -> new ImmutableMap.Builder().put((Object)Blocks.field_150348_b, ModBlocks.STONE_LOOSE_ROCK).put((Object)Blocks.field_196656_g, ModBlocks.ANDESITE_LOOSE_ROCK).put((Object)Blocks.field_196654_e, ModBlocks.DIORITE_LOOSE_ROCK).put((Object)Blocks.field_196650_c, ModBlocks.GRANITE_LOOSE_ROCK).put((Object)Blocks.field_150322_A, ModBlocks.SANDSTONE_LOOSE_ROCK).put((Object)Blocks.field_180395_cM, ModBlocks.RED_SANDSTONE_LOOSE_ROCK).put((Object)Blocks.field_150405_ch, ModBlocks.RED_SANDSTONE_LOOSE_ROCK).put((Object)Blocks.field_150354_m, ModBlocks.SANDSTONE_LOOSE_ROCK).put((Object)Blocks.field_196611_F, ModBlocks.RED_SANDSTONE_LOOSE_ROCK).build());

    public LooseRocksFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean place(ISeedReader worldIn, ChunkGenerator chunkGenerator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockState stateAt = worldIn.func_180495_p(pos);
        BlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
        if (stateAt.func_196958_f() && ModTags.Blocks.LOOSE_ROCK_PLACEABLE_ON.func_230235_a_((Object)stateDown.func_177230_c())) {
            for (int y = 1; y <= 8; ++y) {
                BlockPos stonePos = pos.func_177979_c(y);
                BlockState stoneState = worldIn.func_180495_p(stonePos);
                if (!((Map)LOOSE_ROCK_STONE_LOOKUP.get()).containsKey(stoneState.func_177230_c())) continue;
                Block looseRockBlock = (Block)((Supplier)((Map)LOOSE_ROCK_STONE_LOOKUP.get()).get(stoneState.func_177230_c())).get();
                worldIn.func_180501_a(pos, looseRockBlock.func_176223_P(), 3);
                return true;
            }
        }
        return true;
    }
}

